/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.testfixtures;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;

public class TestFixtureExtension {
    private final Project project;
    final NamedDomainObjectContainer<Project> fixtures;
    final Map<String, String> serviceToProjectUseMap = new HashMap<String, String>();

    public TestFixtureExtension(Project project) {
        this.project = project;
        this.fixtures = project.container(Project.class);
    }

    public void useFixture() {
        this.useFixture(this.project.getPath());
    }

    public void useFixture(String path) {
        this.addFixtureProject(path);
        this.serviceToProjectUseMap.put(path, this.project.getPath());
    }

    public void useFixture(String path, String serviceName) {
        this.addFixtureProject(path);
        String key = this.getServiceNameKey(path, serviceName);
        this.serviceToProjectUseMap.put(key, this.project.getPath());
        Optional<String> otherProject = this.findOtherProjectUsingService(key);
        if (otherProject.isPresent()) {
            String exceptionMessage = String.format("Projects %s and %s both claim the %s service defined in the docker-compose.yml of %s. This is not supported because it breaks running in parallel. Configure dedicated services for each project and use those instead.", otherProject.get(), this.project.getPath(), serviceName, path);
            throw new GradleException(exceptionMessage);
        }
    }

    private String getServiceNameKey(String fixtureProjectPath, String serviceName) {
        return fixtureProjectPath + "::" + serviceName;
    }

    private Optional<String> findOtherProjectUsingService(String serviceName) {
        return this.project.getRootProject().getAllprojects().stream().filter(p -> !p.equals((Object)this.project)).filter(p -> p.getExtensions().findByType(TestFixtureExtension.class) != null).map(project -> (TestFixtureExtension)project.getExtensions().getByType(TestFixtureExtension.class)).flatMap(ext -> ext.serviceToProjectUseMap.entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals(serviceName)).map(Map.Entry::getValue).findAny();
    }

    private void addFixtureProject(String path) {
        Project fixtureProject = this.project.findProject(path);
        if (fixtureProject == null) {
            throw new IllegalArgumentException("Could not find test fixture " + String.valueOf(fixtureProject));
        }
        if (!fixtureProject.file((Object)"docker-compose.yml").exists()) {
            throw new IllegalArgumentException("Project " + path + " is not a valid test fixture: missing docker-compose.yml");
        }
        this.fixtures.add((Object)fixtureProject);
        Optional<String> otherProject = this.findOtherProjectUsingService(path);
        if (otherProject.isPresent()) {
            String exceptionMessage = String.format("Projects %s and %s both claim all services from %s. This is not supported because it breaks running in parallel. Configure specific services in docker-compose.yml for each and add the service name to `useFixture`", otherProject.get(), this.project.getPath(), path);
            throw new GradleException(exceptionMessage);
        }
    }

    boolean isServiceRequired(String serviceName, String fixtureProject) {
        if (this.serviceToProjectUseMap.containsKey(fixtureProject)) {
            return true;
        }
        return this.serviceToProjectUseMap.containsKey(this.getServiceNameKey(fixtureProject, serviceName));
    }
}

