/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.testclusters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.opensearch.gradle.testclusters.OpenSearchCluster;

public abstract class TestClustersRegistry
implements BuildService<BuildServiceParameters.None> {
    private static final Logger logger = Logging.getLogger(TestClustersRegistry.class);
    private static final String TESTCLUSTERS_INSPECT_FAILURE = "testclusters.inspect.failure";
    private final Boolean allowClusterToSurvive = Boolean.valueOf(System.getProperty("testclusters.inspect.failure", "false"));
    private final Map<OpenSearchCluster, Integer> claimsInventory = new HashMap<OpenSearchCluster, Integer>();
    private final Set<OpenSearchCluster> runningClusters = new HashSet<OpenSearchCluster>();

    public void claimCluster(OpenSearchCluster cluster) {
        cluster.freeze();
        this.claimsInventory.put(cluster, this.claimsInventory.getOrDefault(cluster, 0) + 1);
    }

    public void maybeStartCluster(OpenSearchCluster cluster) {
        if (this.runningClusters.contains(cluster)) {
            return;
        }
        this.runningClusters.add(cluster);
        cluster.start();
    }

    public void stopCluster(OpenSearchCluster cluster, boolean taskFailed) {
        if (taskFailed) {
            if (this.allowClusterToSurvive.booleanValue()) {
                logger.info("Not stopping clusters, disabled by property");
                int i = 1;
                while (true) {
                    logger.lifecycle("No more test clusters left to run, going to sleep because {} was set, interrupt (^C) to stop clusters.", new Object[]{TESTCLUSTERS_INSPECT_FAILURE});
                    try {
                        Thread.sleep(1000 * i);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    i += i;
                }
            }
            cluster.stop(true);
            this.runningClusters.remove(cluster);
        } else {
            int currentClaims = this.claimsInventory.getOrDefault(cluster, 0) - 1;
            this.claimsInventory.put(cluster, currentClaims);
            if (currentClaims <= 0 && this.runningClusters.contains(cluster)) {
                cluster.stop(false);
                this.runningClusters.remove(cluster);
            }
        }
    }
}

