/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test.rest;

import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;
import org.opensearch.gradle.VersionProperties;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.test.RestIntegTestTask;
import org.opensearch.gradle.testclusters.OpenSearchCluster;

public class RestTestUtil {
    private RestTestUtil() {
    }

    static OpenSearchCluster createTestCluster(Project project, SourceSet sourceSet) {
        NamedDomainObjectContainer testClusters = (NamedDomainObjectContainer)project.getExtensions().getByName("testClusters");
        return (OpenSearchCluster)testClusters.create(sourceSet.getName());
    }

    static Provider<RestIntegTestTask> registerTask(Project project, SourceSet sourceSet) {
        TaskProvider testProvider = project.getTasks().register(sourceSet.getName(), RestIntegTestTask.class, testTask -> {
            testTask.setGroup("verification");
            testTask.setDescription("Runs the REST tests against an external cluster");
            testTask.mustRunAfter(new Object[]{project.getTasks().named("test")});
            testTask.setTestClassesDirs(sourceSet.getOutput().getClassesDirs());
            testTask.setClasspath(sourceSet.getRuntimeClasspath());
            project.getPluginManager().withPlugin("opensearch.opensearchplugin", plugin -> {
                Zip bundle = (Zip)project.getTasks().getByName("bundlePlugin");
                testTask.dependsOn(bundle);
                if (project.getPath().contains("modules:")) {
                    testTask.getClusters().forEach(c -> c.module((Provider<RegularFile>)bundle.getArchiveFile()));
                } else {
                    testTask.getClusters().forEach(c -> c.plugin((Provider<RegularFile>)project.getObjects().fileProperty().value(bundle.getArchiveFile())));
                }
            });
        });
        return testProvider;
    }

    static void setupDependencies(Project project, SourceSet sourceSet) {
        if (BuildParams.isInternal().booleanValue()) {
            project.getDependencies().add(sourceSet.getImplementationConfigurationName(), (Object)project.project(":test:framework"));
        } else {
            project.getDependencies().add(sourceSet.getImplementationConfigurationName(), (Object)("org.opensearch.test:framework:" + VersionProperties.getOpenSearch()));
            project.getDependencies().add(sourceSet.getImplementationConfigurationName(), (Object)("org.apache.logging.log4j:log4j-core:" + VersionProperties.getVersions().get("log4j")));
        }
    }
}

