/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test.rest;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.opensearch.gradle.VersionProperties;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.util.GradleUtils;

public class CopyRestApiTask
extends DefaultTask {
    private static final String REST_API_PREFIX = "rest-api-spec/api";
    final ListProperty<String> includeCore;
    String sourceSetName;
    boolean skipHasRestTestCheck;
    Configuration coreConfig;
    Configuration additionalConfig;
    private final Project project;
    private final PatternFilterable corePatternSet;

    @Inject
    public CopyRestApiTask(Project project) {
        this.project = project;
        this.corePatternSet = new PatternSet();
        this.includeCore = project.getObjects().listProperty(String.class);
    }

    @Inject
    protected FileSystemOperations getFileSystemOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ArchiveOperations getArchiveOperations() {
        throw new UnsupportedOperationException();
    }

    @Input
    public ListProperty<String> getIncludeCore() {
        return this.includeCore;
    }

    @Input
    String getSourceSetName() {
        return this.sourceSetName;
    }

    @Input
    public boolean isSkipHasRestTestCheck() {
        return this.skipHasRestTestCheck;
    }

    @IgnoreEmptyDirectories
    @SkipWhenEmpty
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getInputDir() {
        boolean projectHasYamlRestTests;
        FileTree coreFileTree = null;
        boolean bl = projectHasYamlRestTests = this.skipHasRestTestCheck || this.projectHasYamlRestTests();
        if (!((List)this.includeCore.get()).isEmpty() || projectHasYamlRestTests) {
            if (BuildParams.isInternal().booleanValue()) {
                this.corePatternSet.setIncludes((Iterable)((List)this.includeCore.get()).stream().map(prefix -> prefix + "*/**").collect(Collectors.toList()));
                coreFileTree = this.coreConfig.getAsFileTree().matching(this.corePatternSet);
            } else {
                coreFileTree = this.coreConfig.getAsFileTree();
            }
        }
        ConfigurableFileCollection fileCollection = this.additionalConfig == null ? this.project.files(new Object[]{coreFileTree}) : this.project.files(new Object[]{coreFileTree, this.additionalConfig.getAsFileTree()});
        return projectHasYamlRestTests || !((List)this.includeCore.get()).isEmpty() ? fileCollection.getAsFileTree() : null;
    }

    @OutputDirectory
    public File getOutputDir() {
        return new File(this.getSourceSet().orElseThrow(() -> new IllegalArgumentException("could not find source set [" + this.sourceSetName + "]")).getOutput().getResourcesDir(), REST_API_PREFIX);
    }

    @TaskAction
    void copy() {
        String projectPath = GradleUtils.getProjectPathFromTask(this.getPath());
        if (BuildParams.isInternal().booleanValue()) {
            this.getLogger().debug("Rest specs for project [{}] will be copied to the test resources.", (Object)projectPath);
            this.getFileSystemOperations().copy(c -> {
                c.from(new Object[]{this.coreConfig.getAsFileTree()});
                c.into((Object)this.getOutputDir());
                c.include((Iterable)this.corePatternSet.getIncludes());
            });
        } else {
            this.getLogger().debug("Rest specs for project [{}] will be copied to the test resources from the published jar (version: [{}]).", (Object)projectPath, (Object)VersionProperties.getOpenSearch());
            this.getFileSystemOperations().copy(c -> {
                c.from(new Object[]{this.getArchiveOperations().zipTree((Object)this.coreConfig.getSingleFile())});
                c.into((Object)Objects.requireNonNull(this.getSourceSet().get().getOutput().getResourcesDir()));
                if (((List)this.includeCore.get()).isEmpty()) {
                    c.include(new String[]{"rest-api-spec/api/**"});
                } else {
                    c.include((Iterable)((List)this.includeCore.get()).stream().map(prefix -> "rest-api-spec/api/" + prefix + "*/**").collect(Collectors.toList()));
                }
            });
        }
        if (this.additionalConfig != null) {
            this.getFileSystemOperations().copy(c -> {
                c.from(new Object[]{this.additionalConfig.getAsFileTree()});
                c.into((Object)this.getOutputDir());
            });
        }
    }

    private boolean projectHasYamlRestTests() {
        File testSourceResourceDir = this.getTestSourceResourceDir();
        File testOutputResourceDir = this.getTestOutputResourceDir();
        if (testSourceResourceDir == null && testOutputResourceDir == null) {
            return false;
        }
        try {
            if (testSourceResourceDir != null && new File(testSourceResourceDir, "rest-api-spec/test").exists()) {
                return Files.walk(testSourceResourceDir.toPath().resolve("rest-api-spec/test"), new FileVisitOption[0]).anyMatch(p -> p.getFileName().toString().endsWith("yml"));
            }
            if (testOutputResourceDir != null && new File(testOutputResourceDir, "rest-api-spec/test").exists()) {
                return Files.walk(testOutputResourceDir.toPath().resolve("rest-api-spec/test"), new FileVisitOption[0]).anyMatch(p -> p.getFileName().toString().endsWith("yml"));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error determining if this project [%s] has rest tests.", this.project), e);
        }
        return false;
    }

    private File getTestSourceResourceDir() {
        Optional<SourceSet> testSourceSet = this.getSourceSet();
        if (testSourceSet.isPresent()) {
            SourceSet testSources = testSourceSet.get();
            Set resourceDir = testSources.getResources().getSrcDirs().stream().filter(f -> f.isDirectory() && f.getParentFile().getName().equals(this.getSourceSetName()) && f.getName().equals("resources")).collect(Collectors.toSet());
            assert (resourceDir.size() <= 1);
            if (resourceDir.size() == 0) {
                return null;
            }
            return (File)resourceDir.iterator().next();
        }
        return null;
    }

    private File getTestOutputResourceDir() {
        Optional<SourceSet> testSourceSet = this.getSourceSet();
        return testSourceSet.map(sourceSet -> sourceSet.getOutput().getResourcesDir()).orElse(null);
    }

    private Optional<SourceSet> getSourceSet() {
        return this.project.getExtensions().findByType(JavaPluginExtension.class) == null ? Optional.empty() : Optional.ofNullable((SourceSet)GradleUtils.getJavaSourceSets(this.project).findByName(this.getSourceSetName()));
    }
}

