/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.output.NullOutputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.opensearch.gradle.LoggedExec;
import org.opensearch.gradle.OS;
import org.opensearch.gradle.util.GradleUtils;

@CacheableTask
public class ThirdPartyAuditTask
extends DefaultTask {
    private static final Pattern MISSING_CLASS_PATTERN = Pattern.compile("DEBUG: Class '(.*)' cannot be loaded \\(.*\\)\\.");
    private static final Pattern VIOLATION_PATTERN = Pattern.compile("\\s\\sin ([a-zA-Z0-9$.]+) \\(.*\\)");
    private static final int SIG_KILL_EXIT_VALUE = 137;
    private static final List<Integer> EXPECTED_EXIT_CODES = Arrays.asList(0, 1, 3);
    private static final String JDK_JAR_HELL_MAIN_CLASS = "org.opensearch.common.bootstrap.JdkJarHellCheck";
    private Set<String> missingClassExcludes = new TreeSet<String>();
    private Set<String> violationsExcludes = new TreeSet<String>();
    private Set<String> jdkJarHellExcludes = new TreeSet<String>();
    private File signatureFile;
    private String javaHome;
    private FileCollection jdkJarHellClasspath;
    private final Project project;
    private final Property<JavaVersion> targetCompatibility;
    public boolean jarHellEnabled = true;

    @Inject
    public ThirdPartyAuditTask(Project project) {
        this.project = project;
        this.targetCompatibility = project.getObjects().property(JavaVersion.class);
    }

    @Input
    public Property<JavaVersion> getTargetCompatibility() {
        return this.targetCompatibility;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public Configuration getForbiddenAPIsConfiguration() {
        return this.project.getConfigurations().getByName("forbiddenApisCliJar");
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public File getSignatureFile() {
        return this.signatureFile;
    }

    public void setSignatureFile(File signatureFile) {
        this.signatureFile = signatureFile;
    }

    @Input
    @Optional
    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    @Internal
    public File getJarExpandDir() {
        return new File(new File(this.project.getBuildDir(), "precommit/thirdPartyAudit"), this.getName());
    }

    @OutputFile
    public File getSuccessMarker() {
        return new File(this.project.getBuildDir(), "markers/" + this.getName());
    }

    @CompileClasspath
    public FileCollection getJdkJarHellClasspath() {
        return this.jdkJarHellClasspath.filter(File::exists);
    }

    public void setJdkJarHellClasspath(FileCollection jdkJarHellClasspath) {
        this.jdkJarHellClasspath = jdkJarHellClasspath;
    }

    public void ignoreMissingClasses(String ... classesOrPackages) {
        if (classesOrPackages.length == 0) {
            this.missingClassExcludes = null;
            return;
        }
        if (this.missingClassExcludes == null) {
            this.missingClassExcludes = new TreeSet<String>();
        }
        for (String each : classesOrPackages) {
            this.missingClassExcludes.add(each);
        }
    }

    public void ignoreViolations(String ... violatingClasses) {
        for (String each : violatingClasses) {
            this.violationsExcludes.add(each);
        }
    }

    public void ignoreJarHellWithJDK(String ... classes) {
        for (String each : classes) {
            this.jdkJarHellExcludes.add(each);
        }
    }

    @Input
    public Set<String> getJdkJarHellExcludes() {
        return this.jdkJarHellExcludes;
    }

    @Input
    @Optional
    public Set<String> getMissingClassExcludes() {
        return this.missingClassExcludes;
    }

    @Classpath
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    public Set<File> getJarsToScan() {
        Spec reallyThirdParty = ci -> {
            if (ci instanceof ModuleComponentIdentifier) {
                return !((ModuleComponentIdentifier)ci).getGroup().startsWith("org.opensearch");
            }
            return false;
        };
        FileCollection runtime = GradleUtils.getFirstLevelModuleDependencyFiles(this.project, this.getRuntimeConfiguration(), (Spec<? super ComponentIdentifier>)reallyThirdParty);
        FileCollection compileOnly = GradleUtils.getFirstLevelModuleDependencyFiles(this.project, this.project.getConfigurations().getByName("resolveableCompileOnly"), (Spec<? super ComponentIdentifier>)reallyThirdParty);
        return runtime.minus(compileOnly).getFiles();
    }

    @TaskAction
    public void runThirdPartyAudit() throws IOException {
        Set<File> jars = this.getJarsToScan();
        Set<File> extractedJars = this.extractJars(jars);
        String forbiddenApisOutput = this.runForbiddenAPIsCli();
        TreeSet<String> missingClasses = new TreeSet<String>();
        Matcher missingMatcher = MISSING_CLASS_PATTERN.matcher(forbiddenApisOutput);
        while (missingMatcher.find()) {
            missingClasses.add(missingMatcher.group(1));
        }
        TreeSet<String> violationsClasses = new TreeSet<String>();
        Matcher violationMatcher = VIOLATION_PATTERN.matcher(forbiddenApisOutput);
        while (violationMatcher.find()) {
            violationsClasses.add(violationMatcher.group(1));
        }
        Set<String> jdkJarHellClasses = null;
        if (this.jarHellEnabled) {
            jdkJarHellClasses = this.runJdkJarHellCheck(extractedJars);
        }
        if (this.missingClassExcludes != null) {
            this.assertNoPointlessExclusions("are not missing", this.missingClassExcludes, missingClasses);
            long bogousExcludesCount = Stream.concat(this.missingClassExcludes.stream(), this.violationsExcludes.stream()).filter(each -> !missingClasses.contains(each)).filter(each -> !violationsClasses.contains(each)).count();
            if (bogousExcludesCount != 0L && bogousExcludesCount == (long)(this.missingClassExcludes.size() + this.violationsExcludes.size())) {
                this.logForbiddenAPIsOutput(forbiddenApisOutput);
                throw new IllegalStateException("All excluded classes seem to have no issues. This is sometimes an indication that the check silently failed");
            }
            missingClasses.removeAll(this.missingClassExcludes);
        }
        this.assertNoPointlessExclusions("have no violations", this.violationsExcludes, violationsClasses);
        if (this.jarHellEnabled) {
            this.assertNoPointlessExclusions("do not generate jar hell with the JDK", this.jdkJarHellExcludes, jdkJarHellClasses);
        }
        if (this.missingClassExcludes == null && !missingClasses.isEmpty()) {
            this.getLogger().info("Found missing classes, but task is configured to ignore all of them:\n {}", (Object)this.formatClassList(missingClasses));
            missingClasses.clear();
        }
        violationsClasses.removeAll(this.violationsExcludes);
        if (!missingClasses.isEmpty() || !violationsClasses.isEmpty()) {
            if (!missingClasses.isEmpty()) {
                this.getLogger().error("Missing classes:\n{}", (Object)this.formatClassList(missingClasses));
            }
            if (!violationsClasses.isEmpty()) {
                this.getLogger().error("Classes with violations:\n{}", (Object)this.formatClassList(violationsClasses));
            }
            throw new IllegalStateException("Audit of third party dependencies failed");
        }
        this.getLogger().info("Third party audit passed successfully");
        if (this.jarHellEnabled) {
            this.assertNoJarHell(jdkJarHellClasses);
        }
        this.getSuccessMarker().getParentFile().mkdirs();
        Files.write(this.getSuccessMarker().toPath(), new byte[0], new OpenOption[0]);
    }

    private void logForbiddenAPIsOutput(String forbiddenApisOutput) {
        this.getLogger().error("Forbidden APIs output:\n{}==end of forbidden APIs==", (Object)forbiddenApisOutput);
    }

    private Set<File> extractJars(Set<File> jars) {
        TreeSet<File> extractedJars = new TreeSet<File>();
        File jarExpandDir = this.getJarExpandDir();
        this.project.delete(new Object[]{jarExpandDir});
        jars.forEach(jar -> {
            String jarPrefix = jar.getName().replace(".jar", "");
            File jarSubDir = new File(jarExpandDir, jarPrefix);
            extractedJars.add(jarSubDir);
            FileTree jarFiles = this.project.zipTree(jar);
            this.project.copy(spec -> {
                spec.from(new Object[]{jarFiles});
                spec.into((Object)jarSubDir);
                spec.exclude(new String[]{"META-INF/versions/**"});
            });
            IntStream.rangeClosed(Integer.parseInt(JavaVersion.VERSION_1_9.getMajorVersion()), Integer.parseInt(((JavaVersion)this.targetCompatibility.get()).getMajorVersion())).forEach(majorVersion -> this.project.copy(spec -> {
                spec.from(new Object[]{this.project.zipTree(jar)});
                spec.into((Object)jarSubDir);
                String metaInfPrefix = "META-INF/versions/" + majorVersion;
                spec.include(new String[]{metaInfPrefix + "/**"});
                spec.eachFile(details -> details.setPath(details.getPath().replace(metaInfPrefix, "")));
                spec.setIncludeEmptyDirs(false);
            }));
        });
        return extractedJars;
    }

    private void assertNoJarHell(Set<String> jdkJarHellClasses) {
        jdkJarHellClasses.removeAll(this.jdkJarHellExcludes);
        if (!jdkJarHellClasses.isEmpty()) {
            throw new IllegalStateException("Audit of third party dependencies failed:\n  Jar Hell with the JDK:\n" + this.formatClassList(jdkJarHellClasses));
        }
    }

    private void assertNoPointlessExclusions(String specifics, Set<String> excludes, Set<String> problematic) {
        String notMissing = excludes.stream().filter(each -> !problematic.contains(each)).map(each -> "  * " + each).collect(Collectors.joining("\n"));
        if (!notMissing.isEmpty()) {
            this.getLogger().error("Unnecessary exclusions, following classes " + specifics + ":\n {}", (Object)notMissing);
            throw new IllegalStateException("Third party audit task is not configured correctly");
        }
    }

    private String formatClassList(Set<String> classList) {
        return classList.stream().map(name -> "  * " + name).sorted().collect(Collectors.joining("\n"));
    }

    private String runForbiddenAPIsCli() throws IOException {
        String forbiddenApisOutput;
        ByteArrayOutputStream errorOut = new ByteArrayOutputStream();
        InjectedExecOps execOps = (InjectedExecOps)this.project.getObjects().newInstance(InjectedExecOps.class, new Object[0]);
        ExecResult result = execOps.getExecOps().javaexec(spec -> {
            if (this.javaHome != null) {
                spec.setExecutable(this.javaHome + "/bin/java");
            }
            spec.classpath(new Object[]{this.getForbiddenAPIsConfiguration(), this.getRuntimeConfiguration(), this.project.getConfigurations().getByName("resolveableCompileOnly")});
            spec.jvmArgs(new Object[]{"-Xmx1g"});
            spec.jvmArgs(LoggedExec.shortLivedArgs());
            spec.getMainClass().set((Object)"de.thetaphi.forbiddenapis.cli.CliMain");
            spec.args(new Object[]{"-f", this.getSignatureFile().getAbsolutePath(), "-d", this.getJarExpandDir(), "--debug", "--allowmissingclasses"});
            spec.setErrorOutput((OutputStream)errorOut);
            if (!this.getLogger().isInfoEnabled()) {
                spec.setStandardOutput((OutputStream)new NullOutputStream());
            }
            spec.setIgnoreExitValue(true);
        });
        if (OS.current().equals((Object)OS.LINUX) && result.getExitValue() == 137) {
            throw new IllegalStateException("Third party audit was killed buy SIGKILL, could be a victim of the Linux OOM killer");
        }
        try (ByteArrayOutputStream outputStream = errorOut;){
            forbiddenApisOutput = outputStream.toString(StandardCharsets.UTF_8.name());
        }
        if (!EXPECTED_EXIT_CODES.contains(result.getExitValue())) {
            throw new IllegalStateException("Forbidden APIs cli failed: " + forbiddenApisOutput);
        }
        return forbiddenApisOutput;
    }

    private Set<String> runJdkJarHellCheck(Set<File> jars) throws IOException {
        String jdkJarHellCheckList;
        ByteArrayOutputStream standardOut = new ByteArrayOutputStream();
        InjectedExecOps execOps = (InjectedExecOps)this.project.getObjects().newInstance(InjectedExecOps.class, new Object[0]);
        ExecResult execResult = execOps.getExecOps().javaexec(spec -> {
            spec.classpath(new Object[]{this.jdkJarHellClasspath, this.getRuntimeConfiguration(), this.project.getConfigurations().getByName("resolveableCompileOnly")});
            spec.getMainClass().set((Object)JDK_JAR_HELL_MAIN_CLASS);
            spec.args((Iterable)jars);
            spec.setIgnoreExitValue(true);
            if (this.javaHome != null) {
                spec.setExecutable(this.javaHome + "/bin/java");
            }
            spec.setStandardOutput((OutputStream)standardOut);
        });
        if (execResult.getExitValue() == 0) {
            return Collections.emptySet();
        }
        try (ByteArrayOutputStream outputStream = standardOut;){
            jdkJarHellCheckList = outputStream.toString(StandardCharsets.UTF_8.name());
        }
        return new TreeSet<String>(Arrays.asList(jdkJarHellCheckList.split("\\r?\\n")));
    }

    private Configuration getRuntimeConfiguration() {
        Configuration runtime = (Configuration)this.project.getConfigurations().findByName("runtimeClasspath");
        if (runtime == null) {
            return this.project.getConfigurations().getByName("testCompileClasspath");
        }
        return runtime;
    }

    static interface InjectedExecOps {
        @Inject
        public ExecOperations getExecOps();
    }
}

