/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class TestingConventionRule
implements Serializable {
    private final String suffix;
    private Set<String> baseClasses = new HashSet<String>();
    private Set<Pattern> taskNames = new HashSet<Pattern>();

    public TestingConventionRule(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getName() {
        return this.suffix;
    }

    public void baseClass(String clazz) {
        this.baseClasses.add(clazz);
    }

    public void setBaseClasses(Collection<String> baseClasses) {
        this.baseClasses.clear();
        this.baseClasses.addAll(baseClasses);
    }

    public void taskName(Pattern expression) {
        this.taskNames.add(expression);
    }

    public void taskName(String expression) {
        this.taskNames.add(Pattern.compile(expression));
    }

    public void setTaskNames(Collection<Pattern> expressions) {
        this.taskNames.clear();
        this.taskNames.addAll(expressions);
    }

    public Set<String> getBaseClasses() {
        return this.baseClasses;
    }

    public Set<Pattern> getTaskNames() {
        return this.taskNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestingConventionRule that = (TestingConventionRule)o;
        return Objects.equals(this.suffix, that.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.suffix);
    }
}

