/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class LicenseAnalyzer {
    private static final LicenseMatcher[] matchers = new LicenseMatcher[]{new LicenseMatcher("Apache-2.0", true, false, Pattern.compile("Apache.*License.*[vV]ersion.*2\\.0", 32)), new LicenseMatcher("BSD-2-Clause", true, false, Pattern.compile("Redistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\n 1\\. Redistributions of source code must retain the above copyright\n    notice, this list of conditions and the following disclaimer\\.\n 2\\. Redistributions in binary form must reproduce the above copyright\n    notice, this list of conditions and the following disclaimer in the\n    documentation and/or other materials provided with the distribution\\.\n\nTHIS SOFTWARE IS PROVIDED BY .+ (``|''|\")AS IS(''|\") AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED\\.\nIN NO EVENT SHALL .+ BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES \\(INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION\\) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n\\(INCLUDING NEGLIGENCE OR OTHERWISE\\) ARISING IN ANY WAY OUT OF THE USE OF\nTHIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE\\.".replaceAll("\\s+", "\\\\s*"), 32)), new LicenseMatcher("BSD-3-Clause", true, false, Pattern.compile("\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\n (1\\.)? Redistributions of source code must retain the above copyright\n    notice, this list of conditions and the following disclaimer\\.\n (2\\.)? Redistributions in binary form must reproduce the above copyright\n    notice, this list of conditions and the following disclaimer in the\n    documentation and/or other materials provided with the distribution\\.\n ((3\\.)? The name of .+ may not be used to endorse or promote products\n    derived from this software without specific prior written permission\\.|\n  (3\\.)? Neither the name of .+ nor the names of its\n     contributors may be used to endorse or promote products derived from\n     this software without specific prior written permission\\.)\n\nTHIS SOFTWARE IS PROVIDED BY .+ (``|''|\")AS IS(''|\") AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED\\.\nIN NO EVENT SHALL .+ BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES \\(INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION\\) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n\\(INCLUDING NEGLIGENCE OR OTHERWISE\\) ARISING IN ANY WAY OUT OF THE USE OF\nTHIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE\\.\n".replaceAll("\\s+", "\\\\s*"), 32)), new LicenseMatcher("CDDL-1.0", true, false, Pattern.compile("COMMON DEVELOPMENT AND DISTRIBUTION LICENSE.*Version 1.0", 32)), new LicenseMatcher("CDDL-1.1", true, false, Pattern.compile("COMMON DEVELOPMENT AND DISTRIBUTION LICENSE.*Version 1.1", 32)), new LicenseMatcher("ICU", true, false, Pattern.compile("ICU License - ICU 1.8.1 and later", 32)), new LicenseMatcher("MIT", true, false, Pattern.compile("\nPermission is hereby granted, free of charge, to any person obtaining a copy of\nthis software and associated documentation files \\(the \"Software\"\\), to deal in\nthe Software without restriction, including without limitation the rights to\nuse, copy, modify, merge, publish, distribute, sublicense, and/or sell copies\nof the Software, and to permit persons to whom the Software is furnished to do\nso, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software\\.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT\\. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE\\.?\n".replaceAll("\\s+", "\\\\s*"), 32)), new LicenseMatcher("MPL-1.1", true, false, Pattern.compile("Mozilla Public License.*Version 1.1", 32)), new LicenseMatcher("MPL-2.0", true, false, Pattern.compile("Mozilla\\s*Public\\s*License\\s*Version\\s*2\\.0", 32)), new LicenseMatcher("XZ", false, false, Pattern.compile("Licensing of XZ for Java", 32)), new LicenseMatcher("EPL-2.0", true, false, Pattern.compile("Eclipse Public License - v 2.0", 32)), new LicenseMatcher("LGPL-2.1", true, true, Pattern.compile("GNU LESSER GENERAL PUBLIC LICENSE.*Version 2.1", 32)), new LicenseMatcher("LGPL-3.0", true, true, Pattern.compile("GNU LESSER GENERAL PUBLIC LICENSE.*Version 3", 32))};

    public static LicenseInfo licenseType(File licenseFile) {
        for (LicenseMatcher matcher : matchers) {
            boolean matches = matcher.matches(licenseFile);
            if (!matches) continue;
            return new LicenseInfo(matcher.getIdentifier(), matcher.spdxLicense, matcher.sourceRedistributionRequired);
        }
        throw new IllegalStateException("Unknown license for license file: " + String.valueOf(licenseFile));
    }

    private static class LicenseMatcher {
        private final String identifier;
        private final boolean spdxLicense;
        private final boolean sourceRedistributionRequired;
        private final Pattern pattern;

        LicenseMatcher(String identifier, boolean spdxLicense, boolean sourceRedistributionRequired, Pattern pattern) {
            this.identifier = identifier;
            this.spdxLicense = spdxLicense;
            this.sourceRedistributionRequired = sourceRedistributionRequired;
            this.pattern = pattern;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean matches(File licenseFile) {
            boolean bl;
            FileInputStream fis = new FileInputStream(licenseFile);
            try {
                String content = String.join((CharSequence)"\n", IOUtils.readLines((InputStream)fis, (String)"UTF-8")).replaceAll("\\*", " ");
                bl = this.pattern.matcher(content).find();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            fis.close();
            return bl;
        }
    }

    public static class LicenseInfo {
        private final String identifier;
        private final boolean spdxLicense;
        private final boolean sourceRedistributionRequired;

        public LicenseInfo(String identifier, boolean spdxLicense, boolean sourceRedistributionRequired) {
            this.identifier = identifier;
            this.spdxLicense = spdxLicense;
            this.sourceRedistributionRequired = sourceRedistributionRequired;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean isSpdxLicense() {
            return this.spdxLicense;
        }

        public boolean isSourceRedistributionRequired() {
            return this.sourceRedistributionRequired;
        }
    }
}

