/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.VersionProperties;
import org.opensearch.gradle.internal.DistributionArchiveCheckExtension;
import org.opensearch.gradle.internal.InternalDistributionArchiveSetupPlugin;
import org.opensearch.gradle.util.Util;

public class InternalDistributionArchiveCheckPlugin
implements Plugin<Project> {
    private ArchiveOperations archiveOperations;

    @Inject
    public InternalDistributionArchiveCheckPlugin(ArchiveOperations archiveOperations) {
        this.archiveOperations = archiveOperations;
    }

    public void apply(Project project) {
        project.getPlugins().apply(BasePlugin.class);
        String buildTaskName = this.calculateBuildTask(project.getName());
        TaskProvider buildDistTask = project.getParent().getTasks().named(buildTaskName);
        DistributionArchiveCheckExtension distributionArchiveCheckExtension = (DistributionArchiveCheckExtension)project.getExtensions().create("distributionArchiveCheck", DistributionArchiveCheckExtension.class, new Object[0]);
        File archiveExtractionDir = this.calculateArchiveExtractionDir(project);
        TaskProvider<Copy> checkExtraction = this.registerCheckExtractionTask(project, (TaskProvider<Task>)buildDistTask, archiveExtractionDir);
        checkExtraction.configure(InternalDistributionArchiveSetupPlugin.configure(buildTaskName));
        TaskProvider<Task> checkLicense = this.registerCheckLicenseTask(project, checkExtraction);
        checkLicense.configure(InternalDistributionArchiveSetupPlugin.configure(buildTaskName));
        TaskProvider<Task> checkNotice = this.registerCheckNoticeTask(project, checkExtraction);
        checkNotice.configure(InternalDistributionArchiveSetupPlugin.configure(buildTaskName));
        TaskProvider checkTask = project.getTasks().named("check");
        checkTask.configure(task -> {
            task.dependsOn(new Object[]{checkExtraction});
            task.dependsOn(new Object[]{checkLicense});
            task.dependsOn(new Object[]{checkNotice});
        });
    }

    private File calculateArchiveExtractionDir(Project project) {
        if (project.getName().contains("tar")) {
            return new File(project.getBuildDir(), "tar-extracted");
        }
        if (!project.getName().contains("zip")) {
            throw new GradleException("Expecting project name containing 'zip' or 'tar'.");
        }
        return new File(project.getBuildDir(), "zip-extracted");
    }

    private TaskProvider<Task> registerCheckNoticeTask(Project project, final TaskProvider<Copy> checkExtraction) {
        return project.getTasks().register("checkNotice", task -> {
            task.dependsOn(new Object[]{checkExtraction});
            task.doLast((Action)new Action<Task>(){

                public void execute(Task task) {
                    List<String> noticeLines = Arrays.asList("OpenSearch (https://opensearch.org/)", "Copyright OpenSearch Contributors");
                    Path noticePath = ((Copy)checkExtraction.get()).getDestinationDir().toPath().resolve("opensearch-" + VersionProperties.getOpenSearch() + "/NOTICE.txt");
                    InternalDistributionArchiveCheckPlugin.assertLinesInFile(noticePath, noticeLines);
                }
            });
        });
    }

    private TaskProvider<Task> registerCheckLicenseTask(final Project project, final TaskProvider<Copy> checkExtraction) {
        return project.getTasks().register("checkLicense", task -> {
            task.dependsOn(new Object[]{checkExtraction});
            task.doLast((Action)new Action<Task>(){

                public void execute(Task task) {
                    String licenseFilename = "APACHE-LICENSE-2.0.txt";
                    try {
                        List<String> licenseLines = Files.readAllLines(project.getRootDir().toPath().resolve("licenses/" + licenseFilename));
                        Path licensePath = ((Copy)checkExtraction.get()).getDestinationDir().toPath().resolve("opensearch-" + VersionProperties.getOpenSearch() + "/LICENSE.txt");
                        InternalDistributionArchiveCheckPlugin.assertLinesInFile(licensePath, licenseLines);
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                }
            });
        });
    }

    private TaskProvider<Copy> registerCheckExtractionTask(Project project, TaskProvider<Task> buildDistTask, File archiveExtractionDir) {
        return project.getTasks().register("checkExtraction", Copy.class, t -> {
            t.dependsOn(new Object[]{buildDistTask});
            if (project.getName().contains("tar")) {
                t.from(new Object[]{this.archiveOperations.tarTree(this.distTaskOutput(buildDistTask))});
            } else {
                t.from(new Object[]{this.archiveOperations.zipTree(this.distTaskOutput(buildDistTask))});
            }
            t.into((Object)archiveExtractionDir);
            t.eachFile(fileCopyDetails -> InternalDistributionArchiveCheckPlugin.assertNoClassFile(fileCopyDetails.getFile()));
        });
    }

    private static void assertLinesInFile(Path path, List<String> expectedLines) {
        try {
            List<String> actualLines = Files.readAllLines(path);
            int line = 0;
            for (String expectedLine : expectedLines) {
                String actualLine;
                if (!expectedLine.equals(actualLine = actualLines.get(line))) {
                    throw new GradleException("expected line [" + (line + 1) + "] in [" + String.valueOf(path) + "] to be [" + expectedLine + "] but was [" + actualLine + "]");
                }
                ++line;
            }
        }
        catch (IOException ioException) {
            throw new GradleException("Unable to read from file " + String.valueOf(path), (Throwable)ioException);
        }
    }

    private static void assertNoClassFile(File file) {
        if (file.getName().endsWith(".class")) {
            throw new GradleException("Detected class file in distribution ('" + file.getName() + "')");
        }
    }

    private Object distTaskOutput(final TaskProvider<Task> buildDistTask) {
        return new Callable<File>(){

            @Override
            public File call() {
                return ((Task)buildDistTask.get()).getOutputs().getFiles().getSingleFile();
            }

            public String toString() {
                return this.call().getAbsolutePath();
            }
        };
    }

    private String calculateBuildTask(String projectName) {
        return "build" + Arrays.stream(projectName.split("-")).map(f -> Util.capitalize(f)).collect(Collectors.joining());
    }
}

