/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.opensearch.gradle.LoggedExec;
import org.opensearch.gradle.info.GlobalBuildInfoPlugin;
import org.opensearch.gradle.internal.BwcGitExtension;

public class InternalBwcGitPlugin
implements Plugin<Project> {
    private final ProviderFactory providerFactory;
    private final ExecOperations execOperations;
    private BwcGitExtension gitExtension;
    private Project project;

    @Inject
    public InternalBwcGitPlugin(ProviderFactory providerFactory, ExecOperations execOperations) {
        this.providerFactory = providerFactory;
        this.execOperations = execOperations;
    }

    public void apply(Project project) {
        this.project = project;
        this.gitExtension = (BwcGitExtension)project.getExtensions().create("bwcGitConfig", BwcGitExtension.class, new Object[0]);
        Provider remote = this.providerFactory.systemProperty("bwc.remote").orElse((Object)"opensearch-project");
        TaskContainer tasks = project.getTasks();
        TaskProvider createCloneTaskProvider = tasks.register("createClone", LoggedExec.class, createClone -> {
            createClone.onlyIf(task -> !((File)this.gitExtension.getCheckoutDir().get()).exists());
            createClone.setCommandLine(Arrays.asList("git", "clone", project.getRootDir(), (Serializable)this.gitExtension.getCheckoutDir().get()));
        });
        TaskProvider findRemoteTaskProvider = tasks.register("findRemote", LoggedExec.class, findRemote -> {
            findRemote.dependsOn(new Object[]{createCloneTaskProvider});
            findRemote.setWorkingDir((File)this.gitExtension.getCheckoutDir().get());
            findRemote.setCommandLine(Arrays.asList("git", "remote", "-v"));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            findRemote.setStandardOutput(output);
            findRemote.doLast(t -> {
                ExtraPropertiesExtension extraProperties = project.getExtensions().getExtraProperties();
                extraProperties.set("remoteExists", (Object)InternalBwcGitPlugin.isRemoteAvailable((Provider<String>)remote, output));
            });
        });
        TaskProvider addRemoteTaskProvider = tasks.register("addRemote", LoggedExec.class, addRemote -> {
            addRemote.dependsOn(new Object[]{findRemoteTaskProvider});
            addRemote.onlyIf(task -> (Boolean)project.getExtensions().getExtraProperties().get("remoteExists") == false);
            addRemote.setWorkingDir((File)this.gitExtension.getCheckoutDir().get());
            String remoteRepo = (String)remote.get();
            String remoteRepoUrl = (String)this.providerFactory.systemProperty("testRemoteRepo").getOrElse((Object)("https://github.com/" + remoteRepo + "/OpenSearch.git"));
            addRemote.setCommandLine(Arrays.asList("git", "remote", "add", remoteRepo, remoteRepoUrl));
        });
        TaskProvider fetchLatestTaskProvider = tasks.register("fetchLatest", LoggedExec.class, fetchLatest -> {
            Provider gitFetchLatest = project.getProviders().systemProperty("tests.bwc.git_fetch_latest").orElse((Object)"true").map(fetchProp -> {
                if ("true".equals(fetchProp)) {
                    return true;
                }
                if ("false".equals(fetchProp)) {
                    return false;
                }
                throw new GradleException("tests.bwc.git_fetch_latest must be [true] or [false] but was [" + fetchProp + "]");
            });
            fetchLatest.onlyIf(t -> !project.getGradle().getStartParameter().isOffline() && gitFetchLatest.get() != null);
            fetchLatest.dependsOn(new Object[]{addRemoteTaskProvider});
            fetchLatest.setWorkingDir((File)this.gitExtension.getCheckoutDir().get());
            fetchLatest.setCommandLine(Arrays.asList("git", "fetch", "--all"));
        });
        tasks.register("checkoutBwcBranch", checkoutBwcBranch -> {
            checkoutBwcBranch.dependsOn(new Object[]{fetchLatestTaskProvider});
            checkoutBwcBranch.doLast(t -> {
                Logger logger = project.getLogger();
                String bwcBranch = (String)this.gitExtension.getBwcBranch().get();
                String refspec = (String)this.providerFactory.systemProperty("bwc.refspec." + bwcBranch).orElse(this.providerFactory.systemProperty("tests.bwc.refspec." + bwcBranch)).getOrElse((Object)((String)remote.get() + "/" + bwcBranch));
                String effectiveRefSpec = this.maybeAlignedRefSpec(logger, refspec);
                logger.lifecycle("Performing checkout of {}...", new Object[]{refspec});
                LoggedExec.exec(project, (Action<ExecSpec>)((Action)spec -> {
                    spec.workingDir(this.gitExtension.getCheckoutDir());
                    spec.commandLine(new Object[]{"git", "checkout", effectiveRefSpec});
                }));
                String checkoutHash = GlobalBuildInfoPlugin.gitInfo((File)this.gitExtension.getCheckoutDir().get()).getRevision();
                logger.lifecycle("Checkout hash for {} is {}", new Object[]{project.getPath(), checkoutHash});
                this.writeFile(new File(project.getBuildDir(), "refspec"), checkoutHash);
            });
        });
    }

    public BwcGitExtension getGitExtension() {
        return this.gitExtension;
    }

    private String maybeAlignedRefSpec(Logger logger, String defaultRefSpec) {
        if (!this.providerFactory.systemProperty("bwc.checkout.align").isPresent()) {
            return defaultRefSpec;
        }
        String timeOfCurrent = this.execInCheckoutDir((Action<ExecSpec>)((Action)execSpec -> {
            execSpec.commandLine(Arrays.asList("git", "show", "--no-patch", "--no-notes", "--pretty='%cD'"));
            execSpec.workingDir((Object)this.project.getRootDir());
        }));
        logger.lifecycle("Commit date of current: {}", new Object[]{timeOfCurrent});
        String mergeCommits = this.execInCheckoutDir((Action<ExecSpec>)((Action)spec -> spec.commandLine(Arrays.asList("git", "rev-list", defaultRefSpec, "--after", timeOfCurrent, "--merges"))));
        if (!mergeCommits.isEmpty()) {
            throw new IllegalStateException("Found the following merge commits which prevent determining bwc commits: " + mergeCommits);
        }
        return this.execInCheckoutDir((Action<ExecSpec>)((Action)spec -> spec.commandLine(Arrays.asList("git", "rev-list", defaultRefSpec, "-n", "1", "--before", timeOfCurrent, "--date-order"))));
    }

    private void writeFile(File file, String content) {
        try {
            FileUtils.writeStringToFile((File)file, (String)content);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String execInCheckoutDir(Action<ExecSpec> execSpecConfig) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ExecResult exec = this.execOperations.exec(execSpec -> {
            execSpec.setStandardOutput((OutputStream)os);
            execSpec.workingDir(this.gitExtension.getCheckoutDir().get());
            execSpecConfig.execute(execSpec);
        });
        exec.assertNormalExitValue();
        return os.toString().trim();
    }

    private static boolean isRemoteAvailable(Provider<String> remote, ByteArrayOutputStream output) {
        return new String(output.toByteArray()).contains((String)remote.get() + "\t");
    }
}

