/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.BwcVersions;
import org.opensearch.gradle.LoggedExec;
import org.opensearch.gradle.util.JavaUtil;

public class BwcSetupExtension {
    private final Project project;
    private final Provider<BwcVersions.UnreleasedVersionInfo> unreleasedVersionInfo;
    private Provider<File> checkoutDir;

    public BwcSetupExtension(Project project, Provider<BwcVersions.UnreleasedVersionInfo> unreleasedVersionInfo, Provider<File> checkoutDir) {
        this.project = project;
        this.unreleasedVersionInfo = unreleasedVersionInfo;
        this.checkoutDir = checkoutDir;
    }

    TaskProvider<LoggedExec> bwcTask(String name, Action<LoggedExec> configuration) {
        return this.createRunBwcGradleTask(this.project, name, configuration);
    }

    private TaskProvider<LoggedExec> createRunBwcGradleTask(final Project project, String name, final Action<LoggedExec> configAction) {
        return project.getTasks().register(name, LoggedExec.class, (Action)new Action<LoggedExec>(){
            final /* synthetic */ BwcSetupExtension this$0;
            {
                this.this$0 = this$0;
            }

            public void execute(final LoggedExec loggedExec) {
                String buildCacheUrl;
                loggedExec.dependsOn(new Object[]{"checkoutBwcBranch"});
                loggedExec.setSpoolOutput(true);
                loggedExec.setWorkingDir((File)this.this$0.checkoutDir.get());
                loggedExec.doFirst((Action)new Action<Task>(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void execute(Task t) {
                        String javaVersionsString = BwcSetupExtension.readFromFile(new File((File)this.this$1.this$0.checkoutDir.get(), ".ci/java-versions.properties"));
                        loggedExec.environment("JAVA_HOME", JavaUtil.getJavaHome(Integer.parseInt(Arrays.asList(javaVersionsString.split("\n")).stream().filter(l -> l.trim().startsWith("OPENSEARCH_BUILD_JAVA=")).map(l -> l.replace("OPENSEARCH_BUILD_JAVA=java", "").trim()).map(l -> l.replace("OPENSEARCH_BUILD_JAVA=openjdk", "").trim()).collect(Collectors.joining("!!")))));
                        loggedExec.environment("RUNTIME_JAVA_HOME", JavaUtil.getJavaHome(Integer.parseInt(Arrays.asList(javaVersionsString.split("\n")).stream().filter(l -> l.trim().startsWith("OPENSEARCH_RUNTIME_JAVA=")).map(l -> l.replace("OPENSEARCH_RUNTIME_JAVA=java", "").trim()).map(l -> l.replace("OPENSEARCH_RUNTIME_JAVA=openjdk", "").trim()).collect(Collectors.joining("!!")))));
                    }
                });
                if (Os.isFamily((String)"windows")) {
                    loggedExec.executable("cmd");
                    loggedExec.args(new Object[]{"/C", "call", new File((File)this.this$0.checkoutDir.get(), "gradlew").toString()});
                } else {
                    loggedExec.executable(new File((File)this.this$0.checkoutDir.get(), "gradlew").toString());
                }
                if (project.getGradle().getStartParameter().isOffline()) {
                    loggedExec.args(new Object[]{"--offline"});
                }
                if ((buildCacheUrl = System.getProperty("org.opensearch.build.cache.url")) != null) {
                    loggedExec.args(new Object[]{"-Dorg.opensearch.build.cache.url=" + buildCacheUrl});
                }
                loggedExec.args(new Object[]{"-Dbuild.snapshot=true"});
                loggedExec.args(new Object[]{"-Dscan.tag.NESTED"});
                LogLevel logLevel = project.getGradle().getStartParameter().getLogLevel();
                List<LogLevel> nonDefaultLogLevels = Arrays.asList(LogLevel.QUIET, LogLevel.WARN, LogLevel.INFO, LogLevel.DEBUG);
                if (nonDefaultLogLevels.contains(logLevel)) {
                    loggedExec.args(new Object[]{"--" + logLevel.name().toLowerCase(Locale.ENGLISH)});
                }
                String showStacktraceName = project.getGradle().getStartParameter().getShowStacktrace().name();
                assert (Arrays.asList("INTERNAL_EXCEPTIONS", "ALWAYS", "ALWAYS_FULL").contains(showStacktraceName));
                if (showStacktraceName.equals("ALWAYS")) {
                    loggedExec.args(new Object[]{"--stacktrace"});
                } else if (showStacktraceName.equals("ALWAYS_FULL")) {
                    loggedExec.args(new Object[]{"--full-stacktrace"});
                }
                if (project.getGradle().getStartParameter().isParallelProjectExecutionEnabled()) {
                    loggedExec.args(new Object[]{"--parallel"});
                }
                loggedExec.setStandardOutput(new IndentingOutputStream(System.out, ((BwcVersions.UnreleasedVersionInfo)this.this$0.unreleasedVersionInfo.get()).version));
                loggedExec.setErrorOutput(new IndentingOutputStream(System.err, ((BwcVersions.UnreleasedVersionInfo)this.this$0.unreleasedVersionInfo.get()).version));
                configAction.execute((Object)loggedExec);
            }
        });
    }

    private static String readFromFile(File file) {
        try {
            return FileUtils.readFileToString((File)file).trim();
        }
        catch (IOException ioException) {
            throw new GradleException("Cannot read java properties file.", (Throwable)ioException);
        }
    }

    private static class IndentingOutputStream
    extends OutputStream {
        public final byte[] indent;
        private final OutputStream delegate;

        IndentingOutputStream(OutputStream delegate, Object version) {
            this.delegate = delegate;
            this.indent = (" [" + String.valueOf(version) + "] ").getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public void write(int b) throws IOException {
            int[] arr = new int[]{b};
            this.write(arr, 0, 1);
        }

        public void write(int[] bytes, int offset, int length) throws IOException {
            for (int i = 0; i < bytes.length; ++i) {
                this.delegate.write(bytes[i]);
                if (bytes[i] != 10) continue;
                this.delegate.write(this.indent);
            }
        }
    }
}

