/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.info;

import java.io.File;
import java.lang.reflect.Modifier;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.gradle.api.JavaVersion;
import org.opensearch.gradle.BwcVersions;
import org.opensearch.gradle.info.JavaHome;

public class BuildParams {
    private static File runtimeJavaHome;
    private static Boolean isRuntimeJavaHomeSet;
    private static List<JavaHome> javaVersions;
    private static JavaVersion minimumCompilerVersion;
    private static JavaVersion minimumRuntimeVersion;
    private static JavaVersion gradleJavaVersion;
    private static JavaVersion runtimeJavaVersion;
    private static String runtimeJavaDetails;
    private static Boolean inFipsJvm;
    private static String gitRevision;
    private static String gitOrigin;
    private static ZonedDateTime buildDate;
    private static String testSeed;
    private static Boolean isCi;
    private static Boolean isInternal;
    private static Integer defaultParallel;
    private static Boolean isSnapshotBuild;
    private static BwcVersions bwcVersions;

    public static void init(Consumer<MutableBuildParams> initializer) {
        initializer.accept(MutableBuildParams.INSTANCE);
    }

    public static File getRuntimeJavaHome() {
        return BuildParams.value(runtimeJavaHome);
    }

    public static Boolean getIsRuntimeJavaHomeSet() {
        return BuildParams.value(isRuntimeJavaHomeSet);
    }

    public static List<JavaHome> getJavaVersions() {
        return BuildParams.value(javaVersions);
    }

    public static JavaVersion getMinimumCompilerVersion() {
        return BuildParams.value(minimumCompilerVersion);
    }

    public static JavaVersion getMinimumRuntimeVersion() {
        return BuildParams.value(minimumRuntimeVersion);
    }

    public static JavaVersion getGradleJavaVersion() {
        return BuildParams.value(gradleJavaVersion);
    }

    public static JavaVersion getRuntimeJavaVersion() {
        return BuildParams.value(runtimeJavaVersion);
    }

    public static String getRuntimeJavaDetails() {
        return BuildParams.value(runtimeJavaDetails);
    }

    public static Boolean isInFipsJvm() {
        return BuildParams.value(inFipsJvm);
    }

    public static String getGitRevision() {
        return BuildParams.value(gitRevision);
    }

    public static String getGitOrigin() {
        return BuildParams.value(gitOrigin);
    }

    public static ZonedDateTime getBuildDate() {
        return BuildParams.value(buildDate);
    }

    public static BwcVersions getBwcVersions() {
        return BuildParams.value(bwcVersions);
    }

    public static String getTestSeed() {
        return BuildParams.value(testSeed);
    }

    public static Boolean isCi() {
        return BuildParams.value(isCi);
    }

    public static Boolean isInternal() {
        return BuildParams.value(isInternal);
    }

    public static Integer getDefaultParallel() {
        return BuildParams.value(defaultParallel);
    }

    public static boolean isSnapshotBuild() {
        return BuildParams.value(isSnapshotBuild);
    }

    private static <T> T value(T object) {
        if (object == null) {
            String callingMethod = Thread.currentThread().getStackTrace()[2].getMethodName();
            throw new IllegalStateException("Build parameter '" + BuildParams.propertyName(callingMethod) + "' has not been initialized.\nPerhaps the plugin responsible for initializing this property has not been applied.");
        }
        return object;
    }

    private static String propertyName(String methodName) {
        String propertyName = methodName.startsWith("is") ? methodName.substring("is".length()) : methodName.substring("get".length());
        return propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
    }

    public static class MutableBuildParams {
        private static MutableBuildParams INSTANCE = new MutableBuildParams();

        private MutableBuildParams() {
        }

        public void reset() {
            Arrays.stream(BuildParams.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).forEach(f -> {
                try {
                    f.setAccessible(true);
                    f.set(null, null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        public void setRuntimeJavaHome(File runtimeJavaHome) {
            BuildParams.runtimeJavaHome = Objects.requireNonNull(runtimeJavaHome);
        }

        public void setIsRuntimeJavaHomeSet(boolean isRuntimeJavaHomeSet) {
            BuildParams.isRuntimeJavaHomeSet = isRuntimeJavaHomeSet;
        }

        public void setJavaVersions(List<JavaHome> javaVersions) {
            BuildParams.javaVersions = Objects.requireNonNull(javaVersions);
        }

        public void setMinimumCompilerVersion(JavaVersion minimumCompilerVersion) {
            BuildParams.minimumCompilerVersion = Objects.requireNonNull(minimumCompilerVersion);
        }

        public void setMinimumRuntimeVersion(JavaVersion minimumRuntimeVersion) {
            BuildParams.minimumRuntimeVersion = Objects.requireNonNull(minimumRuntimeVersion);
        }

        public void setGradleJavaVersion(JavaVersion gradleJavaVersion) {
            BuildParams.gradleJavaVersion = Objects.requireNonNull(gradleJavaVersion);
        }

        public void setRuntimeJavaVersion(JavaVersion runtimeJavaVersion) {
            BuildParams.runtimeJavaVersion = Objects.requireNonNull(runtimeJavaVersion);
        }

        public void setRuntimeJavaDetails(String runtimeJavaDetails) {
            BuildParams.runtimeJavaDetails = runtimeJavaDetails;
        }

        public void setInFipsJvm(boolean inFipsJvm) {
            BuildParams.inFipsJvm = inFipsJvm;
        }

        public void setGitRevision(String gitRevision) {
            BuildParams.gitRevision = Objects.requireNonNull(gitRevision);
        }

        public void setGitOrigin(String gitOrigin) {
            BuildParams.gitOrigin = Objects.requireNonNull(gitOrigin);
        }

        public void setBuildDate(ZonedDateTime buildDate) {
            BuildParams.buildDate = Objects.requireNonNull(buildDate);
        }

        public void setTestSeed(String testSeed) {
            BuildParams.testSeed = Objects.requireNonNull(testSeed);
        }

        public void setIsCi(boolean isCi) {
            BuildParams.isCi = isCi;
        }

        public void setIsInternal(Boolean isInternal) {
            BuildParams.isInternal = Objects.requireNonNull(isInternal);
        }

        public void setDefaultParallel(int defaultParallel) {
            BuildParams.defaultParallel = defaultParallel;
        }

        public void setIsSnapshotBuild(boolean isSnapshotBuild) {
            BuildParams.isSnapshotBuild = isSnapshotBuild;
        }

        public void setBwcVersions(BwcVersions bwcVersions) {
            BuildParams.bwcVersions = Objects.requireNonNull(bwcVersions);
        }
    }
}

