/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.docker;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.opensearch.gradle.LoggedExec;

public class DockerBuildTask
extends DefaultTask {
    private static final Logger LOGGER = Logging.getLogger(DockerBuildTask.class);
    private final WorkerExecutor workerExecutor;
    private final RegularFileProperty markerFile;
    private final DirectoryProperty dockerContext;
    private String[] tags;
    private boolean pull = true;
    private boolean noCache = true;
    private String[] baseImages;
    private final Project project;

    @Inject
    public DockerBuildTask(WorkerExecutor workerExecutor, Project project) {
        this.workerExecutor = workerExecutor;
        this.project = project;
        this.markerFile = project.getObjects().fileProperty();
        this.dockerContext = project.getObjects().directoryProperty();
        this.markerFile.set(project.getLayout().getBuildDirectory().file("markers/" + this.getName() + ".marker"));
    }

    @TaskAction
    public void build() {
        this.workerExecutor.noIsolation().submit(DockerBuildAction.class, params -> {
            params.getDockerContext().set((Provider)this.dockerContext);
            params.getMarkerFile().set((Provider)this.markerFile);
            params.getTags().set(Arrays.asList(this.tags));
            params.getPull().set((Object)this.pull);
            params.getNoCache().set((Object)this.noCache);
            params.getBaseImages().set((Object)this.baseImages);
        });
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public DirectoryProperty getDockerContext() {
        return this.dockerContext;
    }

    @Input
    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    @Input
    public boolean isPull() {
        return this.pull;
    }

    public void setPull(boolean pull) {
        this.pull = pull;
    }

    @Input
    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    @Input
    public String[] getBaseImages() {
        return this.baseImages;
    }

    public void setBaseImages(String[] baseImages) {
        this.baseImages = baseImages;
    }

    @OutputFile
    public RegularFileProperty getMarkerFile() {
        return this.markerFile;
    }

    public static abstract class DockerBuildAction
    implements WorkAction<Parameters> {
        private final ExecOperations execOperations;

        @Inject
        public DockerBuildAction(ExecOperations execOperations) {
            this.execOperations = execOperations;
        }

        private void pullBaseImage(String baseImage) {
            int maxAttempts = 10;
            for (int attempt = 1; attempt <= 10; ++attempt) {
                try {
                    LoggedExec.exec(this.execOperations, (Action<ExecSpec>)((Action)spec -> {
                        spec.executable((Object)"docker");
                        spec.args(new Object[]{"pull"});
                        spec.args(new Object[]{baseImage});
                    }));
                    return;
                }
                catch (Exception e) {
                    LOGGER.warn("Attempt {}/{} to pull Docker base image {} failed", new Object[]{attempt, 10, baseImage});
                    continue;
                }
            }
            throw new GradleException("Failed to pull Docker base image [" + baseImage + "], all attempts failed");
        }

        public void execute() {
            Parameters parameters = (Parameters)this.getParameters();
            if (((Boolean)parameters.getPull().get()).booleanValue()) {
                for (String baseImage : (String[])parameters.getBaseImages().get()) {
                    this.pullBaseImage(baseImage);
                }
            }
            LoggedExec.exec(this.execOperations, (Action<ExecSpec>)((Action)spec -> {
                spec.executable((Object)"docker");
                spec.args(new Object[]{"build", ((Directory)parameters.getDockerContext().get()).getAsFile().getAbsolutePath()});
                if (((Boolean)parameters.getNoCache().get()).booleanValue()) {
                    spec.args(new Object[]{"--no-cache"});
                }
                ((List)parameters.getTags().get()).forEach(tag -> spec.args(new Object[]{"--tag", tag}));
            }));
            try {
                ((File)parameters.getMarkerFile().getAsFile().get()).createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create marker file", e);
            }
        }
    }

    static interface Parameters
    extends WorkParameters {
        public DirectoryProperty getDockerContext();

        public RegularFileProperty getMarkerFile();

        public ListProperty<String> getTags();

        public Property<Boolean> getPull();

        public Property<Boolean> getNoCache();

        public Property<String[]> getBaseImages();
    }
}

