/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.agent;

import java.io.File;
import java.util.Objects;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;

public class JavaAgent
implements Plugin<Project> {
    public void apply(Project project) {
        Configuration agentConfiguration = (Configuration)project.getConfigurations().findByName("agent");
        if (agentConfiguration == null) {
            agentConfiguration = (Configuration)project.getConfigurations().create("agent");
        }
        project.afterEvaluate(p -> {
            String opensearchVersion = this.getOpensearchVersion((Project)p);
            p.getDependencies().add("agent", (Object)("org.opensearch:opensearch-agent-bootstrap:" + opensearchVersion));
            p.getDependencies().add("agent", (Object)("org.opensearch:opensearch-agent:" + opensearchVersion));
        });
        Configuration finalAgentConfiguration = agentConfiguration;
        TaskProvider prepareJavaAgent = project.getTasks().register("prepareJavaAgent", Copy.class, task -> {
            task.from(new Object[]{finalAgentConfiguration});
            task.into((Object)new File(project.getBuildDir(), "agent"));
        });
        project.getTasks().withType(Test.class).configureEach(testTask -> {
            testTask.dependsOn(new Object[]{prepareJavaAgent});
            String opensearchVersion = this.getOpensearchVersion(project);
            testTask.doFirst(task -> {
                File agentJar = new File(project.getBuildDir(), "agent/opensearch-agent-" + opensearchVersion + ".jar");
                testTask.jvmArgs(new Object[]{"-javaagent:" + agentJar.getAbsolutePath()});
            });
        });
    }

    private String getOpensearchVersion(Project project) {
        return Objects.requireNonNull(project.property("opensearch_version")).toString();
    }
}

