/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.util.Collection;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.deprecation.DeprecatableConfiguration;

public class ResolveAllDependencies
extends DefaultTask {
    Collection<Configuration> configs;

    @TaskAction
    void resolveAll() {
        this.configs.stream().filter(it -> ResolveAllDependencies.canBeResolved(it)).forEach(it -> it.resolve());
    }

    static boolean canBeResolved(Configuration configuration) {
        DeprecatableConfiguration deprecatableConfiguration;
        if (!configuration.isCanBeResolved()) {
            return false;
        }
        if (configuration instanceof DeprecatableConfiguration && !(deprecatableConfiguration = (DeprecatableConfiguration)configuration).canSafelyBeResolved()) {
            return false;
        }
        return !configuration.getName().startsWith("opensearch_distro_extracted_");
    }
}

