/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.internal.jvm.Jvm;
import org.opensearch.gradle.OS;
import org.opensearch.gradle.info.BuildParams;

public class ReaperService {
    private static final String REAPER_CLASS = "org/opensearch/gradle/reaper/Reaper.class";
    private static final Pattern REAPER_JAR_PATH_PATTERN = Pattern.compile("file:(.*)!/org/opensearch/gradle/reaper/Reaper.class");
    private final Logger logger;
    private final boolean isInternal;
    private final Path buildDir;
    private final Path inputDir;
    private final Path logFile;
    private volatile Process reaperProcess;

    public ReaperService(Project project, Path buildDir, Path inputDir) {
        this.logger = project.getLogger();
        this.isInternal = BuildParams.isInternal();
        this.buildDir = buildDir;
        this.inputDir = inputDir;
        this.logFile = inputDir.resolve("reaper.log");
    }

    public void registerPid(String serviceId, long pid) {
        String[] killPidCommand = OS.conditional().onWindows(() -> new String[]{"Taskkill", "/F", "/PID", String.valueOf(pid)}).onUnix(() -> new String[]{"kill", "-9", String.valueOf(pid)}).supply();
        this.registerCommand(serviceId, killPidCommand);
    }

    public void registerCommand(String serviceId, String ... command) {
        this.ensureReaperStarted();
        try (FileWriter writer = new FileWriter(this.getCmdFile(serviceId).toFile());){
            writer.write(String.join((CharSequence)" ", command));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path getCmdFile(String serviceId) {
        return this.inputDir.resolve(serviceId.replaceAll("[^a-zA-Z0-9]", "-") + ".cmd");
    }

    public void unregister(String serviceId) {
        try {
            Files.deleteIfExists(this.getCmdFile(serviceId));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void shutdown() {
        if (this.reaperProcess != null) {
            this.ensureReaperAlive();
            try {
                this.reaperProcess.getOutputStream().close();
                this.logger.info("Waiting for reaper to exit normally");
                if (this.reaperProcess.waitFor() != 0) {
                    throw new GradleException("Reaper process failed. Check log at " + String.valueOf(this.inputDir.resolve("error.log")) + " for details");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private synchronized void ensureReaperStarted() {
        if (this.reaperProcess == null) {
            try {
                Path jarPath = this.locateReaperJar();
                Files.createDirectories(this.inputDir, new FileAttribute[0]);
                ProcessBuilder builder = new ProcessBuilder(Jvm.current().getJavaExecutable().toString(), "-Xms4m", "-Xmx16m", "-jar", jarPath.toString(), this.inputDir.toString());
                this.logger.info("Launching reaper: " + String.join((CharSequence)" ", builder.command()));
                builder.redirectInput(ProcessBuilder.Redirect.PIPE);
                builder.redirectOutput(this.logFile.toFile());
                builder.redirectError(this.logFile.toFile());
                this.reaperProcess = builder.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.ensureReaperAlive();
        }
    }

    private Path locateReaperJar() {
        if (this.isInternal) {
            URL main = this.getClass().getClassLoader().getResource(REAPER_CLASS);
            String mainPath = main.getFile();
            Matcher matcher = REAPER_JAR_PATH_PATTERN.matcher(mainPath);
            if (matcher.matches()) {
                String path = matcher.group(1);
                return Paths.get(OS.conditional().onWindows(() -> path.substring(1)).onUnix(() -> path).supply(), new String[0]);
            }
            throw new RuntimeException("Unable to locate org/opensearch/gradle/reaper/Reaper.class on build classpath.");
        }
        Path jarPath = this.buildDir.resolve("reaper").resolve("reaper.jar");
        try {
            Files.createDirectories(jarPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create reaper JAR output directory " + String.valueOf(jarPath.getParent()), e);
        }
        try (OutputStream out = Files.newOutputStream(jarPath, new OpenOption[0]);
             InputStream jarInput = this.getClass().getResourceAsStream("/META-INF/reaper.jar");){
            this.logger.info("Copying reaper.jar...");
            jarInput.transferTo(out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return jarPath;
    }

    private void ensureReaperAlive() {
        if (!this.reaperProcess.isAlive()) {
            throw new IllegalStateException("Reaper process died unexpectedly! Check the log at " + this.logFile.toString());
        }
    }
}

