/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.nio.file.Path;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.opensearch.gradle.ReaperService;
import org.opensearch.gradle.info.GlobalBuildInfoPlugin;

public class ReaperPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (project != project.getRootProject()) {
            throw new IllegalArgumentException("ReaperPlugin can only be applied to the root project of a build");
        }
        project.getPlugins().apply(GlobalBuildInfoPlugin.class);
        Path inputDir = project.getRootDir().toPath().resolve(".gradle").resolve("reaper").resolve("build-" + ProcessHandle.current().pid());
        ReaperService service = (ReaperService)project.getExtensions().create("reaper", ReaperService.class, new Object[]{project, project.getBuildDir().toPath(), inputDir});
        project.getGradle().buildFinished(result -> service.shutdown());
    }
}

