/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.opensearch.gradle.Architecture;
import org.opensearch.gradle.JavaPackageType;
import org.opensearch.gradle.OS;
import org.opensearch.gradle.Version;
import org.opensearch.gradle.VersionProperties;
import org.opensearch.gradle.docker.DockerSupportService;

public class OpenSearchDistribution
implements Buildable,
Iterable<File> {
    public static final Platform CURRENT_PLATFORM = OS.conditional().onFreeBSD(() -> Platform.FREEBSD).onLinux(() -> Platform.LINUX).onMac(() -> Platform.DARWIN).onWindows(() -> Platform.WINDOWS).supply();
    private final String name;
    private final Provider<DockerSupportService> dockerSupport;
    final Configuration configuration;
    private final Property<Architecture> architecture;
    private final Property<String> version;
    private final Property<Type> type;
    private final Property<Platform> platform;
    private final Property<JavaPackageType> bundledJdk;
    private final Property<Boolean> failIfUnavailable;
    private final Configuration extracted;

    OpenSearchDistribution(String name, ObjectFactory objectFactory, Provider<DockerSupportService> dockerSupport, Configuration fileConfiguration, Configuration extractedConfiguration) {
        this.name = name;
        this.dockerSupport = dockerSupport;
        this.configuration = fileConfiguration;
        this.architecture = objectFactory.property(Architecture.class);
        this.version = objectFactory.property(String.class).convention((Object)VersionProperties.getOpenSearch());
        this.type = objectFactory.property(Type.class);
        this.type.convention((Object)Type.ARCHIVE);
        this.platform = objectFactory.property(Platform.class);
        this.bundledJdk = objectFactory.property(JavaPackageType.class);
        this.failIfUnavailable = objectFactory.property(Boolean.class).convention((Object)true);
        this.extracted = extractedConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return (String)this.version.get();
    }

    public void setVersion(String version) {
        Version.fromString(version);
        this.version.set((Object)version);
    }

    public Platform getPlatform() {
        return (Platform)((Object)this.platform.getOrNull());
    }

    public void setPlatform(Platform platform) {
        this.platform.set((Object)platform);
    }

    public Type getType() {
        return (Type)((Object)this.type.get());
    }

    public void setType(Type type) {
        this.type.set((Object)type);
    }

    public JavaPackageType getBundledJdk() {
        return (JavaPackageType)((Object)this.bundledJdk.getOrElse((Object)JavaPackageType.JDK));
    }

    public boolean isDocker() {
        Type type = (Type)((Object)this.type.get());
        return type == Type.DOCKER;
    }

    public void setBundledJdk(JavaPackageType bundledJdk) {
        this.bundledJdk.set((Object)bundledJdk);
    }

    public boolean getFailIfUnavailable() {
        return (Boolean)this.failIfUnavailable.get();
    }

    public void setFailIfUnavailable(boolean failIfUnavailable) {
        this.failIfUnavailable.set((Object)failIfUnavailable);
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture.set((Object)architecture);
    }

    public Architecture getArchitecture() {
        return (Architecture)((Object)this.architecture.get());
    }

    public String toString() {
        return this.getName() + "_" + String.valueOf((Object)this.getType()) + "_" + this.getVersion();
    }

    public String getFilepath() {
        return this.configuration.getSingleFile().toString();
    }

    public Configuration getExtracted() {
        switch (this.getType().ordinal()) {
            case 2: 
            case 3: 
            case 4: {
                throw new UnsupportedOperationException("distribution type [" + String.valueOf((Object)this.getType()) + "] for opensearch distribution [" + this.name + "] cannot be extracted");
            }
        }
        return this.extracted;
    }

    public TaskDependency getBuildDependencies() {
        if (this.isDocker() && !this.getFailIfUnavailable() && !((DockerSupportService)this.dockerSupport.get()).getDockerAvailability().isAvailable) {
            return task -> Collections.emptySet();
        }
        return this.configuration.getBuildDependencies();
    }

    @Override
    public Iterator<File> iterator() {
        return this.configuration.iterator();
    }

    void finalizeValues() {
        if (this.getType() == Type.INTEG_TEST_ZIP) {
            if (this.platform.getOrNull() != null) {
                throw new IllegalArgumentException("platform cannot be set on opensearch distribution [" + this.name + "] of type [integ_test_zip]");
            }
            if (this.bundledJdk.getOrNull() != null) {
                throw new IllegalArgumentException("bundledJdk cannot be set on opensearch distribution [" + this.name + "] of type [integ_test_zip]");
            }
            return;
        }
        if (!this.isDocker() && !((Boolean)this.failIfUnavailable.get()).booleanValue()) {
            throw new IllegalArgumentException("failIfUnavailable cannot be 'false' on opensearch distribution [" + this.name + "] of type [" + String.valueOf((Object)this.getType()) + "]");
        }
        if (this.getType() == Type.ARCHIVE) {
            if (!this.platform.isPresent()) {
                this.platform.set((Object)CURRENT_PLATFORM);
            }
        } else {
            if (this.platform.isPresent()) {
                throw new IllegalArgumentException("platform cannot be set on opensearch distribution [" + this.name + "] of type [" + String.valueOf((Object)this.getType()) + "]");
            }
            if (this.isDocker() && this.bundledJdk.isPresent()) {
                throw new IllegalArgumentException("bundledJdk cannot be set on opensearch distribution [" + this.name + "] of type [docker]");
            }
        }
        if (!this.bundledJdk.isPresent()) {
            this.bundledJdk.set((Object)JavaPackageType.JDK);
        }
        this.version.finalizeValue();
        this.platform.finalizeValue();
        this.type.finalizeValue();
        this.bundledJdk.finalizeValue();
    }

    public static enum Type {
        INTEG_TEST_ZIP,
        ARCHIVE,
        RPM,
        DEB,
        DOCKER;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public boolean shouldExtract() {
            switch (this.ordinal()) {
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
            }
            return true;
        }
    }

    public static enum Platform {
        DARWIN,
        FREEBSD,
        LINUX,
        WINDOWS;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

