/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class LoggingOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_LENGTH = 4096;
    private byte[] buffer = new byte[4096];
    private int start = 0;
    private int end = 0;

    @Override
    public void write(int b) throws IOException {
        if (b == 0) {
            return;
        }
        if (b == 10) {
            this.flush();
            return;
        }
        if (this.end == this.buffer.length) {
            if (this.start != 0) {
                int len = this.end - this.start;
                System.arraycopy(this.buffer, this.start, this.buffer, 0, len);
                this.start = 0;
                this.end = len;
            } else {
                this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + 4096);
            }
        }
        this.buffer[this.end++] = (byte)b;
    }

    @Override
    public void flush() {
        if (this.end == this.start) {
            return;
        }
        this.logLine(new String(this.buffer, this.start, this.end - this.start));
        this.start = this.end;
    }

    protected abstract void logLine(String var1);
}

