/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.testclusters;

import java.util.Collection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.Nested;
import org.opensearch.gradle.testclusters.OpenSearchCluster;
import org.opensearch.gradle.testclusters.TestClustersException;

public interface TestClustersAware
extends Task {
    @Nested
    public Collection<OpenSearchCluster> getClusters();

    @Deprecated(forRemoval=true)
    default public void useCluster(OpenSearchCluster cluster) {
        this.useCluster(this.getProject(), cluster);
    }

    default public void useCluster(Project project, OpenSearchCluster cluster) {
        if (!cluster.getPath().equals(project.getPath())) {
            throw new TestClustersException("Task " + this.getPath() + " can't use test cluster from another project " + String.valueOf(cluster));
        }
        cluster.getNodes().stream().flatMap(node -> node.getDistributions().stream()).forEach(distro -> this.dependsOn(new Object[]{distro.getExtracted()}));
        cluster.getNodes().forEach(node -> {
            Object[] objectArray = new Object[1];
            objectArray[0] = node::getPluginAndModuleConfigurations;
            this.dependsOn(objectArray);
        });
        this.getClusters().add(cluster);
    }

    default public void beforeStart() {
    }
}

