/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.testclusters;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.opensearch.gradle.FileSupplier;
import org.opensearch.gradle.PropertyNormalization;
import org.opensearch.gradle.ReaperService;
import org.opensearch.gradle.http.WaitForHttpResource;
import org.opensearch.gradle.testclusters.OpenSearchNode;
import org.opensearch.gradle.testclusters.TestClusterConfiguration;
import org.opensearch.gradle.testclusters.TestClustersException;
import org.opensearch.gradle.testclusters.TestDistribution;

public class OpenSearchCluster
implements TestClusterConfiguration,
Named {
    private static final Logger LOGGER = Logging.getLogger(OpenSearchNode.class);
    private static final int CLUSTER_UP_TIMEOUT = 40;
    private static final TimeUnit CLUSTER_UP_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final AtomicBoolean configurationFrozen = new AtomicBoolean(false);
    private final String path;
    private final String clusterName;
    private final NamedDomainObjectContainer<OpenSearchNode> nodes;
    private final File workingDirBase;
    private final LinkedHashMap<String, Predicate<TestClusterConfiguration>> waitConditions = new LinkedHashMap();
    private final Project project;
    private final ReaperService reaper;
    private final FileSystemOperations fileSystemOperations;
    private final ArchiveOperations archiveOperations;
    private int nodeIndex = 0;
    private int zoneCount = 1;

    public OpenSearchCluster(String clusterName, Project project, ReaperService reaper, File workingDirBase, FileSystemOperations fileSystemOperations, ArchiveOperations archiveOperations) {
        this.path = project.getPath();
        this.clusterName = clusterName;
        this.project = project;
        this.reaper = reaper;
        this.fileSystemOperations = fileSystemOperations;
        this.archiveOperations = archiveOperations;
        this.workingDirBase = workingDirBase;
        this.nodes = project.container(OpenSearchNode.class);
        String zone = this.hasZoneProperty() ? "zone-1" : "";
        this.addNode(clusterName + "-0", zone);
        this.nodes.all(node -> node.defaultConfig.put("cluster.name", this.safeName(clusterName)));
        this.addWaitForClusterHealth();
    }

    public void setNumberOfZones(int zoneCount) {
        if (zoneCount < 1) {
            throw new IllegalArgumentException("Number of zones should be >= 1 but was " + zoneCount + " for " + String.valueOf(this));
        }
        this.zoneCount = zoneCount;
    }

    public void setNumberOfNodes(int numberOfNodes) {
        this.checkFrozen();
        if (numberOfNodes < 1) {
            throw new IllegalArgumentException("Number of nodes should be >= 1 but was " + numberOfNodes + " for " + String.valueOf(this));
        }
        if (numberOfNodes <= this.nodes.size()) {
            throw new IllegalArgumentException("Cannot shrink " + String.valueOf(this) + " to have " + numberOfNodes + " nodes as it already has " + this.getNumberOfNodes());
        }
        if (numberOfNodes < this.zoneCount) {
            throw new IllegalArgumentException("Number of nodes should be >= zoneCount but was " + numberOfNodes + " for " + this.zoneCount);
        }
        if (this.hasZoneProperty()) {
            for (int i = this.nodes.size(); i < numberOfNodes; ++i) {
                int currentZone = i % this.zoneCount + 1;
                String zoneName = "zone-" + currentZone;
                this.addNode(this.clusterName + "-" + i, zoneName);
            }
        } else {
            for (int i = this.nodes.size(); i < numberOfNodes; ++i) {
                this.addNode(this.clusterName + "-" + i, "");
            }
        }
    }

    private boolean hasZoneProperty() {
        return this.project.findProperty("numZones") != null;
    }

    private void addNode(String nodeName, String zoneName) {
        OpenSearchNode newNode = new OpenSearchNode(this.path, nodeName, this.project, this.reaper, this.fileSystemOperations, this.archiveOperations, this.workingDirBase, zoneName);
        newNode.defaultConfig.put("cluster.name", this.safeName(this.clusterName));
        this.nodes.add((Object)newNode);
    }

    @Internal
    OpenSearchNode getFirstNode() {
        return (OpenSearchNode)this.nodes.getAt(this.clusterName + "-0");
    }

    @Internal
    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    @Internal
    public String getName() {
        return this.clusterName;
    }

    @Internal
    public String getPath() {
        return this.path;
    }

    @Override
    public void setVersion(String version) {
        this.nodes.all(each -> each.setVersion(version));
    }

    @Override
    public void setVersions(List<String> version) {
        this.nodes.all(each -> each.setVersions(version));
    }

    @Override
    public void setTestDistribution(TestDistribution distribution) {
        this.nodes.all(each -> each.setTestDistribution(distribution));
    }

    @Override
    public void extension(boolean extensionsEnabled) {
        this.nodes.all(each -> each.extension(extensionsEnabled));
    }

    @Override
    public void plugin(Provider<RegularFile> plugin) {
        this.nodes.all(each -> each.plugin(plugin));
    }

    @Override
    public void plugin(String pluginProjectPath) {
        this.nodes.all(each -> each.plugin(pluginProjectPath));
    }

    @Override
    public void upgradePlugin(List<Provider<RegularFile>> plugins) {
        this.nodes.all(each -> each.upgradePlugin(plugins));
    }

    @Override
    public void module(Provider<RegularFile> module) {
        this.nodes.all(each -> each.module(module));
    }

    @Override
    public void module(String moduleProjectPath) {
        this.nodes.all(each -> each.module(moduleProjectPath));
    }

    @Override
    public void keystore(String key, String value) {
        this.nodes.all(each -> each.keystore(key, value));
    }

    @Override
    public void keystore(String key, Supplier<CharSequence> valueSupplier) {
        this.nodes.all(each -> each.keystore(key, valueSupplier));
    }

    @Override
    public void keystore(String key, File value) {
        this.nodes.all(each -> each.keystore(key, value));
    }

    @Override
    public void keystore(String key, File value, PropertyNormalization normalization) {
        this.nodes.all(each -> each.keystore(key, value, normalization));
    }

    @Override
    public void keystore(String key, FileSupplier valueSupplier) {
        this.nodes.all(each -> each.keystore(key, valueSupplier));
    }

    @Override
    public void keystorePassword(String password) {
        this.nodes.all(each -> each.keystorePassword(password));
    }

    @Override
    public void setSecure(boolean secure) {
        this.nodes.all(each -> each.setSecure(secure));
    }

    @Override
    public void cliSetup(String binTool, CharSequence ... args) {
        this.nodes.all(each -> each.cliSetup(binTool, args));
    }

    @Override
    public void setting(String key, String value) {
        this.nodes.all(each -> each.setting(key, value));
    }

    @Override
    public void setting(String key, String value, PropertyNormalization normalization) {
        this.nodes.all(each -> each.setting(key, value, normalization));
    }

    @Override
    public void setting(String key, Supplier<CharSequence> valueSupplier) {
        this.nodes.all(each -> each.setting(key, valueSupplier));
    }

    @Override
    public void setting(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.nodes.all(each -> each.setting(key, valueSupplier, normalization));
    }

    @Override
    public void systemProperty(String key, String value) {
        this.nodes.all(each -> each.systemProperty(key, value));
    }

    @Override
    public void systemProperty(String key, Supplier<CharSequence> valueSupplier) {
        this.nodes.all(each -> each.systemProperty(key, valueSupplier));
    }

    @Override
    public void systemProperty(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.nodes.all(each -> each.systemProperty(key, valueSupplier, normalization));
    }

    @Override
    public void environment(String key, String value) {
        this.nodes.all(each -> each.environment(key, value));
    }

    @Override
    public void environment(String key, Supplier<CharSequence> valueSupplier) {
        this.nodes.all(each -> each.environment(key, valueSupplier));
    }

    @Override
    public void environment(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.nodes.all(each -> each.environment(key, valueSupplier, normalization));
    }

    @Override
    public void jvmArgs(String ... values) {
        this.nodes.all(each -> each.jvmArgs(values));
    }

    @Override
    @Internal
    public boolean isPreserveDataDir() {
        return this.nodes.stream().anyMatch(node -> node.isPreserveDataDir());
    }

    @Override
    public void setPreserveDataDir(boolean preserveDataDir) {
        this.nodes.all(each -> each.setPreserveDataDir(preserveDataDir));
    }

    @Override
    public void freeze() {
        this.nodes.forEach(OpenSearchNode::freeze);
        this.configurationFrozen.set(true);
    }

    private void checkFrozen() {
        if (this.configurationFrozen.get()) {
            throw new IllegalStateException("Configuration for " + String.valueOf(this) + " can not be altered, already locked");
        }
    }

    @Override
    public void start() {
        this.commonNodeConfig();
        this.nodes.stream().filter(node -> {
            if (node.getVersion().onOrAfter("6.5.0")) {
                return true;
            }
            return !node.equals(this.nodes.iterator().next());
        }).forEach(OpenSearchNode::start);
    }

    private void commonNodeConfig() {
        String nodeNames = this.nodes.stream().map(OpenSearchNode::getName).anyMatch(name -> name == null) ? null : this.nodes.stream().map(OpenSearchNode::getName).map(this::safeName).collect(Collectors.joining(","));
        OpenSearchNode firstNode = null;
        for (OpenSearchNode node : this.nodes) {
            if (nodeNames != null) {
                this.commonNodeConfig(node, nodeNames, firstNode);
            }
            if (firstNode != null) continue;
            firstNode = node;
            if (!node.getVersion().before("6.5.0")) continue;
            firstNode.start();
        }
    }

    private void commonNodeConfig(OpenSearchNode node, String nodeNames, OpenSearchNode firstNode) {
        if (node.getVersion().onOrAfter("7.0.0")) {
            node.defaultConfig.keySet().stream().filter(name -> name.startsWith("discovery.zen.")).collect(Collectors.toList()).forEach(node.defaultConfig::remove);
            if (nodeNames != null && !node.settings.getOrDefault("discovery.type", "anything").equals("single-node")) {
                if (node.getVersion().onOrAfter("2.0.0")) {
                    node.defaultConfig.put("cluster.initial_cluster_manager_nodes", "[" + nodeNames + "]");
                } else {
                    node.defaultConfig.put("cluster.initial_master_nodes", "[" + nodeNames + "]");
                }
            }
            node.defaultConfig.put("discovery.seed_providers", "file");
            node.defaultConfig.put("discovery.seed_hosts", "[]");
        } else {
            node.defaultConfig.put("discovery.zen.master_election.wait_for_joins_timeout", "5s");
            if (this.nodes.size() > 1) {
                node.defaultConfig.put("discovery.zen.minimum_master_nodes", Integer.toString(this.nodes.size() / 2 + 1));
            }
            if (node.getVersion().onOrAfter("6.5.0")) {
                node.defaultConfig.put("discovery.zen.hosts_provider", "file");
                node.defaultConfig.put("discovery.zen.ping.unicast.hosts", "[]");
            } else if (firstNode == null) {
                node.defaultConfig.put("discovery.zen.ping.unicast.hosts", "[]");
            } else {
                firstNode.waitForAllConditions();
                node.defaultConfig.put("discovery.zen.ping.unicast.hosts", "[\"" + firstNode.getTransportPortURI() + "\"]");
            }
        }
    }

    @Override
    public void restart() {
        this.nodes.forEach(OpenSearchNode::restart);
    }

    public void goToNextVersion() {
        this.stop(false);
        this.nodes.all(OpenSearchNode::goToNextVersion);
        this.start();
        this.writeUnicastHostsFiles();
    }

    public void upgradeAllNodesAndPluginsToNextVersion(List<Provider<RegularFile>> plugins) {
        this.stop(false);
        this.nodes.all(OpenSearchNode::goToNextVersion);
        this.upgradePlugin(plugins);
        this.start();
        this.writeUnicastHostsFiles();
    }

    public void nextNodeToNextVersion() {
        OpenSearchNode node = this.upgradeNodeToNextVersion();
        node.start();
    }

    public void upgradeNodeAndPluginToNextVersion(List<Provider<RegularFile>> plugins) {
        OpenSearchNode node = this.upgradeNodeToNextVersion();
        node.upgradePlugin(plugins);
        node.start();
    }

    @Override
    public void extraConfigFile(String destination, File from) {
        this.nodes.all(node -> node.extraConfigFile(destination, from));
    }

    @Override
    public void extraConfigFile(String destination, File from, PropertyNormalization normalization) {
        this.nodes.all(node -> node.extraConfigFile(destination, from, normalization));
    }

    @Override
    public void extraJarFile(File from) {
        this.nodes.all(node -> node.extraJarFile(from));
    }

    @Override
    public void user(Map<String, String> userSpec) {
        this.nodes.all(node -> node.user(userSpec));
    }

    private void writeUnicastHostsFiles() {
        String unicastUris = this.nodes.stream().flatMap(node -> node.getAllTransportPortURI().stream()).collect(Collectors.joining("\n"));
        this.nodes.forEach(node -> {
            try {
                Files.write(node.getConfigDir().resolve("unicast_hosts.txt"), unicastUris.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write unicast_hosts for " + String.valueOf(this), e);
            }
        });
    }

    private OpenSearchNode upgradeNodeToNextVersion() {
        if (this.nodeIndex + 1 > this.nodes.size()) {
            throw new TestClustersException("Ran out of nodes to take to the next version");
        }
        OpenSearchNode node = (OpenSearchNode)this.nodes.getByName(this.clusterName + "-" + this.nodeIndex);
        node.stop(false);
        node.goToNextVersion();
        this.commonNodeConfig(node, null, null);
        ++this.nodeIndex;
        return node;
    }

    @Override
    @Internal
    public String getHttpSocketURI() {
        this.waitForAllConditions();
        return this.getFirstNode().getHttpSocketURI();
    }

    @Override
    @Internal
    public String getTransportPortURI() {
        this.waitForAllConditions();
        return this.getFirstNode().getTransportPortURI();
    }

    @Override
    @Internal
    public List<String> getAllHttpSocketURI() {
        this.waitForAllConditions();
        return this.nodes.stream().flatMap(each -> each.getAllHttpSocketURI().stream()).collect(Collectors.toList());
    }

    @Override
    @Internal
    public List<String> getAllTransportPortURI() {
        this.waitForAllConditions();
        return this.nodes.stream().flatMap(each -> each.getAllTransportPortURI().stream()).collect(Collectors.toList());
    }

    public void waitForAllConditions() {
        this.writeUnicastHostsFiles();
        LOGGER.info("Starting to wait for cluster to form");
        this.waitForConditions(this.waitConditions, System.currentTimeMillis(), 40L, CLUSTER_UP_TIMEOUT_UNIT, this);
    }

    @Override
    public void stop(boolean tailLogs) {
        this.nodes.forEach(each -> each.stop(tailLogs));
    }

    @Override
    public void setNameCustomization(Function<String, String> nameCustomization) {
        this.nodes.all(each -> each.setNameCustomization(nameCustomization));
    }

    @Override
    @Internal
    public boolean isProcessAlive() {
        return this.nodes.stream().noneMatch(node -> !node.isProcessAlive());
    }

    public OpenSearchNode singleNode() {
        if (this.nodes.size() != 1) {
            throw new IllegalStateException("Can't treat " + String.valueOf(this) + " as single node as it has " + this.nodes.size() + " nodes");
        }
        return this.getFirstNode();
    }

    private void addWaitForClusterHealth() {
        this.waitConditions.put("cluster health yellow", node -> {
            try {
                WaitForHttpResource wait;
                if (!this.getFirstNode().isSecure()) {
                    wait = new WaitForHttpResource("http", this.getFirstNode().getHttpSocketURI(), this.nodes.size());
                    List<Map<String, String>> credentials = this.getFirstNode().getCredentials();
                    if (!this.getFirstNode().getCredentials().isEmpty()) {
                        wait.setUsername(credentials.get(0).get("useradd"));
                        wait.setPassword(credentials.get(0).get("-p"));
                    }
                } else {
                    wait = new WaitForHttpResource("https", this.getFirstNode().getHttpSocketURI(), this.getFirstNode().getCredentials().get(0).get("username"), this.getFirstNode().getCredentials().get(0).get("password"), this.nodes.size());
                    wait.setUsername(this.getFirstNode().getCredentials().get(0).get("username"));
                    wait.setPassword(this.getFirstNode().getCredentials().get(0).get("password"));
                    wait.setCertificateAuthorities(this.getFirstNode().getExtraConfigFilesMap().get("root-ca.pem"));
                }
                return wait.wait(500);
            }
            catch (IOException e) {
                throw new UncheckedIOException("IO error while waiting cluster", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TestClustersException("Interrupted while waiting for " + String.valueOf(this), e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("security exception", e);
            }
        });
    }

    @Nested
    public NamedDomainObjectContainer<OpenSearchNode> getNodes() {
        return this.nodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSearchCluster that = (OpenSearchCluster)o;
        return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.path);
    }

    public String toString() {
        return "cluster{" + this.path + ":" + this.clusterName + "}";
    }
}

