/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test;

import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.opensearch.gradle.OpenSearchTestBasePlugin;
import org.opensearch.gradle.SystemPropertyCommandLineArgumentProvider;
import org.opensearch.gradle.test.RestIntegTestTask;
import org.opensearch.gradle.testclusters.OpenSearchCluster;
import org.opensearch.gradle.testclusters.TestClustersPlugin;

public class RestTestBasePlugin
implements Plugin<Project> {
    private static final String TESTS_REST_CLUSTER = "tests.rest.cluster";
    private static final String TESTS_CLUSTER = "tests.cluster";
    private static final String TESTS_CLUSTER_NAME = "tests.clustername";

    public void apply(Project project) {
        project.getPluginManager().apply(TestClustersPlugin.class);
        project.getPluginManager().apply(OpenSearchTestBasePlugin.class);
        project.getTasks().withType(RestIntegTestTask.class).configureEach(restIntegTestTask -> {
            NamedDomainObjectContainer testClusters = (NamedDomainObjectContainer)project.getExtensions().getByName("testClusters");
            OpenSearchCluster cluster = (OpenSearchCluster)testClusters.maybeCreate(restIntegTestTask.getName());
            restIntegTestTask.useCluster(project, cluster);
            restIntegTestTask.include(new String[]{"**/*IT.class"});
            restIntegTestTask.systemProperty("tests.rest.load_packaged", Boolean.FALSE.toString());
            if (System.getProperty(TESTS_REST_CLUSTER) == null) {
                if (System.getProperty(TESTS_CLUSTER) != null || System.getProperty(TESTS_CLUSTER_NAME) != null) {
                    throw new IllegalArgumentException(String.format("%s, %s, and %s must all be null or non-null", TESTS_REST_CLUSTER, TESTS_CLUSTER, TESTS_CLUSTER_NAME));
                }
                SystemPropertyCommandLineArgumentProvider runnerNonInputProperties = (SystemPropertyCommandLineArgumentProvider)restIntegTestTask.getExtensions().getByName("nonInputProperties");
                runnerNonInputProperties.systemProperty(TESTS_REST_CLUSTER, () -> String.join((CharSequence)",", cluster.getAllHttpSocketURI()));
                runnerNonInputProperties.systemProperty(TESTS_CLUSTER, () -> String.join((CharSequence)",", cluster.getAllTransportPortURI()));
                runnerNonInputProperties.systemProperty(TESTS_CLUSTER_NAME, cluster::getName);
            } else if (System.getProperty(TESTS_CLUSTER) == null || System.getProperty(TESTS_CLUSTER_NAME) == null) {
                throw new IllegalArgumentException(String.format("%s, %s, and %s must all be null or non-null", TESTS_REST_CLUSTER, TESTS_CLUSTER, TESTS_CLUSTER_NAME));
            }
        });
    }
}

