/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.tar;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.archive.compression.ArchiveOutputStreamFactory;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.internal.file.archive.compression.SimpleCompressor;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.api.tasks.bundling.Tar;

public class SymbolicLinkPreservingTar
extends Tar {
    private long lastModifiedTimestamp = 0L;

    public void setLastModifiedTimestamp(long lastModifiedTimestamp) {
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    protected CopyAction createCopyAction() {
        return new SymbolicLinkPreservingTarCopyAction((Provider<RegularFile>)this.getArchiveFile(), switch (this.getCompression()) {
            case Compression.BZIP2 -> Bzip2Archiver.getCompressor();
            case Compression.GZIP -> GzipArchiver.getCompressor();
            default -> new SimpleCompressor();
        }, this.isPreserveFileTimestamps(), this.lastModifiedTimestamp);
    }

    private static class SymbolicLinkPreservingTarCopyAction
    implements CopyAction {
        private final Provider<RegularFile> tarFile;
        private final ArchiveOutputStreamFactory compressor;
        private final boolean isPreserveFileTimestamps;
        private final long lastModifiedTimestamp;

        SymbolicLinkPreservingTarCopyAction(Provider<RegularFile> tarFile, ArchiveOutputStreamFactory compressor, boolean isPreserveFileTimestamps, long lastModifiedTimestamp) {
            this.tarFile = tarFile;
            this.compressor = compressor;
            this.isPreserveFileTimestamps = isPreserveFileTimestamps;
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        public WorkResult execute(CopyActionProcessingStream stream) {
            try (OutputStream out = this.compressor.createArchiveOutputStream(((RegularFile)this.tarFile.get()).getAsFile());
                 TarArchiveOutputStream tar = new TarArchiveOutputStream(out);){
                tar.setLongFileMode(2);
                stream.process((CopyActionProcessingStreamAction)new SymbolicLinkPreservingTarStreamAction(tar));
            }
            catch (IOException e) {
                throw new GradleException("failed writing tar file [" + String.valueOf(this.tarFile) + "]", (Throwable)e);
            }
            return WorkResults.didWork((boolean)true);
        }

        private long getModTime(FileCopyDetails details) {
            return this.isPreserveFileTimestamps ? details.getLastModified() : this.lastModifiedTimestamp;
        }

        private class SymbolicLinkPreservingTarStreamAction
        implements CopyActionProcessingStreamAction {
            private final TarArchiveOutputStream tar;
            private final Set<File> visitedSymbolicLinks = new HashSet<File>();

            SymbolicLinkPreservingTarStreamAction(TarArchiveOutputStream tar) {
                this.tar = tar;
            }

            public void processFile(FileCopyDetailsInternal details) {
                if (!this.isChildOfVisitedSymbolicLink(details)) {
                    if (this.isSymbolicLink(details)) {
                        this.visitSymbolicLink(details);
                    } else if (details.isDirectory()) {
                        this.visitDirectory(details);
                    } else {
                        this.visitFile(details);
                    }
                }
            }

            private boolean isChildOfVisitedSymbolicLink(FileCopyDetailsInternal details) {
                File file;
                try {
                    file = details.getFile();
                }
                catch (UnsupportedOperationException e) {
                    return false;
                }
                for (File symbolicLink : this.visitedSymbolicLinks) {
                    if (!this.isChildOf(symbolicLink, file)) continue;
                    return true;
                }
                return false;
            }

            private boolean isChildOf(File directory, File file) {
                return file.toPath().startsWith(directory.toPath());
            }

            private boolean isSymbolicLink(FileCopyDetailsInternal details) {
                File file;
                try {
                    file = details.getFile();
                }
                catch (UnsupportedOperationException e) {
                    return false;
                }
                return Files.isSymbolicLink(file.toPath());
            }

            private void visitSymbolicLink(FileCopyDetailsInternal details) {
                this.visitedSymbolicLinks.add(details.getFile());
                TarArchiveEntry entry = new TarArchiveEntry(details.getRelativePath().getPathString(), 50);
                entry.setModTime(SymbolicLinkPreservingTarCopyAction.this.getModTime((FileCopyDetails)details));
                entry.setMode(0xA000 | details.getPermissions().toUnixNumeric());
                try {
                    entry.setLinkName(Files.readSymbolicLink(details.getFile().toPath()).toString());
                    this.tar.putArchiveEntry((ArchiveEntry)entry);
                    this.tar.closeArchiveEntry();
                }
                catch (IOException e) {
                    this.handleProcessingException(details, e);
                }
            }

            private void visitDirectory(FileCopyDetailsInternal details) {
                TarArchiveEntry entry = new TarArchiveEntry(details.getRelativePath().getPathString() + "/");
                entry.setModTime(SymbolicLinkPreservingTarCopyAction.this.getModTime((FileCopyDetails)details));
                entry.setMode(0x4000 | details.getPermissions().toUnixNumeric());
                try {
                    this.tar.putArchiveEntry((ArchiveEntry)entry);
                    this.tar.closeArchiveEntry();
                }
                catch (IOException e) {
                    this.handleProcessingException(details, e);
                }
            }

            private void visitFile(FileCopyDetailsInternal details) {
                TarArchiveEntry entry = new TarArchiveEntry(details.getRelativePath().getPathString());
                entry.setModTime(SymbolicLinkPreservingTarCopyAction.this.getModTime((FileCopyDetails)details));
                entry.setMode(0x8000 | details.getPermissions().toUnixNumeric());
                entry.setSize(details.getSize());
                try {
                    this.tar.putArchiveEntry((ArchiveEntry)entry);
                    details.copyTo((OutputStream)this.tar);
                    this.tar.closeArchiveEntry();
                }
                catch (IOException e) {
                    this.handleProcessingException(details, e);
                }
            }

            private void handleProcessingException(FileCopyDetailsInternal details, IOException e) {
                throw new GradleException("could not add [" + String.valueOf(details) + "] to tar file [" + String.valueOf(SymbolicLinkPreservingTarCopyAction.this.tarFile) + "]", (Throwable)e);
            }
        }
    }
}

