/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.precommit.DependencyLicensesTask;

public class UpdateShasTask
extends DefaultTask {
    private final Logger logger = Logging.getLogger(((Object)((Object)this)).getClass());
    private TaskProvider<DependencyLicensesTask> parentTask;

    public UpdateShasTask() {
        this.setDescription("Updates the sha files for the dependencyLicenses check");
        this.setOnlyIf(element -> ((DependencyLicensesTask)((Object)((Object)this.parentTask.get()))).getLicensesDir() != null);
    }

    @TaskAction
    public void updateShas() throws NoSuchAlgorithmException, IOException {
        Set<File> shaFiles = ((DependencyLicensesTask)((Object)this.parentTask.get())).getShaFiles();
        for (File dependency : (FileCollection)((DependencyLicensesTask)((Object)this.parentTask.get())).getDependencies().get()) {
            String jarName = dependency.getName();
            File shaFile = ((DependencyLicensesTask)((Object)this.parentTask.get())).getShaFile(jarName);
            if (!shaFile.exists()) {
                this.createSha(dependency, jarName, shaFile);
                continue;
            }
            shaFiles.remove(shaFile);
        }
        for (File shaFile : shaFiles) {
            this.logger.lifecycle("Removing unused sha " + shaFile.getName());
            shaFile.delete();
        }
    }

    private void createSha(File dependency, String jarName, File shaFile) throws IOException, NoSuchAlgorithmException {
        this.logger.lifecycle("Adding sha for " + jarName);
        String sha = ((DependencyLicensesTask)((Object)this.parentTask.get())).getSha1(dependency);
        Files.write(shaFile.toPath(), sha.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
    }

    @Internal
    public DependencyLicensesTask getParentTask() {
        return (DependencyLicensesTask)((Object)this.parentTask.get());
    }

    public void setParentTask(TaskProvider<DependencyLicensesTask> parentTask) {
        this.parentTask = parentTask;
    }
}

