/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import de.thetaphi.forbiddenapis.gradle.CheckForbiddenApis;
import de.thetaphi.forbiddenapis.gradle.ForbiddenApisPlugin;
import groovy.lang.Closure;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.ExportOpenSearchBuildResourcesTask;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.precommit.PrecommitPlugin;
import org.opensearch.gradle.util.GradleUtils;

public class ForbiddenApisPrecommitPlugin
extends PrecommitPlugin {
    @Override
    public TaskProvider<? extends Task> createTask(final Project project) {
        project.getPluginManager().apply(ForbiddenApisPlugin.class);
        TaskProvider resourcesTask = project.getTasks().register("forbiddenApisResources", ExportOpenSearchBuildResourcesTask.class);
        final Path resourcesDir = project.getBuildDir().toPath().resolve("forbidden-apis-config");
        resourcesTask.configure(t -> {
            t.setOutputDir(resourcesDir.toFile());
            t.copy("forbidden/jdk-signatures.txt");
            t.copy("forbidden/opensearch-all-signatures.txt");
            t.copy("forbidden/opensearch-test-signatures.txt");
            t.copy("forbidden/http-signatures.txt");
            t.copy("forbidden/opensearch-server-signatures.txt");
        });
        project.getTasks().withType(CheckForbiddenApis.class).configureEach(t -> {
            String sourceSetName;
            t.dependsOn(new Object[]{resourcesTask});
            assert (t.getName().startsWith("forbiddenApis"));
            if ("forbiddenApis".equals(t.getName())) {
                sourceSetName = "main";
            } else {
                char[] chars = t.getName().substring("forbiddenApis".length()).toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                sourceSetName = new String(chars);
            }
            SourceSetContainer sourceSets = GradleUtils.getJavaSourceSets(project);
            SourceSet sourceSet = (SourceSet)sourceSets.getByName(sourceSetName);
            t.setClasspath(project.files(new Object[]{sourceSet.getRuntimeClasspath()}).plus(sourceSet.getCompileClasspath()));
            t.setTargetCompatibility(BuildParams.getRuntimeJavaVersion().getMajorVersion());
            if (BuildParams.getRuntimeJavaVersion().compareTo((Enum)JavaVersion.VERSION_14) > 0) {
                t.setTargetCompatibility(JavaVersion.VERSION_14.getMajorVersion());
            }
            t.setBundledSignatures(new HashSet<String>(Arrays.asList("jdk-unsafe", "jdk-deprecated", "jdk-non-portable", "jdk-system-out")));
            t.setSignaturesFiles((FileCollection)project.files(new Object[]{resourcesDir.resolve("forbidden/jdk-signatures.txt"), resourcesDir.resolve("forbidden/opensearch-all-signatures.txt")}));
            t.setSuppressAnnotations(new HashSet<String>(Arrays.asList("**.SuppressForbidden")));
            if (t.getName().endsWith("Test")) {
                t.setSignaturesFiles(t.getSignaturesFiles().plus((FileCollection)project.files(new Object[]{resourcesDir.resolve("forbidden/opensearch-test-signatures.txt"), resourcesDir.resolve("forbidden/http-signatures.txt")})));
            } else {
                t.setSignaturesFiles(t.getSignaturesFiles().plus((FileCollection)project.files(new Object[]{resourcesDir.resolve("forbidden/opensearch-server-signatures.txt")})));
            }
            ExtraPropertiesExtension ext = t.getExtensions().getExtraProperties();
            ext.set("replaceSignatureFiles", (Object)new Closure<Void>(t){

                public Void call(Object ... names) {
                    ArrayList<Path> resources = new ArrayList<Path>(names.length);
                    for (Object name : names) {
                        resources.add(resourcesDir.resolve("forbidden/" + String.valueOf(name) + ".txt"));
                    }
                    t.setSignaturesFiles((FileCollection)project.files(new Object[]{resources}));
                    return null;
                }
            });
            ext.set("addSignatureFiles", (Object)new Closure<Void>(t){

                public Void call(Object ... names) {
                    ArrayList<Path> resources = new ArrayList<Path>(names.length);
                    for (Object name : names) {
                        resources.add(resourcesDir.resolve("forbidden/" + String.valueOf(name) + ".txt"));
                    }
                    t.setSignaturesFiles(t.getSignaturesFiles().plus((FileCollection)project.files(new Object[]{resources})));
                    return null;
                }
            });
        });
        TaskProvider forbiddenApis = project.getTasks().named("forbiddenApis");
        forbiddenApis.configure(t -> t.setGroup(""));
        return forbiddenApis;
    }
}

