/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.pluginzip;

import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;

public class Publish
implements Plugin<Project> {
    public static final String PUBLICATION_NAME = "pluginZip";
    public static final String STAGING_REPO = "zipStaging";
    public static final String LOCAL_STAGING_REPO_PATH = "/build/local-staging-repo";

    private boolean isZipPublicationPresent(Project project) {
        PublishingExtension pe = (PublishingExtension)project.getExtensions().findByType(PublishingExtension.class);
        if (pe == null) {
            return false;
        }
        return pe.getPublications().findByName(PUBLICATION_NAME) != null;
    }

    private void addLocalMavenRepo(Project project) {
        Path buildDirectory = project.getRootDir().toPath();
        project.getExtensions().configure(PublishingExtension.class, publishing -> publishing.repositories(repositories -> repositories.maven(maven -> {
            maven.setName(STAGING_REPO);
            maven.setUrl((Object)(buildDirectory.toString() + LOCAL_STAGING_REPO_PATH));
        })));
    }

    private void addZipArtifact(Project project) {
        project.getExtensions().configure(PublishingExtension.class, publishing -> publishing.publications(publications -> {
            MavenPublication mavenZip = (MavenPublication)publications.findByName(PUBLICATION_NAME);
            if (mavenZip != null) {
                mavenZip.artifact((Object)project.getTasks().named("bundlePlugin"));
            }
        }));
    }

    public void apply(Project project) {
        project.getPluginManager().apply("com.netflix.nebula.maven-nebula-publish");
        project.getPluginManager().apply(MavenPublishPlugin.class);
        project.afterEvaluate(evaluatedProject -> {
            if (this.isZipPublicationPresent(project)) {
                this.addLocalMavenRepo(project);
                this.addZipArtifact(project);
                Task validatePluginZipPom = (Task)project.getTasks().findByName("validatePluginZipPom");
                Set<Task> publishPluginZipPublicationToTasks = project.getTasks().stream().filter(t -> t.getName().startsWith("publishPluginZipPublicationTo")).collect(Collectors.toSet());
                if (!publishPluginZipPublicationToTasks.isEmpty()) {
                    if (validatePluginZipPom != null) {
                        publishPluginZipPublicationToTasks.forEach(t -> t.dependsOn(new Object[]{validatePluginZipPom}));
                    } else {
                        publishPluginZipPublicationToTasks.forEach(t -> t.dependsOn(new Object[]{"generatePomFileForNebulaPublication"}));
                    }
                }
            } else {
                project.getLogger().warn(String.format("Plugin 'opensearch.pluginzip' is applied but no '%s' publication is defined.", PUBLICATION_NAME));
            }
        });
    }
}

