/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.opensearch.gradle.FileSystemOperationsAware;
import org.opensearch.gradle.LazyFileOutputStream;

public class LoggedExec
extends Exec
implements FileSystemOperationsAware {
    private static final Logger LOGGER = Logging.getLogger(LoggedExec.class);
    private Consumer<Logger> outputLogger;
    private FileSystemOperations fileSystemOperations;
    private final Project project;
    private static final Pattern NEWLINE = Pattern.compile(System.lineSeparator());

    @Inject
    public LoggedExec(FileSystemOperations fileSystemOperations, Project project) {
        this.fileSystemOperations = fileSystemOperations;
        this.project = project;
        if (!this.getLogger().isInfoEnabled()) {
            this.setIgnoreExitValue(true);
            this.setSpoolOutput(false);
            this.doLast((Action)new Action<Task>(){

                public void execute(Task task) {
                    if (((ExecResult)LoggedExec.this.getExecutionResult().get()).getExitValue() != 0) {
                        try {
                            LoggedExec.this.getLogger().error("Output for " + LoggedExec.this.getExecutable() + ":");
                            LoggedExec.this.outputLogger.accept(LoggedExec.this.getLogger());
                        }
                        catch (Exception e) {
                            throw new GradleException("Failed to read exec output", (Throwable)e);
                        }
                        throw new GradleException(String.format("Process '%s %s' finished with non-zero exit value %d", LoggedExec.this.getExecutable(), LoggedExec.this.getArgs(), ((ExecResult)LoggedExec.this.getExecutionResult().get()).getExitValue()));
                    }
                }
            });
        }
    }

    public void setSpoolOutput(boolean spoolOutput) {
        OutputStream out;
        if (spoolOutput) {
            File spoolFile = new File(String.valueOf(this.project.getBuildDir()) + "/buffered-output/" + this.getName());
            out = new LazyFileOutputStream(spoolFile);
            this.outputLogger = logger -> {
                try {
                    if (Files.exists(spoolFile.toPath(), new LinkOption[0])) {
                        Files.lines(spoolFile.toPath()).forEach(arg_0 -> ((Logger)logger).error(arg_0));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("could not log", e);
                }
            };
        } else {
            out = new ByteArrayOutputStream();
            this.outputLogger = logger -> {
                try {
                    logger.error(((ByteArrayOutputStream)out).toString("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        this.setStandardOutput(out);
        this.setErrorOutput(out);
    }

    public static ExecResult exec(Project project, Action<ExecSpec> action) {
        InjectedExecOps execOps = (InjectedExecOps)project.getObjects().newInstance(InjectedExecOps.class, new Object[0]);
        return LoggedExec.exec(execOps.getExecOps(), action);
    }

    public static ExecResult exec(ExecOperations execOperations, Action<ExecSpec> action) {
        return LoggedExec.genericExec(arg_0 -> ((ExecOperations)execOperations).exec(arg_0), action);
    }

    public static ExecResult javaexec(Project project, Action<JavaExecSpec> action) {
        InjectedExecOps execOps = (InjectedExecOps)project.getObjects().newInstance(InjectedExecOps.class, new Object[0]);
        return LoggedExec.genericExec(arg_0 -> ((ExecOperations)execOps.getExecOps()).javaexec(arg_0), action);
    }

    public static final List<String> shortLivedArgs() {
        return Arrays.asList("-XX:TieredStopAtLevel=1");
    }

    private static <T extends BaseExecSpec> ExecResult genericExec(Function<Action<T>, ExecResult> function, Action<T> action) {
        if (LOGGER.isInfoEnabled()) {
            return function.apply(action);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            return function.apply(spec -> {
                spec.setStandardOutput((OutputStream)output);
                spec.setErrorOutput((OutputStream)output);
                if (spec instanceof JavaExecSpec) {
                    ((JavaExecSpec)spec).setJvmArgs(LoggedExec.shortLivedArgs());
                }
                action.execute(spec);
                try {
                    output.write(("Output for " + spec.getExecutable() + ":").getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (Exception e) {
            try {
                if (output.size() != 0) {
                    LOGGER.error("Exec output and error:");
                    NEWLINE.splitAsStream(output.toString("UTF-8")).forEach(s -> LOGGER.error("| " + s));
                }
            }
            catch (UnsupportedEncodingException ue) {
                throw new GradleException("Failed to read exec output", (Throwable)ue);
            }
            throw e;
        }
    }

    @Override
    public WorkResult delete(Object ... objects) {
        return this.fileSystemOperations.delete(d -> d.delete(objects));
    }

    static interface InjectedExecOps {
        @Inject
        public ExecOperations getExecOps();
    }
}

