/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.provider.Provider;
import org.opensearch.gradle.DistributionDependency;
import org.opensearch.gradle.DistributionResolution;
import org.opensearch.gradle.OpenSearchDistribution;
import org.opensearch.gradle.Version;
import org.opensearch.gradle.docker.DockerSupportPlugin;
import org.opensearch.gradle.docker.DockerSupportService;
import org.opensearch.gradle.transform.SymbolicLinkPreservingUntarTransform;
import org.opensearch.gradle.transform.UnzipTransform;
import org.opensearch.gradle.util.GradleUtils;

public class DistributionDownloadPlugin
implements Plugin<Project> {
    static final String RESOLUTION_CONTAINER_NAME = "opensearch_distributions_resolutions";
    private static final String CONTAINER_NAME = "opensearch_distributions";
    private static final String FAKE_IVY_GROUP = "opensearch-distribution";
    private static final String FAKE_SNAPSHOT_IVY_GROUP = "opensearch-distribution-snapshot";
    private static final String DOWNLOAD_REPO_NAME = "opensearch-downloads";
    private static final String SNAPSHOT_REPO_NAME = "opensearch-snapshots";
    public static final String DISTRO_EXTRACTED_CONFIG_PREFIX = "opensearch_distro_extracted_";
    private static final String RELEASE_PATTERN_LAYOUT = "/core/opensearch/[revision]/[module]-min-[revision](-[classifier]).[ext]";
    private static final String SNAPSHOT_PATTERN_LAYOUT = "/snapshots/core/opensearch/[revision]/[module]-min-[revision](-[classifier])-latest.[ext]";
    private static final String BUNDLE_PATTERN_LAYOUT = "/ci/dbc/distribution-build-opensearch/[revision]/latest/linux/x64/tar/dist/opensearch/[module]-[revision](-[classifier]).[ext]";
    private NamedDomainObjectContainer<OpenSearchDistribution> distributionsContainer;
    private NamedDomainObjectContainer<DistributionResolution> distributionsResolutionStrategiesContainer;

    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(DockerSupportPlugin.class);
        Provider dockerSupport = GradleUtils.getBuildService(project.getGradle().getSharedServices(), "dockerSupportService");
        project.getDependencies().registerTransform(UnzipTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"zip");
            transformSpec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory");
        });
        ArtifactTypeDefinition tarArtifactTypeDefinition = (ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().maybeCreate("tar.gz");
        project.getDependencies().registerTransform(SymbolicLinkPreservingUntarTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)tarArtifactTypeDefinition.getName());
            transformSpec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory");
        });
        this.setupResolutionsContainer(project);
        this.setupDistributionContainer(project, dockerSupport);
        DistributionDownloadPlugin.setupDownloadServiceRepo(project);
        project.afterEvaluate(this::setupDistributions);
    }

    private void setupDistributionContainer(Project project, Provider<DockerSupportService> dockerSupport) {
        this.distributionsContainer = project.container(OpenSearchDistribution.class, name -> {
            Configuration fileConfiguration = (Configuration)project.getConfigurations().create("opensearch_distro_file_" + name);
            Configuration extractedConfiguration = (Configuration)project.getConfigurations().create(DISTRO_EXTRACTED_CONFIG_PREFIX + name);
            extractedConfiguration.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory");
            return new OpenSearchDistribution(name, project.getObjects(), dockerSupport, fileConfiguration, extractedConfiguration);
        });
        project.getExtensions().add(CONTAINER_NAME, this.distributionsContainer);
    }

    private void setupResolutionsContainer(Project project) {
        this.distributionsResolutionStrategiesContainer = project.container(DistributionResolution.class);
        this.distributionsResolutionStrategiesContainer.whenObjectAdded(resolveDependencyNotation -> resolveDependencyNotation.setPriority(this.distributionsResolutionStrategiesContainer.size()));
        project.getExtensions().add(RESOLUTION_CONTAINER_NAME, this.distributionsResolutionStrategiesContainer);
    }

    public static NamedDomainObjectContainer<OpenSearchDistribution> getContainer(Project project) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(CONTAINER_NAME);
    }

    public static NamedDomainObjectContainer<DistributionResolution> getRegistrationsContainer(Project project) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(RESOLUTION_CONTAINER_NAME);
    }

    void setupDistributions(Project project) {
        for (OpenSearchDistribution distribution : this.distributionsContainer) {
            distribution.finalizeValues();
            DependencyHandler dependencies = project.getDependencies();
            DistributionDependency distributionDependency = this.resolveDependencyNotation(project, distribution);
            dependencies.add(distribution.configuration.getName(), distributionDependency.getDefaultNotation());
            if (!distribution.getType().shouldExtract()) continue;
            dependencies.add(distribution.getExtracted().getName(), distributionDependency.getExtractedNotation());
        }
    }

    private DistributionDependency resolveDependencyNotation(Project p, OpenSearchDistribution distribution) {
        return this.distributionsResolutionStrategiesContainer.stream().sorted(Comparator.comparingInt(DistributionResolution::getPriority)).map(r -> r.getResolver().resolve(p, distribution)).filter(Objects::nonNull).findFirst().orElseGet(() -> DistributionDependency.of(this.dependencyNotation(distribution)));
    }

    private static void addIvyRepo(Project project, String name, String url, String group, String ... patternLayout) {
        project.getRepositories().exclusiveContent(exclusiveContentRepository -> {
            exclusiveContentRepository.filter(config -> config.includeGroup(group));
            exclusiveContentRepository.forRepositories((ArtifactRepository[])Arrays.stream(patternLayout).map(pattern -> project.getRepositories().ivy(repo -> {
                repo.setName(name);
                repo.setUrl((Object)url);
                repo.metadataSources(IvyArtifactRepository.MetadataSources::artifact);
                repo.patternLayout(layout -> layout.artifact(pattern));
            })).toArray(IvyArtifactRepository[]::new));
        });
    }

    private static void setupDownloadServiceRepo(Project project) {
        String distributionDownloadType;
        if (project.getRepositories().findByName(DOWNLOAD_REPO_NAME) != null) {
            return;
        }
        Object customDistributionUrl = project.findProperty("customDistributionUrl");
        Object customDistributionDownloadType = project.findProperty("customDistributionDownloadType");
        String string = distributionDownloadType = customDistributionDownloadType != null && customDistributionDownloadType.toString().equals("bundle") ? "bundle" : "min";
        if (customDistributionUrl != null) {
            DistributionDownloadPlugin.addIvyRepo(project, DOWNLOAD_REPO_NAME, customDistributionUrl.toString(), FAKE_IVY_GROUP, "");
            DistributionDownloadPlugin.addIvyRepo(project, SNAPSHOT_REPO_NAME, customDistributionUrl.toString(), FAKE_SNAPSHOT_IVY_GROUP, "");
            return;
        }
        switch (distributionDownloadType) {
            case "bundle": {
                DistributionDownloadPlugin.addIvyRepo(project, DOWNLOAD_REPO_NAME, "https://ci.opensearch.org", FAKE_IVY_GROUP, BUNDLE_PATTERN_LAYOUT);
                DistributionDownloadPlugin.addIvyRepo(project, SNAPSHOT_REPO_NAME, "https://ci.opensearch.org", FAKE_SNAPSHOT_IVY_GROUP, BUNDLE_PATTERN_LAYOUT);
                break;
            }
            case "min": {
                DistributionDownloadPlugin.addIvyRepo(project, DOWNLOAD_REPO_NAME, "https://artifacts.opensearch.org", FAKE_IVY_GROUP, "/releases/core/opensearch/[revision]/[module]-min-[revision](-[classifier]).[ext]", "/release-candidates/core/opensearch/[revision]/[module]-min-[revision](-[classifier]).[ext]");
                DistributionDownloadPlugin.addIvyRepo(project, SNAPSHOT_REPO_NAME, "https://artifacts.opensearch.org", FAKE_SNAPSHOT_IVY_GROUP, SNAPSHOT_PATTERN_LAYOUT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported property argument: " + distributionDownloadType);
            }
        }
    }

    private String dependencyNotation(OpenSearchDistribution distribution) {
        Object classifier;
        String extension;
        block9: {
            block8: {
                Version distroVersion = Version.fromString(distribution.getVersion());
                if (distribution.getType() == OpenSearchDistribution.Type.INTEG_TEST_ZIP) {
                    return "org.opensearch.distribution.integ-test-zip:opensearch:" + distribution.getVersion() + "@zip";
                }
                extension = distribution.getType().toString();
                Object object = classifier = distroVersion.onOrAfter("1.0.0") ? ":x64" : ":x86_64";
                if (distribution.getType() != OpenSearchDistribution.Type.ARCHIVE) break block8;
                extension = distribution.getPlatform() == OpenSearchDistribution.Platform.WINDOWS ? "zip" : "tar.gz";
                switch (distribution.getArchitecture()) {
                    case ARM64: {
                        classifier = ":" + String.valueOf((Object)distribution.getPlatform()) + "-arm64";
                        break block9;
                    }
                    case X64: {
                        classifier = ":" + String.valueOf((Object)distribution.getPlatform()) + "-x64";
                        break block9;
                    }
                    case S390X: {
                        classifier = ":" + String.valueOf((Object)distribution.getPlatform()) + "-s390x";
                        break block9;
                    }
                    case PPC64LE: {
                        classifier = ":" + String.valueOf((Object)distribution.getPlatform()) + "-ppc64le";
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported architecture: " + String.valueOf((Object)distribution.getArchitecture()));
                    }
                }
            }
            if (distribution.getType() == OpenSearchDistribution.Type.DEB) {
                classifier = ":amd64";
            }
        }
        String group = distribution.getVersion().endsWith("-SNAPSHOT") ? FAKE_SNAPSHOT_IVY_GROUP : FAKE_IVY_GROUP;
        return group + ":opensearch:" + distribution.getVersion() + (String)classifier + "@" + extension;
    }
}

