/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.gradle.Version;
import org.opensearch.gradle.VersionProperties;

public class BwcVersions {
    private static final Pattern LINE_PATTERN = Pattern.compile("\\W+public static final (LegacyES)?Version V_(\\d+)_(\\d+)_(\\d+)(_alpha\\d+|_beta\\d+|_rc\\d+)? .*");
    private final Version currentVersion;
    private final Map<Integer, List<Version>> groupByMajor;
    private final Map<Version, UnreleasedVersionInfo> unreleased;

    public BwcVersions(List<String> versionLines) {
        this(versionLines, Version.fromString(VersionProperties.getOpenSearch()));
    }

    protected BwcVersions(List<String> versionLines, Version currentVersionProperty) {
        this(versionLines.stream().map(LINE_PATTERN::matcher).filter(Matcher::matches).map(match -> new Version(Integer.parseInt(match.group(2)), Integer.parseInt(match.group(3)), Integer.parseInt(match.group(4)))).collect(Collectors.toCollection(TreeSet::new)), currentVersionProperty);
    }

    public BwcVersions(SortedSet<Version> allVersions, Version currentVersionProperty) {
        if (allVersions.isEmpty()) {
            throw new IllegalArgumentException("Could not parse any versions");
        }
        this.currentVersion = allVersions.last();
        this.groupByMajor = allVersions.stream().filter(version -> version.getMajor() > this.currentVersion.getMajor() - 2).collect(Collectors.groupingBy(Version::getMajor, Collectors.toList()));
        this.assertCurrentVersionMatchesParsed(currentVersionProperty);
        this.assertNoOlderThanTwoMajors();
        HashMap<Version, UnreleasedVersionInfo> unreleased = new HashMap<Version, UnreleasedVersionInfo>();
        for (Version unreleasedVersion : this.getUnreleased()) {
            unreleased.put(unreleasedVersion, new UnreleasedVersionInfo(unreleasedVersion, this.getBranchFor(unreleasedVersion), this.getGradleProjectPathFor(unreleasedVersion)));
        }
        this.unreleased = Collections.unmodifiableMap(unreleased);
    }

    private void assertNoOlderThanTwoMajors() {
        Set<Integer> majors = this.groupByMajor.keySet();
        int numSupportedMajors = 2;
        if (majors.size() != numSupportedMajors && this.currentVersion.getMinor() != 0 && this.currentVersion.getRevision() != 0) {
            throw new IllegalStateException("Expected exactly 2 majors in parsed versions but found: " + String.valueOf(majors));
        }
    }

    private void assertCurrentVersionMatchesParsed(Version currentVersionProperty) {
        if (!currentVersionProperty.equals(this.currentVersion)) {
            throw new IllegalStateException("Parsed versions latest version does not match the one configured in build properties. Parsed latest version is " + String.valueOf(this.currentVersion) + " but the build has " + String.valueOf(currentVersionProperty));
        }
    }

    public UnreleasedVersionInfo unreleasedInfo(Version version) {
        return this.unreleased.get(version);
    }

    public void forPreviousUnreleased(Consumer<UnreleasedVersionInfo> consumer) {
        List<UnreleasedVersionInfo> collect = this.getUnreleased().stream().filter(version -> !version.equals(this.currentVersion)).map(version -> new UnreleasedVersionInfo((Version)version, this.getBranchFor((Version)version), this.getGradleProjectPathFor((Version)version))).collect(Collectors.toList());
        collect.forEach(consumer);
    }

    private String getGradleProjectPathFor(Version version) {
        if (version.equals(this.currentVersion)) {
            return ":distribution";
        }
        Map<Integer, List<Version>> releasedMajorGroupedByMinor = this.getReleasedMajorGroupedByMinor();
        if (version.getRevision() == 0) {
            List unreleasedStagedOrMinor = this.getUnreleased().stream().filter(v -> v.getRevision() == 0).collect(Collectors.toList());
            if (unreleasedStagedOrMinor.size() > 2) {
                if (((Version)unreleasedStagedOrMinor.get(unreleasedStagedOrMinor.size() - 2)).equals(version)) {
                    return ":distribution:bwc:minor";
                }
                return ":distribution:bwc:staged";
            }
            return ":distribution:bwc:minor";
        }
        if (releasedMajorGroupedByMinor.getOrDefault(version.getMinor(), Collections.emptyList()).contains(version)) {
            return ":distribution:bwc:bugfix";
        }
        return ":distribution:bwc:maintenance";
    }

    private String getBranchFor(Version version) {
        switch (this.getGradleProjectPathFor(version)) {
            case ":distribution": {
                return "master";
            }
            case ":distribution:bwc:minor": {
                Version latestInMajor = this.getLatestVersionByKey(this.groupByMajor, version.getMajor());
                if (latestInMajor.getMinor() == version.getMinor()) {
                    return version.getMajor() + ".x";
                }
                return version.getMajor() + "." + version.getMinor();
            }
            case ":distribution:bwc:staged": 
            case ":distribution:bwc:maintenance": 
            case ":distribution:bwc:bugfix": {
                return version.getMajor() + "." + version.getMinor();
            }
        }
        throw new IllegalStateException("Unexpected Gradle project name");
    }

    public List<Version> getUnreleased() {
        ArrayList<Version> unreleased = new ArrayList<Version>();
        unreleased.add(this.currentVersion);
        if (this.currentVersion.getMajor() != 1) {
            Version previousMinor;
            Version latestOfPreviousMajor = this.getLatestVersionByKey(this.groupByMajor, this.currentVersion.getMajor() - 1);
            unreleased.add(latestOfPreviousMajor);
            if (latestOfPreviousMajor.getRevision() == 0 && (previousMinor = this.getLatestInMinor(latestOfPreviousMajor.getMajor(), latestOfPreviousMajor.getMinor() - 1)) != null) {
                unreleased.add(previousMinor);
            }
        }
        Map<Integer, List<Version>> groupByMinor = this.getReleasedMajorGroupedByMinor();
        int greatestMinor = groupByMinor.keySet().stream().max(Integer::compareTo).orElse(0);
        unreleased.add(this.getLatestVersionByKey(groupByMinor, greatestMinor));
        if (groupByMinor.get(greatestMinor).size() == 1) {
            unreleased.add(this.getLatestVersionByKey(groupByMinor, greatestMinor - 1));
            if (groupByMinor.getOrDefault(greatestMinor - 1, Collections.emptyList()).size() == 1 && greatestMinor >= 2) {
                unreleased.add(this.getLatestVersionByKey(groupByMinor, greatestMinor - 2));
            }
        }
        return unreleased.stream().sorted().distinct().collect(Collectors.toUnmodifiableList());
    }

    private Version getLatestInMinor(int major, int minor) {
        return this.groupByMajor.get(major).stream().filter(v -> v.getMinor() == minor).max(Version::compareTo).orElse(null);
    }

    private Version getLatestVersionByKey(Map<Integer, List<Version>> groupByMajor, int key) {
        return (Version)groupByMajor.getOrDefault(key, Collections.emptyList()).stream().max(Version::compareTo).orElseThrow(() -> new IllegalStateException("Unexpected number of versions in collection"));
    }

    private Map<Integer, List<Version>> getReleasedMajorGroupedByMinor() {
        int currentMajor = this.currentVersion.getMajor();
        List<Version> currentMajorVersions = this.groupByMajor.get(currentMajor);
        List<Version> previousMajorVersions = this.groupByMajor.get(this.getPreviousMajor(currentMajor));
        Map<Integer, List<Version>> groupByMinor = currentMajorVersions.size() == 1 ? previousMajorVersions.stream().collect(Collectors.groupingBy(Version::getMinor, Collectors.toList())) : currentMajorVersions.stream().collect(Collectors.groupingBy(Version::getMinor, Collectors.toList()));
        return groupByMinor;
    }

    public void compareToAuthoritative(List<Version> authoritativeReleasedVersions) {
        HashSet<Version> notReallyReleased = new HashSet<Version>(this.getReleased());
        authoritativeReleasedVersions.forEach(notReallyReleased::remove);
        if (!notReallyReleased.isEmpty()) {
            throw new IllegalStateException("out-of-date released versions\nFollowing versions are not really released, but the build thinks they are: " + String.valueOf(notReallyReleased));
        }
        HashSet<Version> incorrectlyConsideredUnreleased = new HashSet<Version>(authoritativeReleasedVersions);
        incorrectlyConsideredUnreleased.retainAll(this.getUnreleased());
        if (!incorrectlyConsideredUnreleased.isEmpty()) {
            throw new IllegalStateException("out-of-date released versions\nBuild considers versions unreleased, but they are released according to an authoritative source: " + String.valueOf(incorrectlyConsideredUnreleased) + "\nThe next versions probably needs to be added to Version.java (CURRENT doesn't count).");
        }
    }

    private List<Version> getReleased() {
        List<Version> unreleased = this.getUnreleased();
        return this.groupByMajor.values().stream().flatMap(Collection::stream).filter(each -> !unreleased.contains(each)).collect(Collectors.toList());
    }

    public List<Version> getIndexCompatible() {
        int currentMajor = this.currentVersion.getMajor();
        int prevMajor = this.getPreviousMajor(currentMajor);
        return Stream.concat(this.groupByMajor.get(prevMajor).stream(), this.groupByMajor.get(currentMajor).stream()).filter(version -> !version.equals(this.currentVersion)).collect(Collectors.toUnmodifiableList());
    }

    public List<Version> getWireCompatible() {
        ArrayList<Version> wireCompat = new ArrayList<Version>();
        int currentMajor = this.currentVersion.getMajor();
        int lastMajor = currentMajor - 1;
        List<Version> lastMajorList = this.groupByMajor.get(lastMajor);
        if (lastMajorList == null) {
            throw new IllegalStateException("Expected to find a list of versions for version: " + lastMajor);
        }
        int minor = lastMajorList.get(lastMajorList.size() - 1).getMinor();
        for (int i = lastMajorList.size() - 1; i > 0 && lastMajorList.get(i).getMinor() == minor; --i) {
            wireCompat.add(lastMajorList.get(i));
        }
        wireCompat.addAll((Collection)this.groupByMajor.get(currentMajor));
        wireCompat.remove(this.currentVersion);
        wireCompat.sort(Version::compareTo);
        return Collections.unmodifiableList(wireCompat);
    }

    public List<Version> getUnreleasedIndexCompatible() {
        ArrayList<Version> unreleasedIndexCompatible = new ArrayList<Version>(this.getIndexCompatible());
        unreleasedIndexCompatible.retainAll(this.getUnreleased());
        return Collections.unmodifiableList(unreleasedIndexCompatible);
    }

    public List<Version> getUnreleasedWireCompatible() {
        ArrayList<Version> unreleasedWireCompatible = new ArrayList<Version>(this.getWireCompatible());
        unreleasedWireCompatible.retainAll(this.getUnreleased());
        return Collections.unmodifiableList(unreleasedWireCompatible);
    }

    private int getPreviousMajor(int currentMajor) {
        return currentMajor - 1;
    }

    public static class UnreleasedVersionInfo {
        public final Version version;
        public final String branch;
        public final String gradleProjectPath;

        UnreleasedVersionInfo(Version version, String branch, String gradleProjectPath) {
            this.version = version;
            this.branch = branch;
            this.gradleProjectPath = gradleProjectPath;
        }
    }
}

