/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;

public class PermissionUtils {
    public static void chmod(Path path, int mode) throws IOException {
        PosixFileAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (view != null && mode != 0) {
            Set<PosixFilePermission> permissions = PermissionUtils.permissionsFromInt(mode);
            Files.setPosixFilePermissions(path, permissions);
        }
    }

    private static Set<PosixFilePermission> permissionsFromInt(int mode) {
        return PosixFilePermissions.fromString(PermissionUtils.permissions(mode >> 6 & 7) + PermissionUtils.permissions(mode >> 3 & 7) + PermissionUtils.permissions(mode >> 0 & 7));
    }

    private static String permissions(int permissions) {
        if (permissions < 0 || permissions > 7) {
            throw new IllegalArgumentException("permissions [" + permissions + "] out of range");
        }
        StringBuilder sb = new StringBuilder(3);
        if ((permissions & 4) == 4) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((permissions & 2) == 2) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((permissions & 1) == 1) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }
}

