/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test.rest;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.opensearch.gradle.OpenSearchJavaPlugin;
import org.opensearch.gradle.test.RestIntegTestTask;
import org.opensearch.gradle.test.RestTestBasePlugin;
import org.opensearch.gradle.test.rest.CopyRestApiTask;
import org.opensearch.gradle.test.rest.CopyRestTestsTask;
import org.opensearch.gradle.test.rest.RestResourcesPlugin;
import org.opensearch.gradle.test.rest.RestTestUtil;
import org.opensearch.gradle.testclusters.TestClustersPlugin;
import org.opensearch.gradle.util.GradleUtils;

public class YamlRestTestPlugin
implements Plugin<Project> {
    public static final String SOURCE_SET_NAME = "yamlRestTest";

    public void apply(Project project) {
        project.getPluginManager().apply(OpenSearchJavaPlugin.class);
        project.getPluginManager().apply(TestClustersPlugin.class);
        project.getPluginManager().apply(RestTestBasePlugin.class);
        project.getPluginManager().apply(RestResourcesPlugin.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet yamlTestSourceSet = (SourceSet)sourceSets.create(SOURCE_SET_NAME);
        RestTestUtil.createTestCluster(project, yamlTestSourceSet);
        Provider<RestIntegTestTask> yamlRestTestTask = RestTestUtil.registerTask(project, yamlTestSourceSet);
        RestTestUtil.setupDependencies(project, yamlTestSourceSet);
        project.getTasks().withType(CopyRestApiTask.class, copyRestApiTask -> {
            copyRestApiTask.sourceSetName = SOURCE_SET_NAME;
            project.getTasks().named(yamlTestSourceSet.getProcessResourcesTaskName()).configure(t -> t.dependsOn(new Object[]{copyRestApiTask}));
        });
        project.getTasks().withType(CopyRestTestsTask.class, copyRestTestTask -> {
            copyRestTestTask.sourceSetName = SOURCE_SET_NAME;
        });
        GradleUtils.setupIdeForTestSourceSet(project, yamlTestSourceSet);
        project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{yamlRestTestTask}));
    }
}

