/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test.rest;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.VersionProperties;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.test.rest.CopyRestApiTask;
import org.opensearch.gradle.test.rest.CopyRestTestsTask;
import org.opensearch.gradle.test.rest.RestResourcesExtension;

public class RestResourcesPlugin
implements Plugin<Project> {
    private static final String EXTENSION_NAME = "restResources";

    public void apply(Project project) {
        RestResourcesExtension extension = (RestResourcesExtension)project.getExtensions().create(EXTENSION_NAME, RestResourcesExtension.class, new Object[0]);
        Configuration testConfig = (Configuration)project.getConfigurations().create("restTestConfig");
        project.getConfigurations().create("restTests");
        TaskProvider copyRestYamlTestTask = project.getTasks().register("copyYamlTestsTask", CopyRestTestsTask.class, task -> {
            task.includeCore.set(extension.restTests.getIncludeCore());
            task.coreConfig = testConfig;
            task.sourceSetName = "test";
            if (BuildParams.isInternal().booleanValue()) {
                Dependency restTestdependency = project.getDependencies().project((Map)new HashMap<String, String>(){
                    {
                        this.put("path", ":rest-api-spec");
                        this.put("configuration", "restTests");
                    }
                });
                project.getDependencies().add(task.coreConfig.getName(), (Object)restTestdependency);
            } else {
                Dependency dependency = project.getDependencies().create((Object)("org.opensearch:rest-api-spec:" + VersionProperties.getOpenSearch()));
                project.getDependencies().add(task.coreConfig.getName(), (Object)dependency);
            }
            task.dependsOn(new Object[]{task.coreConfig});
        });
        Configuration specConfig = (Configuration)project.getConfigurations().create("restSpec");
        project.getConfigurations().create("restSpecs");
        TaskProvider copyRestYamlSpecTask = project.getTasks().register("copyRestApiSpecsTask", CopyRestApiTask.class, arg_0 -> this.lambda$apply$1(extension, (Provider)copyRestYamlTestTask, specConfig, project, arg_0));
        project.afterEvaluate(arg_0 -> RestResourcesPlugin.lambda$apply$3(project, (Provider)copyRestYamlSpecTask, arg_0));
    }

    private static /* synthetic */ void lambda$apply$3(Project project, Provider copyRestYamlSpecTask, Project p) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet testSourceSet = (SourceSet)sourceSets.findByName("test");
        if (testSourceSet != null) {
            project.getTasks().named(testSourceSet.getProcessResourcesTaskName()).configure(t -> t.dependsOn(new Object[]{copyRestYamlSpecTask}));
        }
    }

    private /* synthetic */ void lambda$apply$1(RestResourcesExtension extension, Provider copyRestYamlTestTask, Configuration specConfig, Project project, CopyRestApiTask task) {
        task.includeCore.set(extension.restApi.getIncludeCore());
        task.dependsOn(new Object[]{copyRestYamlTestTask});
        task.coreConfig = specConfig;
        task.sourceSetName = "test";
        if (BuildParams.isInternal().booleanValue()) {
            Dependency restSpecDependency = project.getDependencies().project((Map)new HashMap<String, String>(){
                {
                    this.put("path", ":rest-api-spec");
                    this.put("configuration", "restSpecs");
                }
            });
            project.getDependencies().add(task.coreConfig.getName(), (Object)restSpecDependency);
        } else {
            Dependency dependency = project.getDependencies().create((Object)("org.opensearch:rest-api-spec:" + VersionProperties.getOpenSearch()));
            project.getDependencies().add(task.coreConfig.getName(), (Object)dependency);
        }
        task.dependsOn(new Object[]{task.coreConfig});
    }
}

