/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test;

import java.io.File;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.ExportOpenSearchBuildResourcesTask;
import org.opensearch.gradle.precommit.ForbiddenPatternsTask;
import org.opensearch.gradle.test.RestIntegTestTask;
import org.opensearch.gradle.test.StandaloneRestTestPlugin;
import org.opensearch.gradle.testclusters.TestClustersAware;
import org.opensearch.gradle.testclusters.TestClustersPlugin;
import org.opensearch.gradle.util.Util;

public class TestWithSslPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        File keyStoreDir = new File(project.getBuildDir(), "keystore");
        TaskProvider exportKeyStore = project.getTasks().register("copyTestCertificates", ExportOpenSearchBuildResourcesTask.class, t -> {
            t.copy("test/ssl/test-client.crt");
            t.copy("test/ssl/test-client.jks");
            t.copy("test/ssl/test-node.crt");
            t.copy("test/ssl/test-node.jks");
            t.setOutputDir(keyStoreDir);
        });
        project.getPlugins().withType(StandaloneRestTestPlugin.class).configureEach(restTestPlugin -> {
            SourceSet testSourceSet = Util.getJavaTestSourceSet(project).get();
            testSourceSet.getResources().srcDir((Object)new File(keyStoreDir, "test/ssl"));
            testSourceSet.compiledBy(new Object[]{exportKeyStore});
            project.getTasks().withType(TestClustersAware.class).configureEach(clusterAware -> clusterAware.dependsOn(new Object[]{exportKeyStore}));
            project.getTasks().withType(RestIntegTestTask.class).configureEach(runner -> runner.systemProperty("tests.ssl.enabled", "true"));
        });
        project.getPlugins().withType(TestClustersPlugin.class).configureEach(clustersPlugin -> {
            File keystoreDir = new File(project.getBuildDir(), "keystore/test/ssl");
            File nodeKeystore = new File(keystoreDir, "test-node.jks");
            File clientKeyStore = new File(keystoreDir, "test-client.jks");
            NamedDomainObjectContainer clusters = (NamedDomainObjectContainer)project.getExtensions().getByName("testClusters");
            clusters.all(c -> {
                c.extraConfigFile(nodeKeystore.getName(), nodeKeystore);
                c.extraConfigFile(clientKeyStore.getName(), clientKeyStore);
            });
        });
        project.getTasks().withType(ForbiddenPatternsTask.class).configureEach(forbiddenPatternTask -> forbiddenPatternTask.exclude("**/*.crt"));
    }
}

