/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.tasks.testing.logging.FullExceptionFormatter;
import org.gradle.api.internal.tasks.testing.logging.TestExceptionFormatter;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.api.tasks.testing.logging.TestLogging;

public class ErrorReportingTestListener
implements TestOutputListener,
TestListener {
    private static final String REPRODUCE_WITH_PREFIX = "REPRODUCE WITH";
    private final TestExceptionFormatter formatter;
    private final File outputDirectory;
    private final Logger taskLogger;
    private Map<Descriptor, EventWriter> eventWriters = new ConcurrentHashMap<Descriptor, EventWriter>();
    private Map<Descriptor, Deque<String>> reproductionLines = new ConcurrentHashMap<Descriptor, Deque<String>>();
    private Set<Descriptor> failedTests = new LinkedHashSet<Descriptor>();

    public ErrorReportingTestListener(TestLogging testLogging, Logger taskLogger, File outputDirectory) {
        this.formatter = new FullExceptionFormatter(testLogging);
        this.taskLogger = taskLogger;
        this.outputDirectory = outputDirectory;
    }

    public void onOutput(TestDescriptor testDescriptor, TestOutputEvent outputEvent) {
        TestDescriptor suite = testDescriptor.getParent();
        if (testDescriptor.isComposite()) {
            suite = testDescriptor;
        }
        if (outputEvent.getMessage().startsWith(REPRODUCE_WITH_PREFIX)) {
            Deque lines = this.reproductionLines.computeIfAbsent(Descriptor.of(suite), d -> new LinkedList());
            lines.add(outputEvent.getMessage());
        }
        EventWriter eventWriter = this.eventWriters.computeIfAbsent(Descriptor.of(suite), x$0 -> new EventWriter((Descriptor)x$0));
        eventWriter.write(outputEvent);
    }

    public void beforeSuite(TestDescriptor suite) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSuite(TestDescriptor suite, TestResult result) {
        Descriptor descriptor = Descriptor.of(suite);
        try {
            Object eventWriter;
            if (result.getResultType().equals((Object)TestResult.ResultType.FAILURE) && (eventWriter = this.eventWriters.get(descriptor)) != null) {
                ErrorReportingTestListener errorReportingTestListener = this;
                synchronized (errorReportingTestListener) {
                    ((EventWriter)eventWriter).flush();
                    System.err.println("\n\nSuite: " + suite);
                    try (BufferedReader reader = ((EventWriter)eventWriter).reader();){
                        PrintStream out = System.out;
                        String message = reader.readLine();
                        while (message != null) {
                            if (message.startsWith("  1> ")) {
                                out = System.out;
                            } else if (message.startsWith("  2> ")) {
                                out = System.err;
                            }
                            out.println(message);
                            message = reader.readLine();
                        }
                    }
                }
            }
            if (suite.getParent() == null && this.getFailedTests().size() > 0) {
                this.taskLogger.lifecycle("\nTests with failures:");
                for (Descriptor failure : this.getFailedTests()) {
                    this.taskLogger.lifecycle(" - " + failure.getFullName());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error reading test suite output", e);
        }
        finally {
            this.reproductionLines.remove(descriptor);
            EventWriter writer = this.eventWriters.remove(descriptor);
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.taskLogger.error("Failed to close test suite output stream", (Throwable)e);
                }
            }
        }
    }

    public void beforeTest(TestDescriptor testDescriptor) {
    }

    public void afterTest(TestDescriptor testDescriptor, TestResult result) {
        if (result.getResultType() == TestResult.ResultType.FAILURE) {
            this.failedTests.add(Descriptor.of(testDescriptor));
            if (testDescriptor.getParent() != null) {
                String line;
                Deque<String> lines = this.reproductionLines.get(Descriptor.of(testDescriptor.getParent()));
                if (lines != null && (line = lines.getLast()) != null) {
                    System.err.print("\n" + line);
                }
                if (result.getExceptions().size() > 0) {
                    final String message = this.formatter.format(testDescriptor, result.getExceptions()).substring(4);
                    EventWriter eventWriter = this.eventWriters.computeIfAbsent(Descriptor.of(testDescriptor.getParent()), x$0 -> new EventWriter((Descriptor)x$0));
                    eventWriter.write(new TestOutputEvent(){

                        public TestOutputEvent.Destination getDestination() {
                            return TestOutputEvent.Destination.StdErr;
                        }

                        public String getMessage() {
                            return message;
                        }
                    });
                }
            }
        }
    }

    public Set<Descriptor> getFailedTests() {
        return this.failedTests;
    }

    public static class Descriptor {
        private final String name;
        private final String className;
        private final String parent;

        private Descriptor(String name, String className, String parent) {
            this.name = name;
            this.className = className;
            this.parent = parent;
        }

        public static Descriptor of(TestDescriptor d) {
            return new Descriptor(d.getName(), d.getClassName(), d.getParent() == null ? null : d.getParent().toString());
        }

        public String getClassName() {
            return this.className;
        }

        public String getFullName() {
            return this.className + "." + this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Descriptor that = (Descriptor)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.className, that.className) && Objects.equals(this.parent, that.parent);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.className, this.parent);
        }
    }

    private class EventWriter
    implements Closeable {
        private final File outputFile;
        private final Writer writer;

        EventWriter(Descriptor descriptor) {
            FileOutputStream fos;
            this.outputFile = new File(ErrorReportingTestListener.this.outputDirectory, descriptor.getClassName() + ".out");
            try {
                fos = new FileOutputStream(this.outputFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to create test suite output file", e);
            }
            this.writer = new PrintWriter(new BufferedOutputStream(fos));
        }

        public void write(TestOutputEvent event) {
            String prefix = event.getDestination() == TestOutputEvent.Destination.StdOut ? "  1> " : "  2> ";
            try {
                if (event.getMessage().equals("\n")) {
                    this.writer.write(event.getMessage());
                } else {
                    this.writer.write(prefix + event.getMessage());
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to write test suite output", e);
            }
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public BufferedReader reader() {
            try {
                return new BufferedReader(new FileReader(this.outputFile));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to read test suite output file", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            this.outputFile.delete();
        }
    }
}

