/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.precommit.PomValidationTask;
import org.opensearch.gradle.precommit.PrecommitPlugin;
import org.opensearch.gradle.util.Util;

public class PomValidationPrecommitPlugin
extends PrecommitPlugin {
    @Override
    public TaskProvider<? extends Task> createTask(Project project) {
        TaskProvider validatePom = project.getTasks().register("validatePom");
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        publishing.getPublications().all(publication -> {
            String publicationName = Util.capitalize(publication.getName());
            TaskProvider validateTask = project.getTasks().register("validate" + publicationName + "Pom", PomValidationTask.class);
            validatePom.configure(t -> t.dependsOn(new Object[]{validateTask}));
            validateTask.configure(task -> {
                GenerateMavenPom generateMavenPom = (GenerateMavenPom)project.getTasks().withType(GenerateMavenPom.class).getByName("generatePomFileFor" + publicationName + "Publication");
                task.dependsOn(new Object[]{generateMavenPom});
                task.getPomFile().fileValue(generateMavenPom.getDestination());
            });
        });
        return validatePom;
    }
}

