/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.opensearch.gradle.OS;
import org.opensearch.gradle.SimpleCommandLineArgumentProvider;
import org.opensearch.gradle.SystemPropertyCommandLineArgumentProvider;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.info.GlobalBuildInfoPlugin;
import org.opensearch.gradle.jvm.JvmTestSuiteHelper;
import org.opensearch.gradle.test.ErrorReportingTestListener;
import org.opensearch.gradle.util.FileUtils;
import org.opensearch.gradle.util.GradleUtils;
import org.opensearch.gradle.util.Util;

public class OpenSearchTestBasePlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getRootProject().getPluginManager().apply(GlobalBuildInfoPlugin.class);
        GradleUtils.maybeConfigure(project.getTasks(), "test", Test.class, task -> task.include(new String[]{"**/*Tests.class"}));
        if (project.getPath().equals(":build-tools")) {
            return;
        }
        final File heapdumpDir = new File(project.getBuildDir(), "heapdump");
        project.getTasks().withType(Test.class).configureEach(test -> {
            final File testOutputDir = new File((File)test.getReports().getJunitXml().getOutputLocation().getAsFile().get(), "output");
            ErrorReportingTestListener listener = new ErrorReportingTestListener((TestLogging)test.getTestLogging(), test.getLogger(), testOutputDir);
            test.getExtensions().add("errorReportingTestListener", (Object)listener);
            test.addTestOutputListener((TestOutputListener)listener);
            test.addTestListener((TestListener)listener);
            SystemPropertyCommandLineArgumentProvider nonInputProperties = new SystemPropertyCommandLineArgumentProvider();
            test.doFirst((Action)new Action<Task>(){

                public void execute(Task t) {
                    FileUtils.mkdirs(testOutputDir);
                    FileUtils.mkdirs(heapdumpDir);
                    FileUtils.mkdirs(test.getWorkingDir());
                    FileUtils.mkdirs(test.getWorkingDir().toPath().resolve("temp").toFile());
                    if (BuildParams.getRuntimeJavaVersion() == JavaVersion.VERSION_1_8) {
                        test.systemProperty("java.locale.providers", (Object)"SPI,JRE");
                    } else {
                        test.systemProperty("java.locale.providers", (Object)"SPI,COMPAT");
                        test.jvmArgs(new Object[]{"--illegal-access=warn"});
                    }
                }
            });
            test.getJvmArgumentProviders().add(nonInputProperties);
            test.getExtensions().add("nonInputProperties", (Object)nonInputProperties);
            test.setWorkingDir(project.file((Object)(project.getBuildDir() + "/testrun/" + test.getName())));
            test.setMaxParallelForks(Integer.parseInt(System.getProperty("tests.jvms", BuildParams.getDefaultParallel().toString())));
            test.exclude(new String[]{"**/*$*.class"});
            test.jvmArgs(new Object[]{"-Xmx" + System.getProperty("tests.heap.size", "512m"), "-Xms" + System.getProperty("tests.heap.size", "512m"), "-XX:+HeapDumpOnOutOfMemoryError"});
            test.getJvmArgumentProviders().add(new SimpleCommandLineArgumentProvider("-XX:HeapDumpPath=" + heapdumpDir));
            String argline = System.getProperty("tests.jvm.argline");
            if (argline != null) {
                test.jvmArgs((Object[])argline.split(" "));
            }
            if (Util.getBooleanProperty("tests.asserts", true)) {
                test.jvmArgs(new Object[]{"-ea", "-esa"});
            }
            HashMap<String, String> sysprops = new HashMap<String, String>(){
                {
                    this.put("java.awt.headless", "true");
                    this.put("tests.gradle", "true");
                    this.put("tests.artifact", project.getName());
                    this.put("tests.task", test.getPath());
                    this.put("tests.security.manager", "true");
                    this.put("jna.nosys", "true");
                }
            };
            test.systemProperties((Map)sysprops);
            if (System.getProperty("ignore.tests.seed") != null) {
                nonInputProperties.systemProperty("tests.seed", BuildParams.getTestSeed());
            } else {
                test.systemProperty("tests.seed", (Object)BuildParams.getTestSeed());
            }
            File gradleHome = project.getGradle().getGradleUserHomeDir();
            String gradleVersion = project.getGradle().getGradleVersion();
            nonInputProperties.systemProperty("gradle.dist.lib", new File(project.getGradle().getGradleHomeDir(), "lib"));
            nonInputProperties.systemProperty("gradle.worker.jar", gradleHome + "/caches/" + gradleVersion + "/workerMain/gradle-worker.jar");
            nonInputProperties.systemProperty("gradle.user.home", gradleHome);
            nonInputProperties.systemProperty("java.io.tmpdir", test.getWorkingDir().toPath().resolve("temp"));
            test.systemProperty("tests.logger.level", (Object)"WARN");
            System.getProperties().entrySet().forEach(entry -> {
                if (entry.getKey().toString().startsWith("tests.") || entry.getKey().toString().startsWith("opensearch.")) {
                    test.systemProperty(entry.getKey().toString(), entry.getValue());
                }
            });
            test.systemProperty("opensearch.scripting.update.ctx_in_params", (Object)"false");
            test.systemProperty("opensearch.search.rewrite_sort", (Object)"true");
            test.systemProperty("opensearch.transport.cname_in_publish_address", (Object)"true");
            test.systemProperty("io.netty.noUnsafe", (Object)"true");
            test.systemProperty("io.netty.noKeySetOptimization", (Object)"true");
            test.systemProperty("io.netty.recycler.maxCapacityPerThread", (Object)"0");
            test.testLogging(logging -> {
                logging.setShowExceptions(true);
                logging.setShowCauses(true);
                logging.setExceptionFormat((Object)"full");
                logging.setShowStandardStreams(Util.getBooleanProperty("tests.output", false));
            });
            if (OS.current().equals((Object)OS.WINDOWS) && System.getProperty("tests.timeoutSuite") == null) {
                test.systemProperty("tests.timeoutSuite", (Object)"1800000!");
            }
            project.getPluginManager().withPlugin("com.github.johnrengelman.shadow", p -> {
                FileCollection mainRuntime = ((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getRuntimeClasspath();
                Configuration shadowConfig = project.getConfigurations().getByName("shadow");
                ConfigurableFileCollection shadowJar = project.files(new Object[]{project.getTasks().named("shadowJar")});
                test.setClasspath(JvmTestSuiteHelper.getDefaultTestSuite(project).map(suite -> suite.getSources().getRuntimeClasspath()).orElseGet(() -> test.getClasspath()).minus(mainRuntime).plus((FileCollection)shadowConfig).plus((FileCollection)shadowJar));
            });
        });
    }
}

