/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.testclusters;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.opensearch.gradle.FileSupplier;
import org.opensearch.gradle.PropertyNormalization;
import org.opensearch.gradle.testclusters.ExtensionsProperties;
import org.opensearch.gradle.testclusters.TestClustersException;
import org.opensearch.gradle.testclusters.TestDistribution;
import org.slf4j.Logger;

public interface TestClusterConfiguration {
    public void setVersion(String var1);

    public void setVersions(List<String> var1);

    public void setTestDistribution(TestDistribution var1);

    public void extension(ExtensionsProperties var1);

    public void plugin(Provider<RegularFile> var1);

    public void plugin(String var1);

    public void upgradePlugin(List<Provider<RegularFile>> var1);

    public void module(Provider<RegularFile> var1);

    public void module(String var1);

    public void keystore(String var1, String var2);

    public void keystore(String var1, Supplier<CharSequence> var2);

    public void keystore(String var1, File var2);

    public void keystore(String var1, File var2, PropertyNormalization var3);

    public void keystore(String var1, FileSupplier var2);

    public void keystorePassword(String var1);

    public void cliSetup(String var1, CharSequence ... var2);

    public void setting(String var1, String var2);

    public void setting(String var1, String var2, PropertyNormalization var3);

    public void setting(String var1, Supplier<CharSequence> var2);

    public void setting(String var1, Supplier<CharSequence> var2, PropertyNormalization var3);

    public void systemProperty(String var1, String var2);

    public void systemProperty(String var1, Supplier<CharSequence> var2);

    public void systemProperty(String var1, Supplier<CharSequence> var2, PropertyNormalization var3);

    public void environment(String var1, String var2);

    public void environment(String var1, Supplier<CharSequence> var2);

    public void environment(String var1, Supplier<CharSequence> var2, PropertyNormalization var3);

    public void jvmArgs(String ... var1);

    public boolean isPreserveDataDir();

    public void setPreserveDataDir(boolean var1);

    public void freeze();

    public void start();

    public void restart();

    public void extraConfigFile(String var1, File var2);

    public void extraConfigFile(String var1, File var2, PropertyNormalization var3);

    public void extraJarFile(File var1);

    public void user(Map<String, String> var1);

    public String getHttpSocketURI();

    public String getTransportPortURI();

    public List<String> getAllHttpSocketURI();

    public List<String> getAllTransportPortURI();

    public void stop(boolean var1);

    public void setNameCustomization(Function<String, String> var1);

    default public void waitForConditions(LinkedHashMap<String, Predicate<TestClusterConfiguration>> waitConditions, long startedAtMillis, long nodeUpTimeout, TimeUnit nodeUpTimeoutUnit, TestClusterConfiguration context) {
        org.gradle.api.logging.Logger logger = Logging.getLogger(TestClusterConfiguration.class);
        waitConditions.forEach((arg_0, arg_1) -> this.lambda$waitForConditions$0(startedAtMillis, nodeUpTimeout, nodeUpTimeoutUnit, context, (Logger)logger, arg_0, arg_1));
    }

    default public String safeName(String name) {
        return name.replaceAll("^[^a-zA-Z0-9]+", "").replaceAll("[^a-zA-Z0-9\\.]+", "-");
    }

    public boolean isProcessAlive();

    private /* synthetic */ void lambda$waitForConditions$0(long startedAtMillis, long nodeUpTimeout, TimeUnit nodeUpTimeoutUnit, TestClusterConfiguration context, Logger logger, String description, Predicate predicate) {
        long thisConditionStartedAt = System.currentTimeMillis();
        boolean conditionMet = false;
        Exception lastException = null;
        while (System.currentTimeMillis() - startedAtMillis < TimeUnit.MILLISECONDS.convert(nodeUpTimeout, nodeUpTimeoutUnit)) {
            if (!context.isProcessAlive()) {
                throw new TestClustersException("process was found dead while waiting for " + description + ", " + this);
            }
            try {
                if (!predicate.test(context)) continue;
                conditionMet = true;
                break;
            }
            catch (TestClustersException e) {
                throw e;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (!conditionMet) {
            String message = String.format("`%s` failed to wait for %s after %d %s", new Object[]{context, description, nodeUpTimeout, nodeUpTimeoutUnit});
            if (lastException == null) {
                throw new TestClustersException(message);
            }
            Object extraCause = "";
            for (Throwable cause = lastException; cause != null; cause = cause.getCause()) {
                if (cause.getMessage() == null || cause.getMessage().isEmpty()) continue;
                extraCause = (String)extraCause + "\n  " + cause.getMessage();
            }
            throw new TestClustersException(message + (String)extraCause, lastException);
        }
        logger.info("{}: {} took {} seconds", new Object[]{this, description, (double)(System.currentTimeMillis() - thisConditionStartedAt) / 1000.0});
    }
}

