/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.test.rest;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.opensearch.gradle.VersionProperties;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.util.GradleUtils;

public class CopyRestTestsTask
extends DefaultTask {
    private static final String REST_TEST_PREFIX = "rest-api-spec/test";
    final ListProperty<String> includeCore = this.getProject().getObjects().listProperty(String.class);
    String sourceSetName;
    Configuration coreConfig;
    Configuration additionalConfig;
    private final PatternFilterable corePatternSet = (PatternFilterable)this.getPatternSetFactory().create();

    @Inject
    protected Factory<PatternSet> getPatternSetFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileSystemOperations getFileSystemOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ArchiveOperations getArchiveOperations() {
        throw new UnsupportedOperationException();
    }

    @Input
    public ListProperty<String> getIncludeCore() {
        return this.includeCore;
    }

    @Input
    String getSourceSetName() {
        return this.sourceSetName;
    }

    @IgnoreEmptyDirectories
    @SkipWhenEmpty
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getInputDir() {
        FileTree coreFileTree = null;
        if (!((List)this.includeCore.get()).isEmpty()) {
            if (BuildParams.isInternal().booleanValue()) {
                this.corePatternSet.setIncludes((Iterable)((List)this.includeCore.get()).stream().map(prefix -> prefix + "*/**").collect(Collectors.toList()));
                coreFileTree = this.coreConfig.getAsFileTree().matching(this.corePatternSet);
            } else {
                coreFileTree = this.coreConfig.getAsFileTree();
            }
        }
        ConfigurableFileCollection fileCollection = this.additionalConfig == null ? this.getProject().files(new Object[]{coreFileTree}) : this.getProject().files(new Object[]{coreFileTree, this.additionalConfig.getAsFileTree()});
        return !((List)this.includeCore.get()).isEmpty() || this.additionalConfig != null ? fileCollection.getAsFileTree() : null;
    }

    @OutputDirectory
    public File getOutputDir() {
        return new File(this.getSourceSet().orElseThrow(() -> new IllegalArgumentException("could not find source set [" + this.sourceSetName + "]")).getOutput().getResourcesDir(), REST_TEST_PREFIX);
    }

    @TaskAction
    void copy() {
        String projectPath = GradleUtils.getProjectPathFromTask(this.getPath());
        if (!((List)this.includeCore.get()).isEmpty()) {
            if (BuildParams.isInternal().booleanValue()) {
                this.getLogger().debug("Rest tests for project [{}] will be copied to the test resources.", (Object)projectPath);
                this.getFileSystemOperations().copy(c -> {
                    c.from(new Object[]{this.coreConfig.getAsFileTree()});
                    c.into((Object)this.getOutputDir());
                    c.include((Iterable)this.corePatternSet.getIncludes());
                });
            } else {
                this.getLogger().debug("Rest tests for project [{}] will be copied to the test resources from the published jar (version: [{}]).", (Object)projectPath, (Object)VersionProperties.getOpenSearch());
                this.getFileSystemOperations().copy(c -> {
                    c.from(new Object[]{this.getArchiveOperations().zipTree((Object)this.coreConfig.getSingleFile())});
                    c.into((Object)Objects.requireNonNull(this.getSourceSet().get().getOutput().getResourcesDir()));
                    c.include((Iterable)((List)this.includeCore.get()).stream().map(prefix -> "rest-api-spec/test/" + prefix + "*/**").collect(Collectors.toList()));
                });
            }
        }
        if (this.additionalConfig != null) {
            this.getFileSystemOperations().copy(c -> {
                c.from(new Object[]{this.additionalConfig.getAsFileTree()});
                c.into((Object)this.getOutputDir());
            });
        }
    }

    private Optional<SourceSet> getSourceSet() {
        Project project = this.getProject();
        return project.getConvention().findPlugin(JavaPluginConvention.class) == null ? Optional.empty() : Optional.ofNullable((SourceSet)GradleUtils.getJavaSourceSets(project).findByName(this.getSourceSetName()));
    }
}

