/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

public class ValidateJsonNoKeywordsTask
extends DefaultTask {
    private final ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    private File jsonKeywords;
    private File report;
    private FileCollection inputFiles;

    @Incremental
    @InputFiles
    public FileCollection getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFiles(FileCollection inputFiles) {
        this.inputFiles = inputFiles;
    }

    @InputFile
    public File getJsonKeywords() {
        return this.jsonKeywords;
    }

    public void setJsonKeywords(File jsonKeywords) {
        this.jsonKeywords = jsonKeywords;
    }

    public void setReport(File report) {
        this.report = report;
    }

    @OutputFile
    public File getReport() {
        return this.report;
    }

    @TaskAction
    public void validate(InputChanges inputChanges) {
        LinkedHashMap<File, Set> errors = new LinkedHashMap<File, Set>();
        this.getLogger().debug("Loading keywords from {}", (Object)this.jsonKeywords.getName());
        Map<String, Set<String>> languagesByKeyword = this.loadKeywords();
        StreamSupport.stream(inputChanges.getFileChanges(this.getInputFiles()).spliterator(), false).filter(f -> f.getChangeType() != ChangeType.REMOVED).forEach(fileChange -> {
            File file = fileChange.getFile();
            if (file.isDirectory()) {
                return;
            }
            this.getLogger().debug("Checking {}", (Object)file.getName());
            try {
                JsonNode jsonNode = this.mapper.readTree(file);
                if (!jsonNode.isObject()) {
                    errors.put(file, new HashSet<String>(Arrays.asList("Expected an object, but found: " + jsonNode.getNodeType())));
                    return;
                }
                ObjectNode rootNode = (ObjectNode)jsonNode;
                if (rootNode.size() != 1) {
                    errors.put(file, new HashSet<String>(Arrays.asList("Expected an object with exactly 1 key, but found " + rootNode.size() + " keys")));
                    return;
                }
                String apiName = (String)rootNode.fieldNames().next();
                for (String component : apiName.split("\\.")) {
                    if (!languagesByKeyword.containsKey(component)) continue;
                    Set errorsForFile = errors.computeIfAbsent(file, _file -> new HashSet());
                    errorsForFile.add(component + " is a reserved keyword in these languages: " + languagesByKeyword.get(component));
                }
            }
            catch (IOException e) {
                errors.put(file, new HashSet<String>(Arrays.asList("Failed to load file: " + e.getMessage())));
            }
        });
        if (errors.isEmpty()) {
            return;
        }
        try (PrintWriter pw = new PrintWriter(this.getReport());){
            pw.println("---------- Validation Report -----------");
            pw.println("Some API names were found that, when client code is generated for these APIS,");
            pw.println("could conflict with the reserved words in some programming languages. It may");
            pw.println("still be possible to use these API names, but you will need to verify whether");
            pw.println("the API name (and its components) can be used as method names, and update the");
            pw.println("list of keywords below. The safest action is to rename the API to avoid conflicts.");
            pw.println();
            pw.printf("Keywords source: %s%n", this.getJsonKeywords());
            pw.println();
            pw.println("---------- Validation Errors -----------");
            pw.println();
            errors.forEach((file, errorsForFile) -> {
                pw.printf("File: %s%n", file);
                errorsForFile.forEach(err -> pw.printf("\t%s%n", err));
                pw.println();
            });
        }
        catch (FileNotFoundException e) {
            throw new GradleException("Failed to write keywords report", (Throwable)e);
        }
        String message = String.format(Locale.ROOT, "Error validating JSON. See the report at: %s%s%s", this.getReport().toURI().toASCIIString(), System.lineSeparator(), String.format("JSON validation failed: %d files contained %d violations", errors.keySet().size(), errors.values().size()));
        throw new GradleException(message);
    }

    private Map<String, Set<String>> loadKeywords() {
        HashMap<String, Set<String>> languagesByKeyword = new HashMap<String, Set<String>>();
        try {
            ObjectNode keywordsNode = (ObjectNode)this.mapper.readTree(this.jsonKeywords);
            keywordsNode.fieldNames().forEachRemaining(eachLanguage -> keywordsNode.get(eachLanguage).elements().forEachRemaining(e -> {
                String eachKeyword = e.textValue();
                Set languages = languagesByKeyword.computeIfAbsent(eachKeyword, _keyword -> new HashSet());
                languages.add(eachLanguage);
            }));
        }
        catch (IOException e) {
            throw new GradleException("Failed to load keywords JSON from " + this.jsonKeywords.getName() + " - " + e.getMessage(), (Throwable)e);
        }
        return languagesByKeyword;
    }
}

