/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.os.OperatingSystem;
import org.opensearch.gradle.EmptyDirTask;
import org.opensearch.gradle.internal.DistributionArchive;
import org.opensearch.gradle.tar.SymbolicLinkPreservingTar;
import org.opensearch.gradle.util.Util;

public class InternalDistributionArchiveSetupPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(InternalDistributionArchiveSetupPlugin.class);
    public static final String DEFAULT_CONFIGURATION_NAME = "default";
    public static final String EXTRACTED_CONFIGURATION_NAME = "extracted";
    private NamedDomainObjectContainer<DistributionArchive> container;

    public void apply(Project project) {
        project.getPlugins().apply(BasePlugin.class);
        this.registerAndConfigureDistributionArchivesExtension(project);
        this.registerEmptyDirectoryTasks(project);
        this.configureGeneralTaskDefaults(project);
        this.configureTarDefaults(project);
    }

    static Action<Task> configure(String name) {
        return task -> task.onlyIf(s -> {
            if (OperatingSystem.current().isWindows()) {
                boolean skip;
                String nameLowerCased = name.toLowerCase();
                boolean bl = skip = !nameLowerCased.contains("windows") && !nameLowerCased.contains("integtest");
                if (skip) {
                    LOGGER.info("Skipping task " + name + " since it does not match current OS platform");
                }
                return !skip;
            }
            return true;
        });
    }

    private void registerAndConfigureDistributionArchivesExtension(Project project) {
        this.container = project.container(DistributionArchive.class, name -> {
            String subProjectDir = InternalDistributionArchiveSetupPlugin.archiveToSubprojectName(name);
            String copyDistributionTaskName = "build" + Util.capitalize(name.substring(0, name.length() - 3));
            TaskContainer tasks = project.getTasks();
            TaskProvider explodedDist = tasks.register(copyDistributionTaskName, Sync.class, sync -> sync.into((Object)(subProjectDir + "/build/install/")));
            explodedDist.configure(InternalDistributionArchiveSetupPlugin.configure(name));
            String archiveTaskName = "build" + Util.capitalize(name);
            TaskProvider archiveTask = name.endsWith("Tar") ? tasks.register(archiveTaskName, SymbolicLinkPreservingTar.class) : tasks.register(archiveTaskName, Zip.class);
            archiveTask.configure(InternalDistributionArchiveSetupPlugin.configure(name));
            return new DistributionArchive((TaskProvider<? extends AbstractArchiveTask>)archiveTask, (TaskProvider<Sync>)explodedDist, name);
        });
        this.container.whenObjectAdded(distributionArchive -> {
            String subProjectName = InternalDistributionArchiveSetupPlugin.archiveToSubprojectName(distributionArchive.getName());
            project.project(subProjectName, sub -> {
                sub.getPlugins().apply(BasePlugin.class);
                sub.getArtifacts().add(DEFAULT_CONFIGURATION_NAME, distributionArchive.getArchiveTask());
                Configuration extractedConfiguration = (Configuration)sub.getConfigurations().create(EXTRACTED_CONFIGURATION_NAME);
                extractedConfiguration.setCanBeResolved(false);
                extractedConfiguration.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory");
                sub.getArtifacts().add(EXTRACTED_CONFIGURATION_NAME, distributionArchive.getExpandedDistTask());
            });
        });
        project.getExtensions().add("distribution_archives", this.container);
    }

    private void configureGeneralTaskDefaults(Project project) {
        project.getTasks().withType(AbstractCopyTask.class).configureEach(t -> {
            t.dependsOn(new Object[]{project.getTasks().withType(EmptyDirTask.class)});
            t.setIncludeEmptyDirs(true);
            t.setDirMode(Integer.valueOf(493));
            t.setFileMode(Integer.valueOf(420));
        });
        project.getTasks().withType(AbstractArchiveTask.class).configureEach(t -> {
            String subdir = InternalDistributionArchiveSetupPlugin.archiveTaskToSubprojectName(t.getName());
            t.getDestinationDirectory().set(project.file((Object)(subdir + "/build/distributions")));
            t.getArchiveBaseName().set((Object)"opensearch-min");
        });
    }

    private void configureTarDefaults(Project project) {
        project.getTasks().withType(SymbolicLinkPreservingTar.class).configureEach(t -> {
            t.getArchiveExtension().set((Object)"tar.gz");
            t.setCompression(Compression.GZIP);
        });
    }

    private void registerEmptyDirectoryTasks(Project project) {
        File logsDir = new File(project.getBuildDir(), "logs-hack/logs");
        project.getExtensions().getExtraProperties().set("logsDir", (Object)new File(project.getBuildDir(), "logs-hack/logs"));
        project.getTasks().register("createLogsDir", EmptyDirTask.class, t -> {
            t.setDir(logsDir);
            t.setDirMode(493);
        });
        File pluginsDir = new File(project.getBuildDir(), "plugins-hack/plugins");
        project.getExtensions().add("pluginsDir", (Object)pluginsDir);
        project.getTasks().register("createPluginsDir", EmptyDirTask.class, t -> {
            t.setDir(pluginsDir);
            t.setDirMode(493);
        });
        File jvmOptionsDir = new File(project.getBuildDir(), "jvm-options-hack/jvm.options.d");
        project.getExtensions().add("jvmOptionsDir", (Object)jvmOptionsDir);
        project.getTasks().register("createJvmOptionsDir", EmptyDirTask.class, t -> {
            t.setDir(jvmOptionsDir);
            t.setDirMode(488);
        });
    }

    private static String archiveTaskToSubprojectName(String taskName) {
        return InternalDistributionArchiveSetupPlugin.archiveToSubprojectName(taskName).substring("build".length() + 1);
    }

    private static String archiveToSubprojectName(String taskName) {
        return taskName.replaceAll("[A-Z]", "-$0").toLowerCase();
    }
}

