/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Named;
import org.gradle.api.tasks.Input;
import org.opensearch.gradle.AbstractLazyPropertyCollection;
import org.opensearch.gradle.PropertyNormalization;

public class LazyPropertyMap<K, V>
extends AbstractLazyPropertyCollection
implements Map<K, V> {
    private final Map<K, PropertyMapEntry<K, V>> delegate = new LinkedHashMap<K, PropertyMapEntry<K, V>>();
    private final BiFunction<K, V, ?> normalizationMapper;

    public LazyPropertyMap(String name) {
        this(name, null);
    }

    public LazyPropertyMap(String name, Object owner) {
        this(name, owner, null);
    }

    public LazyPropertyMap(String name, Object owner, BiFunction<K, V, ?> normalizationMapper) {
        super(name, owner);
        this.normalizationMapper = normalizationMapper;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.values().stream().map(PropertyMapEntry::getValue).anyMatch(v -> v.equals(value));
    }

    @Override
    public V get(Object key) {
        PropertyMapEntry<K, V> entry = this.delegate.get(key);
        if (entry != null) {
            V value = entry.getValue();
            this.assertNotNull(value, "value for key '" + key + "'");
            return value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, PropertyNormalization.DEFAULT);
    }

    public V put(K key, V value, PropertyNormalization normalization) {
        this.assertNotNull(value, "value for key '" + key + "'");
        return (V)this.put(key, () -> value, normalization);
    }

    @Override
    public V put(K key, Supplier<V> supplier) {
        return this.put(key, supplier, PropertyNormalization.DEFAULT);
    }

    public V put(K key, Supplier<V> supplier, PropertyNormalization normalization) {
        this.assertNotNull(supplier, "supplier for key '" + key + "'");
        PropertyMapEntry<K, V> previous = this.delegate.put(key, new PropertyMapEntry<K, V>(key, supplier, normalization));
        return previous == null ? null : (V)previous.getValue();
    }

    @Override
    public V remove(Object key) {
        PropertyMapEntry<K, V> previous = this.delegate.remove(key);
        return previous == null ? null : (V)previous.getValue();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support putAll()");
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values().stream().peek(this::validate).map(PropertyMapEntry::getValue).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet().stream().peek(this::validate).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((PropertyMapEntry)entry.getValue()).getValue())).entrySet();
    }

    @Override
    public List<? extends Object> getNormalizedCollection() {
        return this.delegate.values().stream().peek(this::validate).filter(entry -> entry.getNormalization() != PropertyNormalization.IGNORE_VALUE).map(entry -> this.normalizationMapper == null ? entry : this.normalizationMapper.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    private void validate(Map.Entry<K, PropertyMapEntry<K, V>> entry) {
        this.validate(entry.getValue());
    }

    private void validate(PropertyMapEntry<K, V> supplier) {
        this.assertNotNull(supplier, "key '" + supplier.getKey() + "' supplier value");
    }

    private static class PropertyMapEntry<K, V>
    implements Named {
        private final K key;
        private final Supplier<V> value;
        private final PropertyNormalization normalization;

        PropertyMapEntry(K key, Supplier<V> value, PropertyNormalization normalization) {
            this.key = key;
            this.value = value;
            this.normalization = normalization;
        }

        @Input
        public PropertyNormalization getNormalization() {
            return this.normalization;
        }

        @Input
        public String getName() {
            return this.getKey().toString();
        }

        @Input
        public K getKey() {
            return this.key;
        }

        @Input
        public V getValue() {
            return this.value.get();
        }
    }
}

