/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.testfixtures;

import com.avast.gradle.dockercompose.ComposeExtension;
import com.avast.gradle.dockercompose.DockerComposePlugin;
import com.avast.gradle.dockercompose.ServiceInfo;
import com.avast.gradle.dockercompose.tasks.ComposeDown;
import com.avast.gradle.dockercompose.tasks.ComposePull;
import com.avast.gradle.dockercompose.tasks.ComposeUp;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.opensearch.gradle.SystemPropertyCommandLineArgumentProvider;
import org.opensearch.gradle.docker.DockerSupportPlugin;
import org.opensearch.gradle.docker.DockerSupportService;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.precommit.TestingConventionsTasks;
import org.opensearch.gradle.testfixtures.DockerComposeThrottle;
import org.opensearch.gradle.testfixtures.TestFixtureExtension;
import org.opensearch.gradle.util.GradleUtils;

public class TestFixturesPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(TestFixturesPlugin.class);
    private static final String DOCKER_COMPOSE_THROTTLE = "dockerComposeThrottle";
    static final String DOCKER_COMPOSE_YML = "docker-compose.yml";
    private static String[] DOCKER_COMPOSE_BINARIES_UNIX = new String[]{"/usr/local/bin/docker-compose", "/usr/bin/docker-compose"};
    private static String[] DOCKER_COMPOSE_BINARIES_WINDOWS = new String[]{System.getenv("PROGRAMFILES") + "\\Docker\\Docker\\resources\\bin\\docker-compose.exe"};
    private static String[] DOCKER_COMPOSE_BINARIES = Os.isFamily((String)"windows") ? DOCKER_COMPOSE_BINARIES_WINDOWS : DOCKER_COMPOSE_BINARIES_UNIX;

    @Inject
    protected FileSystemOperations getFileSystemOperations() {
        throw new UnsupportedOperationException();
    }

    public void apply(final Project project) {
        project.getRootProject().getPluginManager().apply(DockerSupportPlugin.class);
        final TaskContainer tasks = project.getTasks();
        TestFixtureExtension extension = (TestFixtureExtension)project.getExtensions().create("testFixtures", TestFixtureExtension.class, new Object[]{project});
        Provider dockerComposeThrottle = project.getGradle().getSharedServices().registerIfAbsent(DOCKER_COMPOSE_THROTTLE, DockerComposeThrottle.class, spec -> spec.getMaxParallelUsages().set((Object)1));
        Provider dockerSupport = GradleUtils.getBuildService(project.getGradle().getSharedServices(), "dockerSupportService");
        ExtraPropertiesExtension ext = (ExtraPropertiesExtension)project.getExtensions().getByType(ExtraPropertiesExtension.class);
        final File testfixturesDir = project.file((Object)"testfixtures_shared");
        ext.set("testFixturesDir", (Object)testfixturesDir);
        if (project.file((Object)DOCKER_COMPOSE_YML).exists()) {
            project.getPluginManager().apply(BasePlugin.class);
            project.getPluginManager().apply(DockerComposePlugin.class);
            final TaskProvider preProcessFixture = project.getTasks().register("preProcessFixture", (Action)new Action<Task>(){

                public void execute(Task t) {
                    t.getOutputs().dir((Object)testfixturesDir);
                    t.doFirst((Action)new Action<Task>(){

                        public void execute(Task t2) {
                            try {
                                Files.createDirectories(testfixturesDir.toPath(), new FileAttribute[0]);
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    });
                }
            });
            final TaskProvider buildFixture = project.getTasks().register("buildFixture", (Action)new Action<Task>(){

                public void execute(Task t) {
                    t.dependsOn(new Object[]{preProcessFixture, tasks.named("composeUp")});
                }
            });
            TaskProvider postProcessFixture = project.getTasks().register("postProcessFixture", (Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{buildFixture});
                    TestFixturesPlugin.this.configureServiceInfoForTask(task, project, false, (name, port) -> ((ExtraPropertiesExtension)task.getExtensions().getByType(ExtraPropertiesExtension.class)).set(name, port));
                }
            });
            this.maybeSkipTask(dockerSupport, (TaskProvider<Task>)preProcessFixture);
            this.maybeSkipTask(dockerSupport, (TaskProvider<Task>)postProcessFixture);
            this.maybeSkipTask(dockerSupport, (TaskProvider<Task>)buildFixture);
            ComposeExtension composeExtension = (ComposeExtension)project.getExtensions().getByType(ComposeExtension.class);
            composeExtension.getUseComposeFiles().set(Collections.singletonList(DOCKER_COMPOSE_YML));
            composeExtension.getRemoveContainers().set((Object)true);
            Integer timeout = ext.has("dockerComposeHttpTimeout") ? (Integer)ext.get("dockerComposeHttpTimeout") : 120;
            composeExtension.getEnvironment().put((Object)"COMPOSE_HTTP_TIMEOUT", (Object)timeout);
            Optional<String> dockerCompose = Arrays.asList(DOCKER_COMPOSE_BINARIES).stream().filter(path -> project.file(path).exists()).findFirst();
            composeExtension.getExecutable().set((Object)(dockerCompose.isPresent() ? dockerCompose.get() : "/usr/bin/docker"));
            tasks.named("composeUp").configure(t -> {
                if (BuildParams.isCi().booleanValue()) {
                    t.usesService(dockerComposeThrottle);
                }
                t.mustRunAfter(new Object[]{preProcessFixture});
            });
            tasks.named("composePull").configure(t -> t.mustRunAfter(new Object[]{preProcessFixture}));
            tasks.named("composeDown").configure(t -> t.doLast(t2 -> this.getFileSystemOperations().delete(d -> d.delete(new Object[]{testfixturesDir}))));
        } else {
            project.afterEvaluate(spec -> {
                if (extension.fixtures.isEmpty()) {
                    throw new IllegalStateException("No docker-compose.yml found for " + project.getPath() + " nor does it use other fixtures.");
                }
            });
        }
        extension.fixtures.matching(fixtureProject -> !fixtureProject.equals(project)).all(fixtureProject -> project.evaluationDependsOn(fixtureProject.getPath()));
        this.maybeSkipTasks(tasks, dockerSupport, Test.class);
        this.maybeSkipTasks(tasks, dockerSupport, this.getTaskClass("org.opensearch.gradle.test.RestIntegTestTask"));
        this.maybeSkipTasks(tasks, dockerSupport, TestingConventionsTasks.class);
        this.maybeSkipTasks(tasks, dockerSupport, this.getTaskClass("org.opensearch.gradle.test.AntFixture"));
        this.maybeSkipTasks(tasks, dockerSupport, ComposeUp.class);
        this.maybeSkipTasks(tasks, dockerSupport, ComposePull.class);
        this.maybeSkipTasks(tasks, dockerSupport, ComposeDown.class);
        tasks.withType(Test.class).configureEach(task -> extension.fixtures.all(fixtureProject -> {
            task.dependsOn(new Object[]{fixtureProject.getTasks().named("postProcessFixture")});
            task.finalizedBy(new Object[]{fixtureProject.getTasks().named("composeDown")});
            this.configureServiceInfoForTask((Task)task, (Project)fixtureProject, true, (name, host) -> ((SystemPropertyCommandLineArgumentProvider)task.getExtensions().getByType(SystemPropertyCommandLineArgumentProvider.class)).systemProperty((String)name, host));
        }));
    }

    private void maybeSkipTasks(TaskContainer tasks, Provider<DockerSupportService> dockerSupport, Class<? extends DefaultTask> taskClass) {
        tasks.withType(taskClass).configureEach(t -> this.maybeSkipTask(dockerSupport, (Task)t));
    }

    private void maybeSkipTask(Provider<DockerSupportService> dockerSupport, TaskProvider<Task> task) {
        task.configure(t -> this.maybeSkipTask(dockerSupport, (Task)t));
    }

    private void maybeSkipTask(Provider<DockerSupportService> dockerSupport, Task task) {
        task.onlyIf(spec -> {
            boolean isComposeAvailable = ((DockerSupportService)dockerSupport.get()).getDockerAvailability().isComposeAvailable;
            if (!isComposeAvailable) {
                LOGGER.info("Task {} requires docker-compose but it is unavailable. Task will be skipped.", (Object)task.getPath());
            }
            return isComposeAvailable;
        });
    }

    private void configureServiceInfoForTask(Task task, final Project fixtureProject, final boolean enableFilter, final BiConsumer<String, Integer> consumer) {
        task.doFirst((Action)new Action<Task>(){

            public void execute(Task theTask) {
                TestFixtureExtension extension = (TestFixtureExtension)theTask.getProject().getExtensions().getByType(TestFixtureExtension.class);
                ((ComposeExtension)fixtureProject.getExtensions().getByType(ComposeExtension.class)).getServicesInfos().entrySet().stream().filter(entry -> !enableFilter || extension.isServiceRequired((String)entry.getKey(), fixtureProject.getPath())).forEach(entry -> {
                    String service = (String)entry.getKey();
                    ServiceInfo infos = (ServiceInfo)entry.getValue();
                    infos.getTcpPorts().forEach((container, host) -> {
                        String name = "test.fixtures." + service + ".tcp." + container;
                        theTask.getLogger().info("port mapping property: {}={}", (Object)name, host);
                        consumer.accept(name, host);
                    });
                    infos.getUdpPorts().forEach((container, host) -> {
                        String name = "test.fixtures." + service + ".udp." + container;
                        theTask.getLogger().info("port mapping property: {}={}", (Object)name, host);
                        consumer.accept(name, host);
                    });
                });
            }
        });
    }

    private Class<? extends DefaultTask> getTaskClass(String type) {
        Class<?> aClass;
        try {
            aClass = Class.forName(type);
            if (!DefaultTask.class.isAssignableFrom(aClass)) {
                throw new IllegalArgumentException("Not a task type: " + type);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No such task: " + type);
        }
        return aClass;
    }
}

