/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.testclusters;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.process.ExecSpec;
import org.opensearch.gradle.Architecture;
import org.opensearch.gradle.DistributionDownloadPlugin;
import org.opensearch.gradle.FileSupplier;
import org.opensearch.gradle.Jdk;
import org.opensearch.gradle.LazyPropertyList;
import org.opensearch.gradle.LazyPropertyMap;
import org.opensearch.gradle.LoggedExec;
import org.opensearch.gradle.OS;
import org.opensearch.gradle.OpenSearchDistribution;
import org.opensearch.gradle.PropertyNormalization;
import org.opensearch.gradle.ReaperService;
import org.opensearch.gradle.Version;
import org.opensearch.gradle.VersionProperties;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.testclusters.TestClusterConfiguration;
import org.opensearch.gradle.testclusters.TestClustersException;
import org.opensearch.gradle.testclusters.TestDistribution;

public class OpenSearchNode
implements TestClusterConfiguration {
    private static final Logger LOGGER = Logging.getLogger(OpenSearchNode.class);
    private static final int OPENSEARCH_DESTROY_TIMEOUT = 20;
    private static final TimeUnit OPENSEARCH_DESTROY_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final int NODE_UP_TIMEOUT = 2;
    private static final TimeUnit NODE_UP_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private static final int ADDITIONAL_CONFIG_TIMEOUT = 15;
    private static final TimeUnit ADDITIONAL_CONFIG_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final List<String> OVERRIDABLE_SETTINGS = Arrays.asList("path.repo", "discovery.seed_providers", "discovery.seed_hosts");
    private static final int TAIL_LOG_MESSAGES_COUNT = 40;
    private static final List<String> MESSAGES_WE_DONT_CARE_ABOUT = Arrays.asList("Option UseConcMarkSweepGC was deprecated", "is a pre-release version of OpenSearch", "max virtual memory areas vm.max_map_count");
    private static final String HOSTNAME_OVERRIDE = "LinuxDarwinHostname";
    private static final String COMPUTERNAME_OVERRIDE = "WindowsComputername";
    private final String path;
    private final String name;
    private final Project project;
    private final ReaperService reaper;
    private final Jdk bwcJdk;
    private final FileSystemOperations fileSystemOperations;
    private final ArchiveOperations archiveOperations;
    private final AtomicBoolean configurationFrozen = new AtomicBoolean(false);
    private final Path workingDir;
    private final LinkedHashMap<String, Predicate<TestClusterConfiguration>> waitConditions = new LinkedHashMap();
    private final Map<String, Configuration> pluginAndModuleConfigurations = new HashMap<String, Configuration>();
    private final List<Provider<File>> plugins = new ArrayList<Provider<File>>();
    private final List<Provider<File>> modules = new ArrayList<Provider<File>>();
    final LazyPropertyMap<String, CharSequence> settings = new LazyPropertyMap("Settings", this);
    private final LazyPropertyMap<String, CharSequence> keystoreSettings = new LazyPropertyMap("Keystore", this);
    private final LazyPropertyMap<String, File> keystoreFiles = new LazyPropertyMap<String, File>("Keystore files", this, FileEntry::new);
    private final LazyPropertyList<CliEntry> cliSetup = new LazyPropertyList("CLI setup commands", this);
    private final LazyPropertyMap<String, CharSequence> systemProperties = new LazyPropertyMap("System properties", this);
    private final LazyPropertyMap<String, CharSequence> environment = new LazyPropertyMap("Environment", this);
    private final LazyPropertyList<CharSequence> jvmArgs = new LazyPropertyList("JVM arguments", this);
    private final LazyPropertyMap<String, File> extraConfigFiles = new LazyPropertyMap<String, File>("Extra config files", this, FileEntry::new);
    private final LazyPropertyList<File> extraJarFiles = new LazyPropertyList("Extra jar files", this);
    private final List<Map<String, String>> credentials = new ArrayList<Map<String, String>>();
    final LinkedHashMap<String, String> defaultConfig = new LinkedHashMap();
    private final Path confPathRepo;
    private final Path confPathLogs;
    private final Path transportPortFile;
    private final Path httpPortsFile;
    private final Path tmpDir;
    private int currentDistro = 0;
    private TestDistribution testDistribution;
    private List<OpenSearchDistribution> distributions = new ArrayList<OpenSearchDistribution>();
    private volatile Process opensearchProcess;
    private Function<String, String> nameCustomization = Function.identity();
    private boolean isWorkingDirConfigured = false;
    private String httpPort = "0";
    private String transportPort = "0";
    private Path confPathData;
    private String keystorePassword = "";
    private boolean preserveDataDir = false;
    private final Config opensearchConfig;
    private final Config legacyESConfig;
    private Config currentConfig;

    OpenSearchNode(String path, String name, Project project, ReaperService reaper, FileSystemOperations fileSystemOperations, ArchiveOperations archiveOperations, File workingDirBase, Jdk bwcJdk) {
        this.path = path;
        this.name = name;
        this.project = project;
        this.reaper = reaper;
        this.fileSystemOperations = fileSystemOperations;
        this.archiveOperations = archiveOperations;
        this.bwcJdk = bwcJdk;
        this.workingDir = workingDirBase.toPath().resolve(this.safeName(name)).toAbsolutePath();
        this.confPathRepo = this.workingDir.resolve("repo");
        this.confPathData = this.workingDir.resolve("data");
        this.confPathLogs = this.workingDir.resolve("logs");
        this.transportPortFile = this.confPathLogs.resolve("transport.ports");
        this.httpPortsFile = this.confPathLogs.resolve("http.ports");
        this.tmpDir = this.workingDir.resolve("tmp");
        this.waitConditions.put("ports files", this::checkPortsFilesExistWithDelay);
        this.setTestDistribution(TestDistribution.INTEG_TEST);
        this.setVersion(VersionProperties.getOpenSearch());
        this.opensearchConfig = Config.getOpenSearchConfig(this.workingDir);
        this.legacyESConfig = Config.getLegacyESConfig(this.workingDir);
        this.currentConfig = this.opensearchConfig;
    }

    private void applyConfig() {
        this.currentConfig = this.getVersion().onOrAfter("1.0.0") ? this.opensearchConfig : this.legacyESConfig;
    }

    @Input
    @Optional
    public String getName() {
        return this.nameCustomization.apply(this.name);
    }

    @Internal
    public Version getVersion() {
        return Version.fromString(this.distributions.get(this.currentDistro).getVersion());
    }

    @Override
    public void setVersion(String version) {
        Objects.requireNonNull(version, "null version passed when configuring test cluster `" + this + "`");
        this.checkFrozen();
        this.distributions.clear();
        this.doSetVersion(version);
        this.applyConfig();
    }

    @Override
    public void setVersions(List<String> versions) {
        Objects.requireNonNull(versions, "null version list passed when configuring test cluster `" + this + "`");
        this.distributions.clear();
        for (String version : versions) {
            this.doSetVersion(version);
        }
        this.applyConfig();
    }

    private void doSetVersion(String version) {
        String distroName = "testclusters" + this.path.replace(":", "-") + "-" + this.name + "-" + version + "-";
        NamedDomainObjectContainer<OpenSearchDistribution> container = DistributionDownloadPlugin.getContainer(this.project);
        if (container.findByName(distroName) == null) {
            container.create(distroName);
        }
        OpenSearchDistribution distro = (OpenSearchDistribution)container.getByName(distroName);
        distro.setVersion(version);
        distro.setArchitecture(Architecture.current());
        this.setDistributionType(distro, this.testDistribution);
        this.distributions.add(distro);
    }

    @Internal
    public TestDistribution getTestDistribution() {
        return this.testDistribution;
    }

    @Internal
    List<OpenSearchDistribution> getDistributions() {
        return this.distributions;
    }

    @Override
    public void setTestDistribution(TestDistribution testDistribution) {
        Objects.requireNonNull(testDistribution, "null distribution passed when configuring test cluster `" + this + "`");
        this.checkFrozen();
        this.testDistribution = testDistribution;
        for (OpenSearchDistribution distribution : this.distributions) {
            this.setDistributionType(distribution, testDistribution);
        }
    }

    private void setDistributionType(OpenSearchDistribution distribution, TestDistribution testDistribution) {
        if (testDistribution == TestDistribution.INTEG_TEST) {
            distribution.setType(OpenSearchDistribution.Type.INTEG_TEST_ZIP);
            distribution.setPlatform(null);
            distribution.setBundledJdk(null);
        } else {
            distribution.setType(OpenSearchDistribution.Type.ARCHIVE);
        }
    }

    @Internal
    Collection<Configuration> getPluginAndModuleConfigurations() {
        return this.pluginAndModuleConfigurations.values();
    }

    private Provider<RegularFile> maybeCreatePluginOrModuleDependency(final String path) {
        Configuration configuration = this.pluginAndModuleConfigurations.computeIfAbsent(path, key -> this.project.getConfigurations().detachedConfiguration(new Dependency[]{this.project.getDependencies().project((Map)new HashMap<String, String>(){
            {
                this.put("path", path);
                this.put("configuration", "zip");
            }
        })}));
        Provider fileProvider = configuration.getElements().map(s -> ((FileSystemLocation)s.stream().findFirst().orElseThrow(() -> new IllegalStateException("zip configuration of project " + path + " had no files"))).getAsFile());
        return this.project.getLayout().file(fileProvider);
    }

    @Override
    public void plugin(Provider<RegularFile> plugin) {
        this.checkFrozen();
        this.plugins.add((Provider<File>)plugin.map(RegularFile::getAsFile));
    }

    @Override
    public void upgradePlugin(List<Provider<RegularFile>> plugins) {
        this.plugins.clear();
        for (Provider<RegularFile> plugin : plugins) {
            this.plugins.add((Provider<File>)plugin.map(RegularFile::getAsFile));
        }
    }

    @Override
    public void plugin(String pluginProjectPath) {
        this.plugin(this.maybeCreatePluginOrModuleDependency(pluginProjectPath));
    }

    @Override
    public void module(Provider<RegularFile> module) {
        this.checkFrozen();
        this.modules.add((Provider<File>)module.map(RegularFile::getAsFile));
    }

    @Override
    public void module(String moduleProjectPath) {
        this.module(this.maybeCreatePluginOrModuleDependency(moduleProjectPath));
    }

    @Override
    public void keystore(String key, String value) {
        this.keystoreSettings.put(key, value);
    }

    @Override
    public void keystore(String key, Supplier<CharSequence> valueSupplier) {
        this.keystoreSettings.put(key, valueSupplier);
    }

    @Override
    public void keystore(String key, File value) {
        this.keystoreFiles.put(key, value);
    }

    @Override
    public void keystore(String key, File value, PropertyNormalization normalization) {
        this.keystoreFiles.put(key, value, normalization);
    }

    @Override
    public void keystore(String key, FileSupplier valueSupplier) {
        this.keystoreFiles.put(key, valueSupplier);
    }

    @Override
    public void keystorePassword(String password) {
        this.keystorePassword = password;
    }

    @Override
    public void cliSetup(String binTool, CharSequence ... args) {
        this.cliSetup.add(new CliEntry(binTool, args));
    }

    @Override
    public void setting(String key, String value) {
        this.settings.put(key, value);
    }

    @Override
    public void setting(String key, String value, PropertyNormalization normalization) {
        this.settings.put(key, value, normalization);
    }

    @Override
    public void setting(String key, Supplier<CharSequence> valueSupplier) {
        this.settings.put(key, valueSupplier);
    }

    @Override
    public void setting(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.settings.put(key, valueSupplier, normalization);
    }

    @Override
    public void systemProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    @Override
    public void systemProperty(String key, Supplier<CharSequence> valueSupplier) {
        this.systemProperties.put(key, valueSupplier);
    }

    @Override
    public void systemProperty(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.systemProperties.put(key, valueSupplier, normalization);
    }

    @Override
    public void environment(String key, String value) {
        this.environment.put(key, value);
    }

    @Override
    public void environment(String key, Supplier<CharSequence> valueSupplier) {
        this.environment.put(key, valueSupplier);
    }

    @Override
    public void environment(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.environment.put(key, valueSupplier, normalization);
    }

    @Override
    public void jvmArgs(String ... values) {
        this.jvmArgs.addAll((Collection<CharSequence>)Arrays.asList(values));
    }

    @Internal
    public Path getConfigDir() {
        return this.currentConfig.configFile.getParent();
    }

    @Override
    @Input
    public boolean isPreserveDataDir() {
        return this.preserveDataDir;
    }

    @Override
    public void setPreserveDataDir(boolean preserveDataDir) {
        this.preserveDataDir = preserveDataDir;
    }

    @Override
    public void freeze() {
        Objects.requireNonNull(this.testDistribution, "null testDistribution passed when configuring test cluster `" + this + "`");
        LOGGER.info("Locking configuration of `{}`", (Object)this);
        this.configurationFrozen.set(true);
    }

    public Stream<String> logLines() throws IOException {
        return Files.lines(this.currentConfig.stdoutFile, StandardCharsets.UTF_8);
    }

    @Override
    public synchronized void start() {
        LOGGER.info("Starting `{}`", (Object)this);
        if (!Files.exists(this.getExtractedDistributionDir(), new LinkOption[0])) {
            throw new TestClustersException("Can not start " + this + ", missing: " + this.getExtractedDistributionDir());
        }
        if (!Files.isDirectory(this.getExtractedDistributionDir(), new LinkOption[0])) {
            throw new TestClustersException("Can not start " + this + ", is not a directory: " + this.getExtractedDistributionDir());
        }
        try {
            if (!this.isWorkingDirConfigured) {
                this.logToProcessStdout("Configuring working directory: " + this.workingDir);
                if (Files.exists(this.workingDir, new LinkOption[0])) {
                    if (this.preserveDataDir) {
                        Files.list(this.workingDir).filter(path -> !path.equals(this.confPathData)).forEach(path -> this.fileSystemOperations.delete(d -> d.delete(new Object[]{path})));
                    } else {
                        this.fileSystemOperations.delete(d -> d.delete(new Object[]{this.workingDir}));
                    }
                }
                this.isWorkingDirConfigured = true;
            }
            this.setupNodeDistribution(this.getExtractedDistributionDir());
            this.createWorkingDir();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create working directory for " + this, e);
        }
        this.copyExtraJars();
        this.copyExtraConfigFiles();
        this.createConfiguration();
        ArrayList pluginsToInstall = new ArrayList();
        if (!this.plugins.isEmpty()) {
            pluginsToInstall.addAll(this.plugins.stream().map(Provider::get).map(p -> p.toURI().toString()).collect(Collectors.toList()));
        }
        if (!pluginsToInstall.isEmpty()) {
            if (this.getVersion().onOrAfter("7.6.0")) {
                this.logToProcessStdout("installing " + pluginsToInstall.size() + " plugins in a single transaction");
                CharSequence[] arguments = (String[])Stream.concat(Stream.of("install", "--batch"), pluginsToInstall.stream()).toArray(String[]::new);
                this.runOpenSearchBinScript(this.currentConfig.pluginTool, arguments);
                this.logToProcessStdout("installed plugins");
            } else {
                this.logToProcessStdout("installing " + pluginsToInstall.size() + " plugins sequentially");
                pluginsToInstall.forEach(plugin -> this.runOpenSearchBinScript(this.currentConfig.pluginTool, "install", "--batch", (CharSequence)plugin));
                this.logToProcessStdout("installed plugins");
            }
        }
        this.logToProcessStdout("Creating " + this.currentConfig.command + " keystore with password set to [" + this.keystorePassword + "]");
        if (this.keystorePassword.length() > 0) {
            this.runOpenSearchBinScriptWithInput(this.keystorePassword + "\n" + this.keystorePassword, this.currentConfig.keystoreTool, "create", "-p");
        } else {
            this.runOpenSearchBinScript(this.currentConfig.keystoreTool, "-v", "create");
        }
        if (!this.keystoreSettings.isEmpty() || !this.keystoreFiles.isEmpty()) {
            this.logToProcessStdout("Adding " + this.keystoreSettings.size() + " keystore settings and " + this.keystoreFiles.size() + " keystore files");
            this.keystoreSettings.forEach((key, value) -> this.runKeystoreCommandWithPassword(this.keystorePassword, value.toString(), "add", "-x", (CharSequence)key));
            for (Map.Entry entry : this.keystoreFiles.entrySet()) {
                File file = (File)entry.getValue();
                Objects.requireNonNull(file, "supplied keystoreFile was null when configuring " + this);
                if (!file.exists()) {
                    throw new TestClustersException("supplied keystore file " + file + " does not exist, require for " + this);
                }
                this.runKeystoreCommandWithPassword(this.keystorePassword, "", "add-file", (CharSequence)entry.getKey(), file.getAbsolutePath());
            }
        }
        this.installModules();
        if (!this.cliSetup.isEmpty()) {
            this.logToProcessStdout("Running " + this.cliSetup.size() + " setup commands");
            for (CliEntry cliEntry : this.cliSetup) {
                this.runOpenSearchBinScript(cliEntry.executable, cliEntry.args);
            }
        }
        this.logToProcessStdout("Starting " + this.currentConfig.distroName + " process");
        this.startOpenSearchProcess();
    }

    private boolean canUseSharedDistribution() {
        return OS.current() != OS.WINDOWS && this.extraJarFiles.size() == 0 && this.modules.size() == 0 && this.plugins.size() == 0;
    }

    private void logToProcessStdout(String message) {
        try {
            if (!Files.exists(this.currentConfig.stdoutFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.currentConfig.stdoutFile.getParent(), new FileAttribute[0]);
            }
            Files.write(this.currentConfig.stdoutFile, ("[" + Instant.now().toString() + "] [BUILD] " + message + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void restart() {
        LOGGER.info("Restarting {}", (Object)this);
        this.stop(false);
        this.start();
    }

    void goToNextVersion() {
        if (this.currentDistro + 1 >= this.distributions.size()) {
            throw new TestClustersException("Ran out of versions to go to for " + this);
        }
        this.logToProcessStdout("Switch version from " + this.getVersion() + " to " + this.distributions.get(this.currentDistro + 1).getVersion());
        ++this.currentDistro;
        this.applyConfig();
        this.setting("node.attr.upgraded", "true");
    }

    private void copyExtraConfigFiles() {
        if (!this.extraConfigFiles.isEmpty()) {
            this.logToProcessStdout("Setting up " + this.extraConfigFiles.size() + " additional config files");
        }
        this.extraConfigFiles.forEach((destination, from) -> {
            if (!Files.exists(from.toPath(), new LinkOption[0])) {
                throw new TestClustersException("Can't create extra config file from " + from + " for " + this + " as it does not exist");
            }
            Path dst = this.currentConfig.configFile.getParent().resolve((String)destination);
            try {
                Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                Files.copy(from.toPath(), dst, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("Added extra config file {} for {}", destination, (Object)this);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't create extra config file for", e);
            }
        });
    }

    private void copyExtraJars() {
        if (!this.extraJarFiles.isEmpty()) {
            this.logToProcessStdout("Setting up " + this.extraJarFiles.size() + " additional jar dependencies");
        }
        this.extraJarFiles.forEach(from -> {
            Path destination = this.getDistroDir().resolve("lib").resolve(from.getName());
            try {
                Files.copy(from.toPath(), destination, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("Added extra jar {} to {}", (Object)from.getName(), (Object)destination);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't copy extra jar dependency " + from.getName() + " to " + destination.toString(), e);
            }
        });
    }

    private void installModules() {
        if (this.testDistribution == TestDistribution.INTEG_TEST) {
            this.logToProcessStdout("Installing " + this.modules.size() + "modules");
            for (Provider<File> module : this.modules) {
                Path destination = this.getDistroDir().resolve("modules").resolve(((File)module.get()).getName().replace(".zip", "").replace("-" + this.getVersion(), "").replace("-SNAPSHOT", ""));
                if (Files.exists(destination, new LinkOption[0])) continue;
                this.fileSystemOperations.copy(spec -> {
                    if (((File)module.get()).getName().toLowerCase().endsWith(".zip")) {
                        spec.from(new Object[]{this.archiveOperations.zipTree((Object)module)});
                    } else if (((File)module.get()).isDirectory()) {
                        spec.from(new Object[]{module});
                    } else {
                        throw new IllegalArgumentException("Not a valid module " + module + " for " + this);
                    }
                    spec.into((Object)destination);
                });
            }
        } else {
            LOGGER.info("Not installing " + this.modules.size() + "(s) since the " + this.distributions + " distribution already has them");
        }
    }

    @Override
    public void extraConfigFile(String destination, File from) {
        if (destination.contains("..")) {
            throw new IllegalArgumentException("extra config file destination can't be relative, was " + destination + " for " + this);
        }
        this.extraConfigFiles.put(destination, from);
    }

    @Override
    public void extraConfigFile(String destination, File from, PropertyNormalization normalization) {
        if (destination.contains("..")) {
            throw new IllegalArgumentException("extra config file destination can't be relative, was " + destination + " for " + this);
        }
        this.extraConfigFiles.put(destination, from, normalization);
    }

    @Override
    public void extraJarFile(File from) {
        if (!from.toString().endsWith(".jar")) {
            throw new IllegalArgumentException("extra jar file " + from.toString() + " doesn't appear to be a JAR");
        }
        this.extraJarFiles.add(from);
    }

    @Override
    public void user(Map<String, String> userSpec) {
    }

    private void runOpenSearchBinScriptWithInput(String input, String tool, CharSequence ... args) {
        if (!Files.exists(this.getDistroDir().resolve("bin").resolve(tool), new LinkOption[0]) && !Files.exists(this.getDistroDir().resolve("bin").resolve(tool + ".bat"), new LinkOption[0])) {
            throw new TestClustersException("Can't run bin script: `" + tool + "` does not exist. Is this the distribution you expect it to be ?");
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            LoggedExec.exec(this.project, (Action<ExecSpec>)((Action)spec -> {
                spec.setEnvironment(this.getOpenSearchEnvironment());
                spec.workingDir((Object)this.getDistroDir());
                spec.executable((Object)OS.conditionalString().onUnix(() -> "./bin/" + tool).onWindows(() -> "cmd").supply());
                spec.args((Iterable)OS.conditional().onWindows(() -> {
                    ArrayList<Object> result = new ArrayList<Object>();
                    result.add("/c");
                    result.add("bin\\" + tool + ".bat");
                    for (CharSequence arg : args) {
                        result.add(arg);
                    }
                    return result;
                }).onUnix(() -> Arrays.asList(args)).supply());
                spec.setStandardInput(byteArrayInputStream);
            }));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to run " + tool + " for " + this, e);
        }
    }

    private void runKeystoreCommandWithPassword(String keystorePassword, String input, CharSequence ... args) {
        String actualInput = keystorePassword.length() > 0 ? keystorePassword + "\n" + input : input;
        this.runOpenSearchBinScriptWithInput(actualInput, this.currentConfig.keystoreTool, args);
    }

    private void runOpenSearchBinScript(String tool, CharSequence ... args) {
        this.runOpenSearchBinScriptWithInput("", tool, args);
    }

    private Map<String, String> getOpenSearchEnvironment() {
        HashMap<String, String> defaultEnv = new HashMap<String, String>();
        this.getRequiredJavaHome().ifPresent(javaHome -> defaultEnv.put("JAVA_HOME", (String)javaHome));
        defaultEnv.put(this.currentConfig.envPathConf, this.currentConfig.configFile.getParent().toString());
        Object systemPropertiesString = "";
        if (!this.systemProperties.isEmpty()) {
            systemPropertiesString = " " + this.systemProperties.entrySet().stream().map(entry -> "-D" + (String)entry.getKey() + "=" + entry.getValue()).map(p -> p.replace("${" + this.currentConfig.envPathConf + "}", this.currentConfig.configFile.getParent().toString())).collect(Collectors.joining(" "));
        }
        Object jvmArgsString = "";
        if (!this.jvmArgs.isEmpty()) {
            jvmArgsString = " " + this.jvmArgs.stream().peek(argument -> {
                if (argument.toString().startsWith("-D")) {
                    throw new TestClustersException("Invalid jvm argument `" + argument + "` configure as systemProperty instead for " + this);
                }
            }).collect(Collectors.joining(" "));
        }
        String heapSize = System.getProperty("tests.heap.size", "512m");
        defaultEnv.put(this.currentConfig.envJavaOpts, "-Xms" + heapSize + " -Xmx" + heapSize + " -ea -esa " + (String)systemPropertiesString + " " + (String)jvmArgsString + " " + System.getProperty("tests.jvm.argline", ""));
        defaultEnv.put(this.currentConfig.envTempDir, this.tmpDir.toString());
        defaultEnv.put("TMP", this.tmpDir.toString());
        defaultEnv.put("HOSTNAME", HOSTNAME_OVERRIDE);
        defaultEnv.put("COMPUTERNAME", COMPUTERNAME_OVERRIDE);
        HashSet<String> commonKeys = new HashSet<String>(this.environment.keySet());
        commonKeys.retainAll(defaultEnv.keySet());
        if (!commonKeys.isEmpty()) {
            throw new IllegalStateException("testcluster does not allow overwriting the following env vars " + commonKeys + " for " + this);
        }
        this.environment.forEach((key, value) -> defaultEnv.put((String)key, value.toString()));
        return defaultEnv;
    }

    private java.util.Optional<String> getRequiredJavaHome() {
        if (this.getTestDistribution() == TestDistribution.INTEG_TEST || this.getVersion().equals(VersionProperties.getOpenSearchVersion())) {
            return java.util.Optional.of(BuildParams.getRuntimeJavaHome()).map(File::getAbsolutePath);
        }
        if (this.getVersion().before("7.0.0")) {
            return java.util.Optional.of(this.bwcJdk.getJavaHomePath().toString());
        }
        return java.util.Optional.empty();
    }

    @Internal
    Jdk getBwcJdk() {
        return this.getVersion().before("7.0.0") ? this.bwcJdk : null;
    }

    private void startOpenSearchProcess() {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Path effectiveDistroDir = this.getDistroDir();
        List command = OS.conditional().onUnix(() -> Arrays.asList(effectiveDistroDir.resolve("./bin/" + this.currentConfig.command).toString())).onWindows(() -> Arrays.asList("cmd", "/c", effectiveDistroDir.resolve("bin\\" + this.currentConfig.command + ".bat").toString())).supply();
        processBuilder.command(command);
        processBuilder.directory(this.workingDir.toFile());
        Map<String, String> environment = processBuilder.environment();
        environment.clear();
        environment.putAll(this.getOpenSearchEnvironment());
        processBuilder.redirectError(ProcessBuilder.Redirect.appendTo(this.currentConfig.stderrFile.toFile()));
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(this.currentConfig.stdoutFile.toFile()));
        if (this.keystorePassword != null && this.keystorePassword.length() > 0) {
            try {
                Files.write(this.currentConfig.stdinFile, (this.keystorePassword + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                processBuilder.redirectInput(this.currentConfig.stdinFile.toFile());
            }
            catch (IOException e) {
                throw new TestClustersException("Failed to set the keystore password for " + this, e);
            }
        }
        LOGGER.info("Running `{}` in `{}` for {} env: {}", new Object[]{command, this.workingDir, this, environment});
        try {
            this.opensearchProcess = processBuilder.start();
        }
        catch (IOException e) {
            throw new TestClustersException("Failed to start " + this.currentConfig.command + " process for " + this, e);
        }
        this.reaper.registerPid(this.toString(), this.opensearchProcess.pid());
    }

    @Internal
    public Path getDistroDir() {
        return this.canUseSharedDistribution() ? this.getExtractedDistributionDir().toFile().listFiles()[0].toPath() : this.workingDir.resolve("distro").resolve(this.getVersion() + "-" + this.testDistribution);
    }

    @Override
    @Internal
    public String getHttpSocketURI() {
        return this.getHttpPortInternal().get(0);
    }

    @Override
    @Internal
    public String getTransportPortURI() {
        return this.getTransportPortInternal().get(0);
    }

    @Override
    @Internal
    public List<String> getAllHttpSocketURI() {
        this.waitForAllConditions();
        return this.getHttpPortInternal();
    }

    @Override
    @Internal
    public List<String> getAllTransportPortURI() {
        this.waitForAllConditions();
        return this.getTransportPortInternal();
    }

    @Internal
    public File getServerLog() {
        return this.confPathLogs.resolve(this.defaultConfig.get("cluster.name") + "_server.json").toFile();
    }

    @Internal
    public File getAuditLog() {
        return this.confPathLogs.resolve(this.defaultConfig.get("cluster.name") + "_audit.json").toFile();
    }

    @Override
    public synchronized void stop(boolean tailLogs) {
        this.logToProcessStdout("Stopping node");
        try {
            if (Files.exists(this.httpPortsFile, new LinkOption[0])) {
                Files.delete(this.httpPortsFile);
            }
            if (Files.exists(this.transportPortFile, new LinkOption[0])) {
                Files.delete(this.transportPortFile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (this.opensearchProcess == null && tailLogs) {
            return;
        }
        LOGGER.info("Stopping `{}`, tailLogs: {}", (Object)this, (Object)tailLogs);
        Objects.requireNonNull(this.opensearchProcess, "Can't stop `" + this + "` as it was not started or already stopped.");
        this.stopProcess(this.opensearchProcess.toHandle(), true);
        this.reaper.unregister(this.toString());
        if (tailLogs) {
            this.logFileContents("Standard output of node", this.currentConfig.stdoutFile);
            this.logFileContents("Standard error of node", this.currentConfig.stderrFile);
        }
        this.opensearchProcess = null;
        try {
            if (Files.exists(this.httpPortsFile, new LinkOption[0])) {
                Files.delete(this.httpPortsFile);
            }
            if (Files.exists(this.transportPortFile, new LinkOption[0])) {
                Files.delete(this.transportPortFile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNameCustomization(Function<String, String> nameCustomizer) {
        this.nameCustomization = nameCustomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopProcess(ProcessHandle processHandle, boolean forcibly) {
        if (!processHandle.isAlive()) {
            LOGGER.info("Process was not running when we tried to terminate it.");
            return;
        }
        List<ProcessHandle> children = processHandle.children().collect(Collectors.toList());
        try {
            this.logProcessInfo("Terminating " + this.currentConfig.command + " process" + (forcibly ? " forcibly " : "gracefully") + ":", processHandle.info());
            if (forcibly) {
                processHandle.destroyForcibly();
            } else {
                processHandle.destroy();
                this.waitForProcessToExit(processHandle);
                if (!processHandle.isAlive()) {
                    return;
                }
                LOGGER.info("process did not terminate after {} {}, stopping it forcefully", (Object)20, (Object)OPENSEARCH_DESTROY_TIMEOUT_UNIT);
                processHandle.destroyForcibly();
            }
            this.waitForProcessToExit(processHandle);
            if (processHandle.isAlive()) {
                throw new TestClustersException("Was not able to terminate " + this.currentConfig.command + " process for " + this);
            }
        }
        finally {
            children.forEach(each -> this.stopProcess((ProcessHandle)each, forcibly));
        }
        this.waitForProcessToExit(processHandle);
        if (processHandle.isAlive()) {
            throw new TestClustersException("Was not able to terminate " + this.currentConfig.command + " process for " + this);
        }
    }

    private void logProcessInfo(String prefix, ProcessHandle.Info info) {
        LOGGER.info(prefix + " commandLine:`{}` command:`{}` args:`{}`", new Object[]{info.commandLine().orElse("-"), info.command().orElse("-"), Arrays.stream(info.arguments().orElse(new String[0])).map(each -> "'" + each + "'").collect(Collectors.joining(" "))});
    }

    private void logFileContents(String description, Path from) {
        LinkedHashMap<String, Integer> errorsAndWarnings = new LinkedHashMap<String, Integer>();
        LinkedList<String> ring = new LinkedList<String>();
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(from));){
            String line2 = reader.readLine();
            while (line2 != null) {
                Object lineToAdd;
                if (ring.isEmpty()) {
                    lineToAdd = line2;
                } else if (line2.startsWith("[")) {
                    lineToAdd = line2;
                    String previousMessage = this.normalizeLogLine((String)ring.getLast());
                    if (MESSAGES_WE_DONT_CARE_ABOUT.stream().noneMatch(previousMessage::contains) && (previousMessage.contains("ERROR") || previousMessage.contains("WARN"))) {
                        errorsAndWarnings.put(previousMessage, errorsAndWarnings.getOrDefault(previousMessage, 0) + 1);
                    }
                } else {
                    lineToAdd = (String)ring.removeLast() + "\n" + line2;
                }
                ring.add((String)lineToAdd);
                if (ring.size() >= 40) {
                    ring.removeFirst();
                }
                line2 = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to tail log " + this, e);
        }
        if (!errorsAndWarnings.isEmpty() || !ring.isEmpty()) {
            LOGGER.error("\n=== {} `{}` ===", (Object)description, (Object)this);
        }
        if (!errorsAndWarnings.isEmpty()) {
            LOGGER.lifecycle("\n\u00bb    \u2193 errors and warnings from " + from + " \u2193");
            errorsAndWarnings.forEach((message, count) -> {
                LOGGER.lifecycle("\u00bb " + message.replace("\n", "\n\u00bb  "));
                if (count > 1) {
                    LOGGER.lifecycle("\u00bb   \u2191 repeated " + count + " times \u2191");
                }
            });
        }
        ring.removeIf(line -> MESSAGES_WE_DONT_CARE_ABOUT.stream().anyMatch(line::contains));
        if (!ring.isEmpty()) {
            LOGGER.lifecycle("\u00bb   \u2193 last 40 non error or warning messages from " + from + " \u2193");
            ring.forEach(message -> {
                if (!errorsAndWarnings.containsKey(this.normalizeLogLine((String)message))) {
                    LOGGER.lifecycle("\u00bb " + message.replace("\n", "\n\u00bb  "));
                }
            });
        }
    }

    private String normalizeLogLine(String line) {
        if (line.contains("ERROR")) {
            return line.substring(line.indexOf("ERROR"));
        }
        if (line.contains("WARN")) {
            return line.substring(line.indexOf("WARN"));
        }
        return line;
    }

    private void waitForProcessToExit(ProcessHandle processHandle) {
        try {
            processHandle.onExit().get(20L, OPENSEARCH_DESTROY_TIMEOUT_UNIT);
        }
        catch (InterruptedException e) {
            LOGGER.info("Interrupted while waiting for {} process", (Object)this.currentConfig.command, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.info("Failure while waiting for process to exist", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOGGER.info("Timed out waiting for process to exit", (Throwable)e);
        }
    }

    private void createWorkingDir() throws IOException {
        this.fileSystemOperations.delete(d -> d.delete(new Object[]{this.currentConfig.configFile.getParent()}));
        Files.createDirectories(this.currentConfig.configFile.getParent(), new FileAttribute[0]);
        Files.createDirectories(this.confPathRepo, new FileAttribute[0]);
        Files.createDirectories(this.confPathData, new FileAttribute[0]);
        Files.createDirectories(this.confPathLogs, new FileAttribute[0]);
        Files.createDirectories(this.tmpDir, new FileAttribute[0]);
    }

    private void setupNodeDistribution(Path distroExtractDir) throws IOException {
        if (!this.canUseSharedDistribution()) {
            this.logToProcessStdout("Configuring custom cluster specific distro directory: " + this.getDistroDir());
            if (!Files.exists(this.getDistroDir(), new LinkOption[0])) {
                try {
                    this.syncWithLinks(distroExtractDir, this.getDistroDir());
                }
                catch (LinkCreationException e) {
                    LOGGER.info("Failed to create working dir using hard links. Falling back to copy", (Throwable)e);
                    FileUtils.deleteDirectory((File)this.getDistroDir().toFile());
                    this.syncWithCopy(distroExtractDir, this.getDistroDir());
                }
            }
        }
    }

    private void syncWithLinks(Path sourceRoot, Path destinationRoot) {
        this.sync(sourceRoot, destinationRoot, (d, s) -> {
            try {
                Files.createLink(d, s);
            }
            catch (IOException e) {
                throw new LinkCreationException("Failed to create hard link " + d + " pointing to " + s, e);
            }
        });
    }

    private void syncWithCopy(Path sourceRoot, Path destinationRoot) {
        this.sync(sourceRoot, destinationRoot, (d, s) -> {
            try {
                Files.copy(s, d, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to copy " + s + " to " + d, e);
            }
        });
    }

    private void sync(Path sourceRoot, Path destinationRoot, BiConsumer<Path, Path> syncMethod) {
        assert (!Files.exists(destinationRoot, new LinkOption[0]));
        try (Stream<Path> stream = Files.walk(sourceRoot, new FileVisitOption[0]);){
            stream.forEach(source -> {
                Path relativeDestination = sourceRoot.relativize((Path)source);
                if (relativeDestination.getNameCount() <= 1) {
                    return;
                }
                relativeDestination = relativeDestination.subpath(1, relativeDestination.getNameCount());
                Path destination = destinationRoot.resolve(relativeDestination);
                if (Files.isDirectory(source, new LinkOption[0])) {
                    try {
                        Files.createDirectories(destination, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Can't create directory " + destination.getParent(), e);
                    }
                }
                try {
                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Can't create directory " + destination.getParent(), e);
                }
                syncMethod.accept(destination, (Path)source);
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't walk source " + sourceRoot, e);
        }
    }

    private void createConfiguration() {
        String nodeName = this.nameCustomization.apply(this.safeName(this.name));
        HashMap<String, String> baseConfig = new HashMap<String, String>(this.defaultConfig);
        if (nodeName != null) {
            baseConfig.put("node.name", nodeName);
        }
        baseConfig.put("path.repo", this.confPathRepo.toAbsolutePath().toString());
        baseConfig.put("path.data", this.confPathData.toAbsolutePath().toString());
        baseConfig.put("path.logs", this.confPathLogs.toAbsolutePath().toString());
        baseConfig.put("path.shared_data", this.workingDir.resolve("sharedData").toString());
        baseConfig.put("node.attr.testattr", "test");
        baseConfig.put("node.portsfile", "true");
        baseConfig.put("http.port", this.httpPort);
        if (this.getVersion().onOrAfter(Version.fromString("6.7.0"))) {
            baseConfig.put("transport.port", this.transportPort);
        } else {
            baseConfig.put("transport.tcp.port", this.transportPort);
        }
        baseConfig.put("cluster.routing.allocation.disk.watermark.low", "1b");
        baseConfig.put("cluster.routing.allocation.disk.watermark.high", "1b");
        if (this.getVersion().onOrAfter(Version.fromString("7.9.0"))) {
            baseConfig.put("script.disable_max_compilations_rate", "true");
        } else {
            baseConfig.put("script.max_compilations_rate", "2048/1m");
        }
        baseConfig.put("cluster.routing.allocation.disk.watermark.flood_stage", "1b");
        if (this.getVersion().onOrAfter("7.0.0")) {
            baseConfig.put("indices.breaker.total.use_real_memory", "false");
        }
        baseConfig.put("discovery.initial_state_timeout", "0s");
        if (this.getVersion().onOrAfter("1.0.0")) {
            baseConfig.put("logger.org.opensearch.action.support.master", "DEBUG");
            baseConfig.put("logger.org.opensearch.cluster.coordination", "DEBUG");
        } else {
            baseConfig.put("logger.org.elasticsearch.action.support.master", "DEBUG");
            baseConfig.put("logger.org.elasticsearch.cluster.coordination", "DEBUG");
        }
        HashSet overriden = new HashSet(baseConfig.keySet());
        overriden.retainAll(this.settings.keySet());
        overriden.removeAll(OVERRIDABLE_SETTINGS);
        if (!overriden.isEmpty()) {
            throw new IllegalArgumentException("Testclusters does not allow the following settings to be changed:" + overriden + " for " + this);
        }
        this.settings.keySet().stream().filter(OVERRIDABLE_SETTINGS::contains).forEach(baseConfig::remove);
        Path configFileRoot = this.currentConfig.configFile.getParent();
        try {
            List configFiles;
            Files.write(this.currentConfig.configFile, Stream.concat(this.settings.entrySet().stream(), baseConfig.entrySet().stream()).map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            try (Stream<Path> stream = Files.list(this.getDistroDir().resolve("config"));){
                configFiles = stream.collect(Collectors.toList());
            }
            this.logToProcessStdout("Copying additional config files from distro " + configFiles);
            for (Path file : configFiles) {
                Path dest = this.currentConfig.configFile.getParent().resolve(file.getFileName());
                if (Files.exists(dest, new LinkOption[0])) continue;
                Files.copy(file, dest, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not write config file: " + this.currentConfig.configFile, e);
        }
        this.tweakJvmOptions(configFileRoot);
        LOGGER.info("Written config file:{} for {}", (Object)this.currentConfig.configFile, (Object)this);
    }

    private void tweakJvmOptions(Path configFileRoot) {
        LOGGER.info("Tweak jvm options {}.", (Object)configFileRoot.resolve("jvm.options"));
        Path jvmOptions = configFileRoot.resolve("jvm.options");
        try {
            String content = new String(Files.readAllBytes(jvmOptions));
            Map<String, String> expansions = this.jvmOptionExpansions();
            for (String origin : expansions.keySet()) {
                if (!content.contains(origin)) {
                    throw new IOException("template property " + origin + " not found in template.");
                }
                content = content.replace(origin, expansions.get(origin));
            }
            Files.write(jvmOptions, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
    }

    private Map<String, String> jvmOptionExpansions() {
        HashMap<String, String> expansions = new HashMap<String, String>();
        Version version = this.getVersion();
        String heapDumpOrigin = this.getVersion().onOrAfter("6.3.0") ? "-XX:HeapDumpPath=data" : "-XX:HeapDumpPath=/heap/dump/path";
        Path relativeLogPath = this.workingDir.relativize(this.confPathLogs);
        expansions.put(heapDumpOrigin, "-XX:HeapDumpPath=" + relativeLogPath.toString());
        if (version.onOrAfter("6.2.0")) {
            expansions.put("logs/gc.log", relativeLogPath.resolve("gc.log").toString());
        }
        if (this.getVersion().onOrAfter("7.0.0")) {
            expansions.put("-XX:ErrorFile=logs/hs_err_pid%p.log", "-XX:ErrorFile=" + relativeLogPath.resolve("hs_err_pid%p.log").toString());
        }
        return expansions;
    }

    private void checkFrozen() {
        if (this.configurationFrozen.get()) {
            throw new IllegalStateException("Configuration for " + this + " can not be altered, already locked");
        }
    }

    private List<String> getTransportPortInternal() {
        try {
            return this.readPortsFile(this.transportPortFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read transport ports file: " + this.transportPortFile + " for " + this, e);
        }
    }

    private List<String> getHttpPortInternal() {
        try {
            return this.readPortsFile(this.httpPortsFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read http ports file: " + this.httpPortsFile + " for " + this, e);
        }
    }

    private List<String> readPortsFile(Path file) throws IOException {
        try (Stream<String> lines = Files.lines(file, StandardCharsets.UTF_8);){
            List<String> list = lines.map(String::trim).collect(Collectors.toList());
            return list;
        }
    }

    private Path getExtractedDistributionDir() {
        return this.distributions.get(this.currentDistro).getExtracted().getSingleFile().toPath();
    }

    private List<Provider<List<File>>> getInstalledFileSet(Action<? super PatternFilterable> filter) {
        return Stream.concat(this.plugins.stream(), this.modules.stream()).map(p -> p.map(f -> {
            if (f.exists()) {
                FileTree tree = this.archiveOperations.zipTree(f).matching(filter);
                return tree.getFiles();
            }
            return new HashSet();
        })).map(p -> p.map(f -> f.stream().sorted(Comparator.comparing(File::getName)).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    @Classpath
    public List<Provider<List<File>>> getInstalledClasspath() {
        return this.getInstalledFileSet((Action<? super PatternFilterable>)((Action)filter -> filter.include(new String[]{"**/*.jar"})));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<Provider<List<File>>> getInstalledFiles() {
        return this.getInstalledFileSet((Action<? super PatternFilterable>)((Action)filter -> filter.exclude(new String[]{"**/*.jar"})));
    }

    @Classpath
    public List<FileTree> getDistributionClasspath() {
        return this.getDistributionFiles((Action<PatternFilterable>)((Action)filter -> filter.include(new String[]{"**/*.jar"})));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<FileTree> getDistributionFiles() {
        return this.getDistributionFiles((Action<PatternFilterable>)((Action)filter -> filter.exclude(new String[]{"**/*.jar"})));
    }

    private List<FileTree> getDistributionFiles(Action<PatternFilterable> patternFilter) {
        ArrayList<FileTree> files = new ArrayList<FileTree>();
        for (OpenSearchDistribution distribution : this.distributions) {
            files.add(distribution.getExtracted().getAsFileTree().matching(patternFilter));
        }
        return files;
    }

    @Nested
    public List<?> getKeystoreSettings() {
        return this.keystoreSettings.getNormalizedCollection();
    }

    @Nested
    public List<?> getKeystoreFiles() {
        return this.keystoreFiles.getNormalizedCollection();
    }

    @Nested
    public List<?> getCliSetup() {
        return this.cliSetup.getFlatNormalizedCollection();
    }

    @Nested
    public List<?> getSettings() {
        return this.settings.getNormalizedCollection();
    }

    @Nested
    public List<?> getSystemProperties() {
        return this.systemProperties.getNormalizedCollection();
    }

    @Nested
    public List<?> getEnvironment() {
        return this.environment.getNormalizedCollection();
    }

    @Nested
    public List<?> getJvmArgs() {
        return this.jvmArgs.getNormalizedCollection();
    }

    @Nested
    public List<?> getExtraConfigFiles() {
        return this.extraConfigFiles.getNormalizedCollection();
    }

    @Override
    @Internal
    public boolean isProcessAlive() {
        Objects.requireNonNull(this.opensearchProcess, "Can't wait for `" + this + "` as it's not started. Does the task have `useCluster` ?");
        return this.opensearchProcess.isAlive();
    }

    void waitForAllConditions() {
        this.waitForConditions(this.waitConditions, System.currentTimeMillis(), NODE_UP_TIMEOUT_UNIT.toMillis(2L) + ADDITIONAL_CONFIG_TIMEOUT_UNIT.toMillis(15 * (this.plugins.size() + this.keystoreFiles.size() + this.keystoreSettings.size() + this.credentials.size())), TimeUnit.MILLISECONDS, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSearchNode that = (OpenSearchNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.path);
    }

    public String toString() {
        return "node{" + this.path + ":" + this.name + "}";
    }

    @Input
    List<Map<String, String>> getCredentials() {
        return this.credentials;
    }

    private boolean checkPortsFilesExistWithDelay(TestClusterConfiguration node) {
        if (Files.exists(this.httpPortsFile, new LinkOption[0]) && Files.exists(this.transportPortFile, new LinkOption[0])) {
            return true;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TestClustersException("Interrupted while waiting for ports files", e);
        }
        return Files.exists(this.httpPortsFile, new LinkOption[0]) && Files.exists(this.transportPortFile, new LinkOption[0]);
    }

    void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
    }

    void setTransportPort(String transportPort) {
        this.transportPort = transportPort;
    }

    void setDataPath(Path dataPath) {
        this.confPathData = dataPath;
    }

    @Internal
    Path getOpensearchStdoutFile() {
        return this.currentConfig.stdoutFile;
    }

    @Internal
    Path getOpensearchStderrFile() {
        return this.currentConfig.stderrFile;
    }

    private static class Config {
        final String distroName;
        final String command;
        final String keystoreTool;
        final String pluginTool;
        final String envTempDir;
        final String envJavaOpts;
        final String envPathConf;
        final Path configFile;
        final Path stdoutFile;
        final Path stderrFile;
        final Path stdinFile;

        Config(String distroName, String command, String keystoreTool, String pluginTool, String envTempDir, String envJavaOpts, String envPathConf, Path configFile, Path stdoutFile, Path stderrFile, Path stdinFile) {
            this.distroName = distroName;
            this.command = command;
            this.keystoreTool = keystoreTool;
            this.pluginTool = pluginTool;
            this.envTempDir = envTempDir;
            this.envJavaOpts = envJavaOpts;
            this.envPathConf = envPathConf;
            this.configFile = configFile;
            this.stdoutFile = stdoutFile;
            this.stderrFile = stderrFile;
            this.stdinFile = stdinFile;
        }

        static Config getOpenSearchConfig(Path workingDir) {
            Path confPathLogs = workingDir.resolve("logs");
            return new Config("OpenSearch", "opensearch", "opensearch-keystore", "opensearch-plugin", "OPENSEARCH_TMPDIR", "OPENSEARCH_JAVA_OPTS", "OPENSEARCH_PATH_CONF", workingDir.resolve("config/opensearch.yml"), confPathLogs.resolve("opensearch.stdout.log"), confPathLogs.resolve("opensearch.stderr.log"), workingDir.resolve("opensearch.stdin"));
        }

        static Config getLegacyESConfig(Path workingDir) {
            Path confPathLogs = workingDir.resolve("logs");
            return new Config("Elasticsearch", "elasticsearch", "elasticsearch-keystore", "elasticsearch-plugin", "ES_TMPDIR", "ES_JAVA_OPTS", "ES_PATH_CONF", workingDir.resolve("config/elasticsearch.yml"), confPathLogs.resolve("es.stdout.log"), confPathLogs.resolve("es.stderr.log"), workingDir.resolve("es.stdin"));
        }
    }

    private static class CliEntry {
        private String executable;
        private CharSequence[] args;

        CliEntry(String executable, CharSequence[] args) {
            this.executable = executable;
            this.args = args;
        }

        @Input
        public String getExecutable() {
            return this.executable;
        }

        @Input
        public CharSequence[] getArgs() {
            return this.args;
        }
    }

    private static class LinkCreationException
    extends UncheckedIOException {
        LinkCreationException(String message, IOException cause) {
            super(message, cause);
        }
    }

    private static class FileEntry
    implements Named {
        private String name;
        private File file;

        FileEntry(String name, File file) {
            this.name = name;
            this.file = file;
        }

        @Input
        public String getName() {
            return this.name;
        }

        @InputFile
        @PathSensitive(value=PathSensitivity.NONE)
        public File getFile() {
            return this.file;
        }
    }
}

