/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.precommit;

import java.nio.file.Path;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskProvider;
import org.opensearch.gradle.ExportOpenSearchBuildResourcesTask;
import org.opensearch.gradle.dependencies.CompileOnlyResolvePlugin;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.precommit.PrecommitPlugin;
import org.opensearch.gradle.precommit.ThirdPartyAuditTask;

public class ThirdPartyAuditPrecommitPlugin
extends PrecommitPlugin {
    public static final String JDK_JAR_HELL_CONFIG_NAME = "jdkJarHell";
    public static final String LIBS_OPENSEARCH_CORE_PROJECT_PATH = ":libs:opensearch-core";

    @Override
    public TaskProvider<? extends Task> createTask(Project project) {
        project.getPlugins().apply(CompileOnlyResolvePlugin.class);
        project.getConfigurations().create("forbiddenApisCliJar");
        project.getDependencies().add("forbiddenApisCliJar", (Object)"de.thetaphi:forbiddenapis:3.4");
        Configuration jdkJarHellConfig = (Configuration)project.getConfigurations().create(JDK_JAR_HELL_CONFIG_NAME);
        if (BuildParams.isInternal().booleanValue() && !project.getPath().equals(LIBS_OPENSEARCH_CORE_PROJECT_PATH)) {
            project.getDependencies().add(JDK_JAR_HELL_CONFIG_NAME, (Object)project.project(LIBS_OPENSEARCH_CORE_PROJECT_PATH));
        }
        TaskProvider resourcesTask = project.getTasks().register("thirdPartyAuditResources", ExportOpenSearchBuildResourcesTask.class);
        Path resourcesDir = project.getBuildDir().toPath().resolve("third-party-audit-config");
        resourcesTask.configure(t -> {
            t.setOutputDir(resourcesDir.toFile());
            t.copy("forbidden/third-party-audit.txt");
        });
        TaskProvider audit = project.getTasks().register("thirdPartyAudit", ThirdPartyAuditTask.class);
        audit.configure(t -> {
            t.dependsOn(new Object[]{resourcesTask});
            t.setJavaHome(BuildParams.getRuntimeJavaHome().toString());
            t.getTargetCompatibility().set(project.provider(BuildParams::getRuntimeJavaVersion));
            t.setSignatureFile(resourcesDir.resolve("forbidden/third-party-audit.txt").toFile());
        });
        project.getTasks().withType(ThirdPartyAuditTask.class).configureEach(t -> t.setJdkJarHellClasspath((FileCollection)jdkJarHellConfig));
        return audit;
    }
}

