/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.info;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.util.GradleVersion;
import org.opensearch.gradle.BwcVersions;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.info.JavaHome;
import org.opensearch.gradle.util.Util;

public class GlobalBuildInfoPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(GlobalBuildInfoPlugin.class);
    private static final String DEFAULT_LEGACY_VERSION_JAVA_FILE_PATH = "server/src/main/java/org/opensearch/LegacyESVersion.java";
    private static final String DEFAULT_VERSION_JAVA_FILE_PATH = "server/src/main/java/org/opensearch/Version.java";
    private static Integer _defaultParallel = null;
    private final JvmMetadataDetector jvmMetadataDetector;
    private final ObjectFactory objects;
    private final ProviderFactory providers;

    @Inject
    public GlobalBuildInfoPlugin(JvmMetadataDetector jvmMetadataDetector, ObjectFactory objects, ProviderFactory providers) {
        this.jvmMetadataDetector = jvmMetadataDetector;
        this.objects = objects;
        this.providers = providers;
    }

    public void apply(Project project) {
        if (project != project.getRootProject()) {
            throw new IllegalStateException(this.getClass().getName() + " can only be applied to the root project.");
        }
        GradleVersion minimumGradleVersion = GradleVersion.version((String)Util.getResourceContents("/minimumGradleVersion"));
        if (GradleVersion.current().compareTo(minimumGradleVersion) < 0) {
            throw new GradleException("Gradle " + minimumGradleVersion.getVersion() + "+ is required");
        }
        JavaVersion minimumCompilerVersion = JavaVersion.toVersion((Object)Util.getResourceContents("/minimumCompilerVersion"));
        JavaVersion minimumRuntimeVersion = JavaVersion.toVersion((Object)Util.getResourceContents("/minimumRuntimeVersion"));
        Optional<File> runtimeJavaHomeOpt = GlobalBuildInfoPlugin.findRuntimeJavaHome();
        File runtimeJavaHome = runtimeJavaHomeOpt.orElse(Jvm.current().getJavaHome());
        File rootDir = project.getRootDir();
        GitInfo gitInfo = GlobalBuildInfoPlugin.gitInfo(rootDir);
        BuildParams.init(params -> {
            boolean isInternal = GlobalBuildInfoPlugin.class.getResource("/buildSrc.marker") != null;
            params.reset();
            params.setRuntimeJavaHome(runtimeJavaHome);
            params.setRuntimeJavaVersion(this.determineJavaVersion("runtime java.home", runtimeJavaHome, minimumRuntimeVersion));
            params.setIsRuntimeJavaHomeSet(runtimeJavaHomeOpt.isPresent());
            params.setRuntimeJavaDetails(this.getJavaInstallation(runtimeJavaHome).getDisplayName());
            params.setJavaVersions(this.getAvailableJavaVersions(minimumCompilerVersion));
            params.setMinimumCompilerVersion(minimumCompilerVersion);
            params.setMinimumRuntimeVersion(minimumRuntimeVersion);
            params.setGradleJavaVersion(Jvm.current().getJavaVersion());
            params.setGitRevision(gitInfo.getRevision());
            params.setGitOrigin(gitInfo.getOrigin());
            params.setBuildDate(Util.getBuildDate(ZonedDateTime.now(ZoneOffset.UTC)));
            params.setTestSeed(GlobalBuildInfoPlugin.getTestSeed());
            params.setIsCi(System.getenv("JENKINS_URL") != null);
            params.setIsInternal(isInternal);
            params.setDefaultParallel(GlobalBuildInfoPlugin.findDefaultParallel(project));
            params.setInFipsJvm(Util.getBooleanProperty("tests.fips.enabled", false));
            params.setIsSnapshotBuild(Util.getBooleanProperty("build.snapshot", true));
            if (isInternal) {
                params.setBwcVersions(GlobalBuildInfoPlugin.resolveBwcVersions(rootDir));
            }
        });
        project.getGradle().getTaskGraph().whenReady(graph -> this.logGlobalBuildInfo());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static BwcVersions resolveBwcVersions(File root) {
        File versionsFile = new File(root, DEFAULT_VERSION_JAVA_FILE_PATH);
        File legacyVersionsFile = new File(root, DEFAULT_LEGACY_VERSION_JAVA_FILE_PATH);
        try (FileInputStream fis = new FileInputStream(versionsFile);){
            BwcVersions bwcVersions;
            try (FileInputStream fis2 = new FileInputStream(legacyVersionsFile);){
                List versionLines = IOUtils.readLines((InputStream)fis, (String)"UTF-8");
                versionLines.addAll(IOUtils.readLines((InputStream)fis2, (String)"UTF-8"));
                bwcVersions = new BwcVersions(versionLines);
            }
            return bwcVersions;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to resolve to resolve bwc versions from versionsFile.", e);
        }
    }

    private void logGlobalBuildInfo() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        Jvm gradleJvm = Jvm.current();
        String gradleJvmDetails = this.getJavaInstallation(gradleJvm.getJavaHome()).getDisplayName();
        LOGGER.quiet("=======================================");
        LOGGER.quiet("OpenSearch Build Hamster says Hello!");
        LOGGER.quiet("  Gradle Version        : " + GradleVersion.current().getVersion());
        LOGGER.quiet("  OS Info               : " + osName + " " + osVersion + " (" + osArch + ")");
        if (BuildParams.getIsRuntimeJavaHomeSet().booleanValue()) {
            String runtimeJvmDetails = this.getJavaInstallation(BuildParams.getRuntimeJavaHome()).getDisplayName();
            LOGGER.quiet("  Runtime JDK Version   : " + BuildParams.getRuntimeJavaVersion() + " (" + runtimeJvmDetails + ")");
            LOGGER.quiet("  Runtime java.home     : " + BuildParams.getRuntimeJavaHome());
            LOGGER.quiet("  Gradle JDK Version    : " + gradleJvm.getJavaVersion() + " (" + gradleJvmDetails + ")");
            LOGGER.quiet("  Gradle java.home      : " + gradleJvm.getJavaHome());
        } else {
            LOGGER.quiet("  JDK Version           : " + gradleJvm.getJavaVersion() + " (" + gradleJvmDetails + ")");
            LOGGER.quiet("  JAVA_HOME             : " + gradleJvm.getJavaHome());
        }
        LOGGER.quiet("  Random Testing Seed   : " + BuildParams.getTestSeed());
        LOGGER.quiet("  In FIPS 140 mode      : " + BuildParams.isInFipsJvm());
        LOGGER.quiet("=======================================");
    }

    private JavaVersion determineJavaVersion(String description, File javaHome, JavaVersion requiredVersion) {
        JvmInstallationMetadata installation = this.getJavaInstallation(javaHome);
        JavaVersion actualVersion = installation.getLanguageVersion();
        if (!actualVersion.isCompatibleWith(requiredVersion)) {
            GlobalBuildInfoPlugin.throwInvalidJavaHomeException(description, javaHome, Integer.parseInt(requiredVersion.getMajorVersion()), Integer.parseInt(actualVersion.getMajorVersion()));
        }
        return actualVersion;
    }

    private JvmInstallationMetadata getJavaInstallation(File javaHome) {
        InstallationLocation location = new InstallationLocation(javaHome, "Java home");
        try {
            try {
                return MethodHandles.publicLookup().findVirtual(JvmMetadataDetector.class, "getMetadata", MethodType.methodType(JvmInstallationMetadata.class, File.class)).bindTo(this.jvmMetadataDetector).invokeExact(location.getLocation());
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                return MethodHandles.publicLookup().findVirtual(JvmMetadataDetector.class, "getMetadata", MethodType.methodType(JvmInstallationMetadata.class, InstallationLocation.class)).bindTo(this.jvmMetadataDetector).invokeExact(location);
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Unable to find suitable JvmMetadataDetector::getMetadata", ex);
        }
    }

    private List<JavaHome> getAvailableJavaVersions(JavaVersion minimumCompilerVersion) {
        ArrayList<JavaHome> javaVersions = new ArrayList<JavaHome>();
        for (int v = 8; v <= Integer.parseInt(minimumCompilerVersion.getMajorVersion()); ++v) {
            int version = v;
            String javaHomeEnvVarName = GlobalBuildInfoPlugin.getJavaHomeEnvVarName(Integer.toString(version));
            if (System.getenv(javaHomeEnvVarName) == null) continue;
            File javaHomeDirectory = new File(GlobalBuildInfoPlugin.findJavaHome(Integer.toString(version)));
            JvmInstallationMetadata javaInstallation = this.getJavaInstallation(javaHomeDirectory);
            JavaHome javaHome = JavaHome.of(version, (Provider<File>)this.providers.provider(() -> {
                int actualVersion = Integer.parseInt(javaInstallation.getLanguageVersion().getMajorVersion());
                if (actualVersion != version) {
                    GlobalBuildInfoPlugin.throwInvalidJavaHomeException("env variable " + javaHomeEnvVarName, javaHomeDirectory, version, actualVersion);
                }
                return javaHomeDirectory;
            }));
            javaVersions.add(javaHome);
        }
        return javaVersions;
    }

    private static String getTestSeed() {
        String testSeed;
        String testSeedProperty = System.getProperty("tests.seed");
        if (testSeedProperty == null) {
            long seed = new Random(System.currentTimeMillis()).nextLong();
            testSeed = Long.toUnsignedString(seed, 16).toUpperCase(Locale.ROOT);
        } else {
            testSeed = testSeedProperty;
        }
        return testSeed;
    }

    private static void throwInvalidJavaHomeException(String description, File javaHome, int expectedVersion, int actualVersion) {
        String message = String.format(Locale.ROOT, "The %s must be set to a JDK installation directory for Java %d but is [%s] corresponding to [%s]", description, expectedVersion, javaHome, actualVersion);
        throw new GradleException(message);
    }

    private static Optional<File> findRuntimeJavaHome() {
        String runtimeJavaProperty = System.getProperty("runtime.java");
        if (runtimeJavaProperty != null) {
            return Optional.of(new File(GlobalBuildInfoPlugin.findJavaHome(runtimeJavaProperty)));
        }
        return System.getenv("RUNTIME_JAVA_HOME") == null ? Optional.empty() : Optional.of(new File(System.getenv("RUNTIME_JAVA_HOME")));
    }

    private static String findJavaHome(String version) {
        String versionedJavaHome = System.getenv(GlobalBuildInfoPlugin.getJavaHomeEnvVarName(version));
        if (versionedJavaHome == null) {
            String exceptionMessage = String.format(Locale.ROOT, "$%s must be set to build OpenSearch. Note that if the variable was just set you might have to run `./gradlew --stop` for it to be picked up. See https://github.com/elastic/elasticsearch/issues/31399 details.", GlobalBuildInfoPlugin.getJavaHomeEnvVarName(version));
            throw new GradleException(exceptionMessage);
        }
        return versionedJavaHome;
    }

    private static String getJavaHomeEnvVarName(String version) {
        return "JAVA" + version + "_HOME";
    }

    private static int findDefaultParallel(Project project) {
        if (_defaultParallel == null) {
            _defaultParallel = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        }
        return _defaultParallel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GitInfo gitInfo(File rootDir) {
        try {
            String revision;
            Path gitDir;
            Path head;
            Path dotGit = rootDir.toPath().resolve(".git");
            if (!Files.exists(dotGit, new LinkOption[0])) {
                return new GitInfo("unknown", "unknown");
            }
            if (Files.isDirectory(dotGit, new LinkOption[0])) {
                head = dotGit.resolve("HEAD");
                gitDir = dotGit;
            } else {
                Path workTree = Paths.get(GlobalBuildInfoPlugin.readFirstLine(dotGit).substring("gitdir:".length()).trim(), new String[0]);
                if (!Files.exists(workTree, new LinkOption[0])) {
                    return new GitInfo("unknown", "unknown");
                }
                head = workTree.resolve("HEAD");
                Path commonDir = Paths.get(GlobalBuildInfoPlugin.readFirstLine(workTree.resolve("commondir")), new String[0]);
                gitDir = commonDir.isAbsolute() ? commonDir : workTree.resolve(commonDir);
            }
            String ref = GlobalBuildInfoPlugin.readFirstLine(head);
            if (ref.startsWith("ref:")) {
                String refName = ref.substring("ref:".length()).trim();
                Path refFile = gitDir.resolve(refName);
                if (Files.exists(refFile, new LinkOption[0])) {
                    revision = GlobalBuildInfoPlugin.readFirstLine(refFile);
                    return new GitInfo(revision, GlobalBuildInfoPlugin.findOriginUrl(gitDir.resolve("config")));
                } else {
                    if (!Files.exists(gitDir.resolve("packed-refs"), new LinkOption[0])) throw new GradleException("Can't find revision for refName " + refName);
                    Pattern p = Pattern.compile("^([a-f0-9]{40}) " + refName + "$");
                    try (Stream<String> lines = Files.lines(gitDir.resolve("packed-refs"));){
                        revision = lines.map(p::matcher).filter(Matcher::matches).map(m -> m.group(1)).findFirst().orElseThrow(() -> new IOException("Packed reference not found for refName " + refName));
                        return new GitInfo(revision, GlobalBuildInfoPlugin.findOriginUrl(gitDir.resolve("config")));
                    }
                }
            } else {
                revision = ref;
            }
            return new GitInfo(revision, GlobalBuildInfoPlugin.findOriginUrl(gitDir.resolve("config")));
        }
        catch (IOException e) {
            throw new GradleException("unable to read the git revision", (Throwable)e);
        }
    }

    private static String findOriginUrl(Path configFile) throws IOException {
        String originUrl;
        HashMap<String, String> props = new HashMap<String, String>();
        try (Stream<String> stream = Files.lines(configFile, StandardCharsets.UTF_8);){
            Iterator lines = stream.iterator();
            boolean foundOrigin = false;
            while (lines.hasNext()) {
                String line = ((String)lines.next()).trim();
                if (line.startsWith(";") || line.startsWith("#")) continue;
                if (foundOrigin) {
                    if (line.startsWith("[")) {
                        break;
                    }
                    String[] pair = line.trim().split("=");
                    props.put(pair[0].trim(), pair[1].trim());
                    continue;
                }
                if (!line.equals("[remote \"origin\"]")) continue;
                foundOrigin = true;
            }
        }
        return (originUrl = (String)props.get("url")) == null ? "unknown" : originUrl;
    }

    private static String readFirstLine(Path path) throws IOException {
        String firstLine;
        try (Stream<String> lines = Files.lines(path, StandardCharsets.UTF_8);){
            firstLine = lines.findFirst().orElseThrow(() -> new IOException("file [" + path + "] is empty"));
        }
        return firstLine;
    }

    public static class GitInfo {
        private final String revision;
        private final String origin;

        GitInfo(String revision, String origin) {
            this.revision = revision;
            this.origin = origin;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getOrigin() {
            return this.origin;
        }
    }
}

