/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.util.PatternFilterable;
import org.opensearch.gradle.info.GlobalBuildInfoPlugin;
import org.opensearch.gradle.util.GradleUtils;

public class Util {
    static final Pattern GIT_PATTERN = Pattern.compile("git@([^:]+):([^\\.]+)\\.git");

    public static boolean getBooleanProperty(String property, boolean defaultValue) {
        String propertyValue = System.getProperty(property);
        if (propertyValue == null) {
            return defaultValue;
        }
        if ("true".equals(propertyValue)) {
            return true;
        }
        if ("false".equals(propertyValue)) {
            return false;
        }
        throw new GradleException("Sysprop [" + property + "] must be [true] or [false] but was [" + propertyValue + "]");
    }

    public static String getResourceContents(String resourcePath) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(GlobalBuildInfoPlugin.class.getResourceAsStream(resourcePath)));
        try {
            StringBuilder b = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                if (b.length() != 0) {
                    b.append('\n');
                }
                b.append(line);
                line = reader.readLine();
            }
            string = b.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error trying to read classpath resource: " + resourcePath, e);
            }
        }
        reader.close();
        return string;
    }

    public static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1);
    }

    public static URI getBuildSrcCodeSource() {
        try {
            return Util.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new GradleException("Error determining build tools JAR location", (Throwable)e);
        }
    }

    @Nullable
    public static FileTree getJavaMainSourceResources(Project project, Action<? super PatternFilterable> filter) {
        Optional<FileTree> mainFileTree = Util.getJavaMainSourceSet(project).map(SourceSet::getResources).map(FileTree::getAsFileTree);
        return mainFileTree.map(files -> files.matching(filter)).orElse(null);
    }

    @Nullable
    public static FileTree getJavaTestSourceResources(Project project, Action<? super PatternFilterable> filter) {
        Optional<FileTree> testFileTree = Util.getJavaTestSourceSet(project).map(SourceSet::getResources).map(FileTree::getAsFileTree);
        return testFileTree.map(files -> files.matching(filter)).orElse(null);
    }

    @Nullable
    public static FileTree getJavaTestAndMainSourceResources(Project project, Action<? super PatternFilterable> filter) {
        Optional<FileTree> testFileTree = Util.getJavaTestSourceSet(project).map(SourceSet::getResources).map(FileTree::getAsFileTree);
        Optional<FileTree> mainFileTree = Util.getJavaMainSourceSet(project).map(SourceSet::getResources).map(FileTree::getAsFileTree);
        if (testFileTree.isPresent() && mainFileTree.isPresent()) {
            return testFileTree.get().plus(mainFileTree.get()).matching(filter);
        }
        if (mainFileTree.isPresent()) {
            return mainFileTree.get().matching(filter);
        }
        if (testFileTree.isPresent()) {
            return testFileTree.get().matching(filter);
        }
        return null;
    }

    public static Optional<SourceSet> getJavaTestSourceSet(Project project) {
        return project.getConvention().findPlugin(JavaPluginConvention.class) == null ? Optional.empty() : Optional.ofNullable((SourceSet)GradleUtils.getJavaSourceSets(project).findByName("test"));
    }

    public static Optional<SourceSet> getJavaMainSourceSet(Project project) {
        return project.getConvention().findPlugin(JavaPluginConvention.class) == null ? Optional.empty() : Optional.ofNullable((SourceSet)GradleUtils.getJavaSourceSets(project).findByName("main"));
    }

    public static String urlFromOrigin(String origin) {
        if (origin == null) {
            return null;
        }
        if (origin.startsWith("https")) {
            return origin;
        }
        Matcher matcher = GIT_PATTERN.matcher(origin);
        if (matcher.matches()) {
            return String.format("https://%s/%s", matcher.group(1), matcher.group(2));
        }
        return origin;
    }

    public static Object toStringable(final Supplier<String> getter) {
        return new Object(){

            public String toString() {
                return (String)getter.get();
            }
        };
    }

    public static ZonedDateTime getBuildDate(ZonedDateTime defaultValue) {
        String sourceDateEpoch = System.getenv("SOURCE_DATE_EPOCH");
        if (sourceDateEpoch != null) {
            try {
                return ZonedDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(sourceDateEpoch)), ZoneOffset.UTC);
            }
            catch (NumberFormatException e) {
                throw new GradleException("Sysprop [SOURCE_DATE_EPOCH] must be of type [long]", (Throwable)e);
            }
        }
        return defaultValue;
    }
}

