/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.transform;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.UncheckedException;

public interface UnpackTransform
extends TransformAction<Parameters> {
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    public Provider<FileSystemLocation> getArchiveFile();

    default public void transform(TransformOutputs outputs) {
        File archiveFile = ((FileSystemLocation)this.getArchiveFile().get()).getAsFile();
        File extractedDir = outputs.dir((Object)archiveFile.getName());
        try {
            this.unpack(archiveFile, extractedDir);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void unpack(File var1, File var2) throws IOException;

    default public Function<String, Path> pathResolver() {
        String trimmedPrefixPattern = ((Parameters)this.getParameters()).getTrimmedPrefixPattern();
        return trimmedPrefixPattern != null ? i -> UnpackTransform.trimArchiveExtractPath(trimmedPrefixPattern, i) : i -> Paths.get(i, new String[0]);
    }

    public static Path trimArchiveExtractPath(String ignoredPattern, String relativePath) {
        int index;
        Path entryName = Paths.get(relativePath, new String[0]);
        for (index = 0; index < entryName.getNameCount() && !entryName.getName(index).toString().matches(ignoredPattern); ++index) {
        }
        if (index + 1 >= entryName.getNameCount()) {
            return null;
        }
        return entryName.subpath(index + 1, entryName.getNameCount());
    }

    public static interface Parameters
    extends TransformParameters {
        @Input
        @Optional
        public String getTrimmedPrefixPattern();

        public void setTrimmedPrefixPattern(String var1);
    }
}

