/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.pluginzip;

import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;

public class Publish
implements Plugin<Project> {
    private static final String DEFAULT_GROUP_ID = "org.opensearch.plugin";
    public static final String PUBLICATION_NAME = "pluginZip";
    public static final String STAGING_REPO = "zipStaging";
    public static final String LOCAL_STAGING_REPO_PATH = "/build/local-staging-repo";

    @Deprecated
    public static String getDefaultGroupId(Project project) {
        project.getLogger().warn(String.format("The 'project.group' property is empty, a default value '%s' will be used instead. Please notice that in OpenSearch 3.x the 'project.group' property will be required.", DEFAULT_GROUP_ID));
        return DEFAULT_GROUP_ID;
    }

    private boolean isZipPublicationPresent(Project project) {
        PublishingExtension pe = (PublishingExtension)project.getExtensions().findByType(PublishingExtension.class);
        if (pe == null) {
            return false;
        }
        return pe.getPublications().findByName(PUBLICATION_NAME) != null;
    }

    private void addLocalMavenRepo(Project project) {
        Path buildDirectory = project.getRootDir().toPath();
        project.getExtensions().configure(PublishingExtension.class, publishing -> publishing.repositories(repositories -> repositories.maven(maven -> {
            maven.setName(STAGING_REPO);
            maven.setUrl((Object)(buildDirectory.toString() + LOCAL_STAGING_REPO_PATH));
        })));
    }

    private void addZipArtifact(Project project) {
        project.getExtensions().configure(PublishingExtension.class, publishing -> publishing.publications(publications -> {
            MavenPublication mavenZip = (MavenPublication)publications.findByName(PUBLICATION_NAME);
            if (mavenZip != null) {
                mavenZip.artifact((Object)project.getTasks().named("bundlePlugin"));
                if (mavenZip.getGroupId().isEmpty()) {
                    mavenZip.setGroupId(Publish.getDefaultGroupId(project));
                }
            }
        }));
    }

    public void apply(Project project) {
        project.getPluginManager().apply("nebula.maven-base-publish");
        project.getPluginManager().apply(MavenPublishPlugin.class);
        project.afterEvaluate(evaluatedProject -> {
            if (this.isZipPublicationPresent(project)) {
                Set<Task> publishPluginZipPublicationToTasks;
                this.addLocalMavenRepo(project);
                this.addZipArtifact(project);
                Task validatePluginZipPom = (Task)project.getTasks().findByName("validatePluginZipPom");
                if (validatePluginZipPom != null) {
                    validatePluginZipPom.dependsOn(new Object[]{"generatePomFileForNebulaPublication"});
                }
                if (!(publishPluginZipPublicationToTasks = project.getTasks().stream().filter(t -> t.getName().startsWith("publishPluginZipPublicationTo")).collect(Collectors.toSet())).isEmpty()) {
                    publishPluginZipPublicationToTasks.forEach(t -> t.dependsOn(new Object[]{"generatePomFileForNebulaPublication"}));
                }
            } else {
                project.getLogger().warn(String.format("Plugin 'opensearch.pluginzip' is applied but no '%s' publication is defined.", PUBLICATION_NAME));
            }
        });
    }
}

