/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.opensearch.gradle.BwcVersions;
import org.opensearch.gradle.LoggedExec;
import org.opensearch.gradle.Version;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.info.GlobalBuildInfoPlugin;
import org.opensearch.gradle.internal.BwcGitExtension;
import org.opensearch.gradle.internal.BwcSetupExtension;
import org.opensearch.gradle.internal.InternalBwcGitPlugin;

public class InternalDistributionBwcSetupPlugin
implements Plugin<Project> {
    private ProviderFactory providerFactory;

    @Inject
    public InternalDistributionBwcSetupPlugin(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(GlobalBuildInfoPlugin.class);
        BuildParams.getBwcVersions().forPreviousUnreleased(unreleasedVersion -> this.configureBwcProject(project.project(unreleasedVersion.gradleProjectPath), (BwcVersions.UnreleasedVersionInfo)unreleasedVersion));
    }

    private void configureBwcProject(Project project, BwcVersions.UnreleasedVersionInfo versionInfo) {
        Provider versionInfoProvider = this.providerFactory.provider(() -> versionInfo);
        Provider checkoutDir = versionInfoProvider.map(info -> new File(project.getBuildDir(), "bwc/checkout-" + info.branch));
        BwcSetupExtension bwcSetupExtension = (BwcSetupExtension)project.getExtensions().create("bwcSetup", BwcSetupExtension.class, new Object[]{project, versionInfoProvider, checkoutDir});
        BwcGitExtension gitExtension = ((InternalBwcGitPlugin)project.getPlugins().apply(InternalBwcGitPlugin.class)).getGitExtension();
        Provider bwcVersion = versionInfoProvider.map(info -> info.version);
        gitExtension.setBwcVersion((Provider<Version>)versionInfoProvider.map(info -> info.version));
        gitExtension.setBwcBranch((Provider<String>)versionInfoProvider.map(info -> info.branch));
        gitExtension.setCheckoutDir((Provider<File>)checkoutDir);
        project.getPlugins().apply(LifecycleBasePlugin.class);
        TaskProvider buildBwcTaskProvider = project.getTasks().register("buildBwc");
        List<DistributionProject> distributionProjects = InternalDistributionBwcSetupPlugin.resolveArchiveProjects((File)checkoutDir.get(), (Version)bwcVersion.get());
        for (DistributionProject distributionProject : distributionProjects) {
            InternalDistributionBwcSetupPlugin.createBuildBwcTask(bwcSetupExtension, project, (Provider<Version>)bwcVersion, distributionProject.name, distributionProject.getProjectPath(), distributionProject.getDistFile(), (TaskProvider<Task>)buildBwcTaskProvider);
            this.registerBwcArtifacts(project, distributionProject);
        }
    }

    private void registerBwcArtifacts(Project bwcProject, DistributionProject distributionProject) {
        String projectName = distributionProject.name;
        String buildBwcTask = InternalDistributionBwcSetupPlugin.buildBwcTaskName(projectName);
        this.registerDistributionArchiveArtifact(bwcProject, distributionProject, buildBwcTask);
        if (distributionProject.getExpandedDistDirectory() != null) {
            String expandedDistConfiguration = "expanded-" + projectName;
            bwcProject.getConfigurations().create(expandedDistConfiguration);
            bwcProject.getArtifacts().add(expandedDistConfiguration, (Object)distributionProject.getExpandedDistDirectory(), artifact -> {
                artifact.setName("opensearch");
                artifact.builtBy(new Object[]{buildBwcTask});
                artifact.setType("directory");
            });
        }
    }

    private void registerDistributionArchiveArtifact(Project bwcProject, DistributionProject distributionProject, String buildBwcTask) {
        String artifactFileName = distributionProject.getDistFile().getName();
        String artifactName = "opensearch";
        String suffix = artifactFileName.endsWith("tar.gz") ? "tar.gz" : artifactFileName.substring(artifactFileName.length() - 3);
        int archIndex = artifactFileName.indexOf("x64");
        bwcProject.getConfigurations().create(distributionProject.name);
        bwcProject.getArtifacts().add(distributionProject.name, (Object)distributionProject.getDistFile(), artifact -> {
            artifact.setName(artifactName);
            artifact.builtBy(new Object[]{buildBwcTask});
            artifact.setType(suffix);
            Object classifier = "";
            if (archIndex != -1) {
                int osIndex = artifactFileName.lastIndexOf(45, archIndex - 2);
                classifier = "-" + artifactFileName.substring(osIndex + 1, archIndex - 1) + "-x64";
            }
            artifact.setClassifier((String)classifier);
        });
    }

    private static List<DistributionProject> resolveArchiveProjects(File checkoutDir, Version bwcVersion) {
        ArrayList<String> projects = new ArrayList<String>();
        projects.addAll(Arrays.asList("deb", "rpm"));
        if (bwcVersion.onOrAfter("7.0.0")) {
            projects.addAll(Arrays.asList("darwin-tar", "linux-tar", "windows-zip"));
        } else {
            projects.addAll(Arrays.asList("zip", "tar"));
        }
        return projects.stream().map(name -> {
            String baseDir = "distribution" + (name.endsWith("zip") || name.endsWith("tar") ? "/archives" : "/packages");
            Object classifier = "";
            Object extension = name;
            if (bwcVersion.onOrAfter("7.0.0")) {
                if (name.contains("zip") || name.contains("tar")) {
                    int index = name.lastIndexOf(45);
                    String baseName = name.substring(0, index);
                    classifier = "-" + baseName + "-x64";
                    extension = name.substring(index + 1);
                    if (((String)extension).equals("tar")) {
                        extension = (String)extension + ".gz";
                    }
                } else if (name.contains("deb")) {
                    classifier = "-amd64";
                } else if (name.contains("rpm")) {
                    classifier = "-x64";
                }
            } else {
                extension = name.substring(4);
            }
            return new DistributionProject((String)name, baseDir, bwcVersion, (String)classifier, (String)extension, checkoutDir);
        }).collect(Collectors.toList());
    }

    private static String buildBwcTaskName(String projectName) {
        return "buildBwc" + Arrays.stream(projectName.split("-")).map(i -> i.substring(0, 1).toUpperCase(Locale.ROOT) + i.substring(1)).collect(Collectors.joining());
    }

    static void createBuildBwcTask(BwcSetupExtension bwcSetupExtension, final Project project, final Provider<Version> bwcVersion, String projectName, final String projectPath, final File projectArtifact, TaskProvider<Task> bwcTaskProvider) {
        String bwcTaskName = InternalDistributionBwcSetupPlugin.buildBwcTaskName(projectName);
        bwcSetupExtension.bwcTask(bwcTaskName, new Action<LoggedExec>(){

            public void execute(LoggedExec c) {
                c.getInputs().file((Object)new File(project.getBuildDir(), "refspec"));
                c.getOutputs().files(new Object[]{projectArtifact});
                c.getOutputs().cacheIf("BWC distribution caching is disabled on 'master' branch", task -> {
                    String gitBranch = System.getenv("GIT_BRANCH");
                    return BuildParams.isCi() != false && (gitBranch == null || !gitBranch.endsWith("master"));
                });
                c.args(new Object[]{projectPath.replace('/', ':') + ":assemble"});
                if (project.getGradle().getStartParameter().isBuildCacheEnabled()) {
                    c.args(new Object[]{"--build-cache"});
                }
                c.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        if (!projectArtifact.exists()) {
                            throw new InvalidUserDataException("Building " + bwcVersion.get() + " didn't generate expected file " + projectArtifact);
                        }
                    }
                });
            }
        });
        bwcTaskProvider.configure(t -> t.dependsOn(new Object[]{bwcTaskName}));
    }

    private static class DistributionProject {
        private final String name;
        private String projectPath;
        private File distFile;
        private File expandedDistDir;

        DistributionProject(String name, String baseDir, Version version, String classifier, String extension, File checkoutDir) {
            this.name = name;
            this.projectPath = baseDir + "/" + name;
            this.distFile = version.onOrAfter("1.1.0") ? new File(checkoutDir, baseDir + "/" + name + "/build/distributions/opensearch-min-" + version + "-SNAPSHOT" + classifier + "." + extension) : new File(checkoutDir, baseDir + "/" + name + "/build/distributions/opensearch-" + version + "-SNAPSHOT" + classifier + "." + extension);
            if (version.onOrAfter("7.10.0") && (name.endsWith("zip") || name.endsWith("tar"))) {
                this.expandedDistDir = new File(checkoutDir, baseDir + "/" + name + "/build/install");
            }
        }

        public String getProjectPath() {
            return this.projectPath;
        }

        public File getDistFile() {
            return this.distFile;
        }

        public File getExpandedDistDirectory() {
            return this.expandedDistDir;
        }
    }
}

