/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowJar;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import nebula.plugin.info.InfoBrokerPlugin;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.opensearch.gradle.OpenSearchTestBasePlugin;
import org.opensearch.gradle.RepositoriesSetupPlugin;
import org.opensearch.gradle.VersionProperties;
import org.opensearch.gradle.info.BuildParams;
import org.opensearch.gradle.info.GlobalBuildInfoPlugin;
import org.opensearch.gradle.precommit.PrecommitTaskPlugin;
import org.opensearch.gradle.util.Util;

public class OpenSearchJavaPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(GlobalBuildInfoPlugin.class);
        project.getPluginManager().apply(RepositoriesSetupPlugin.class);
        project.getPluginManager().apply(JavaLibraryPlugin.class);
        project.getPluginManager().apply(OpenSearchTestBasePlugin.class);
        project.getPluginManager().apply(PrecommitTaskPlugin.class);
        OpenSearchJavaPlugin.configureConfigurations(project);
        OpenSearchJavaPlugin.configureCompile(project);
        OpenSearchJavaPlugin.configureInputNormalization(project);
        OpenSearchJavaPlugin.configureJars(project);
        OpenSearchJavaPlugin.configureJarManifest(project);
        OpenSearchJavaPlugin.configureJavadoc(project);
        project.getExtensions().getExtraProperties().set("versions", VersionProperties.getVersions());
    }

    public static void configureConfigurations(Project project) {
        Configuration compileOnlyConfig = project.getConfigurations().getByName("compileOnly");
        Configuration testImplementationConfig = project.getConfigurations().getByName("testImplementation");
        testImplementationConfig.extendsFrom(new Configuration[]{compileOnlyConfig});
        if (project.getPath().startsWith(":test:fixtures") || project.getPath().equals(":build-tools")) {
            return;
        }
        project.getConfigurations().all(configuration -> {
            if (configuration.getName().endsWith("Fixture")) {
                return;
            }
            configuration.resolutionStrategy(ResolutionStrategy::failOnVersionConflict);
        });
        Consumer<String> disableTransitiveDeps = configName -> {
            Configuration config = project.getConfigurations().getByName(configName);
            config.getDependencies().all(dep -> {
                if (dep instanceof ModuleDependency && !(dep instanceof ProjectDependency) && !dep.getGroup().startsWith("org.opensearch")) {
                    ((ModuleDependency)dep).setTransitive(false);
                }
            });
        };
        disableTransitiveDeps.accept("api");
        disableTransitiveDeps.accept("implementation");
        disableTransitiveDeps.accept("compileOnly");
        disableTransitiveDeps.accept("runtimeOnly");
        disableTransitiveDeps.accept("testImplementation");
    }

    public static void configureCompile(Project project) {
        project.getExtensions().getExtraProperties().set("compactProfile", (Object)"full");
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        java.setSourceCompatibility(BuildParams.getMinimumRuntimeVersion());
        java.setTargetCompatibility(BuildParams.getMinimumRuntimeVersion());
        project.afterEvaluate(p -> {
            project.getTasks().withType(JavaCompile.class).configureEach(compileTask -> {
                CompileOptions compileOptions = compileTask.getOptions();
                List compilerArgs = compileOptions.getCompilerArgs();
                if (!compilerArgs.contains("-processor")) {
                    compilerArgs.add("-proc:none");
                }
                compileOptions.setEncoding("UTF-8");
                compileOptions.setIncremental(true);
                compileTask.getConventionMapping().map("sourceCompatibility", () -> java.getSourceCompatibility().toString());
                compileTask.getConventionMapping().map("targetCompatibility", () -> java.getTargetCompatibility().toString());
                if (BuildParams.getRuntimeJavaVersion().compareTo((Enum)JavaVersion.VERSION_1_8) > 0) {
                    compileOptions.getRelease().set(OpenSearchJavaPlugin.releaseVersionProviderFromCompileTask(project, (AbstractCompile)compileTask));
                }
            });
            project.getTasks().withType(GroovyCompile.class).configureEach(compileTask -> compileTask.getOptions().getRelease().set(OpenSearchJavaPlugin.releaseVersionProviderFromCompileTask(project, (AbstractCompile)compileTask)));
        });
    }

    private static Provider<Integer> releaseVersionProviderFromCompileTask(Project project, AbstractCompile compileTask) {
        return project.provider(() -> {
            JavaVersion javaVersion = JavaVersion.toVersion((Object)compileTask.getTargetCompatibility());
            return Integer.parseInt(javaVersion.getMajorVersion());
        });
    }

    public static void configureInputNormalization(Project project) {
        project.getNormalization().getRuntimeClasspath().ignore("META-INF/MANIFEST.MF");
    }

    static void configureJars(Project project) {
        project.getTasks().withType(Jar.class).configureEach(jarTask -> {
            jarTask.getDestinationDirectory().set(new File(project.getBuildDir(), "distributions"));
            jarTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    jarTask.getManifest().attributes((Map)new HashMap<String, Object>(){
                        {
                            this.put("Build-Date", BuildParams.getBuildDate());
                            this.put("Build-Java-Version", BuildParams.getGradleJavaVersion());
                        }
                    });
                }
            });
        });
        project.getPluginManager().withPlugin("com.github.johnrengelman.shadow", p -> {
            project.getTasks().withType(ShadowJar.class).configureEach(shadowJar -> {
                shadowJar.getArchiveClassifier().set((Object)null);
                shadowJar.mergeServiceFiles();
            });
            project.getTasks().named("jar", Jar.class).configure(jar -> jar.getArchiveClassifier().set((Object)"original"));
            project.getTasks().named("assemble").configure(task -> task.dependsOn(new Object[]{"shadowJar"}));
        });
    }

    private static void configureJarManifest(Project project) {
        project.getPlugins().withType(InfoBrokerPlugin.class).whenPluginAdded(manifestPlugin -> {
            manifestPlugin.add("Module-Origin", Util.toStringable(BuildParams::getGitOrigin));
            manifestPlugin.add("Change", Util.toStringable(BuildParams::getGitRevision));
            manifestPlugin.add("X-Compile-OpenSearch-Version", Util.toStringable(VersionProperties::getOpenSearch));
            manifestPlugin.add("X-Compile-Lucene-Version", Util.toStringable(VersionProperties::getLucene));
            manifestPlugin.add("X-Compile-OpenSearch-Snapshot", Util.toStringable(() -> Boolean.toString(VersionProperties.isOpenSearchSnapshot())));
        });
        project.getPluginManager().apply("nebula.info-broker");
        project.getPluginManager().apply("nebula.info-basic");
        project.getPluginManager().apply("nebula.info-java");
        project.getPluginManager().apply("nebula.info-jar");
    }

    private static void configureJavadoc(Project project) {
        project.getTasks().withType(Javadoc.class).configureEach(javadoc -> {
            CoreJavadocOptions javadocOptions = (CoreJavadocOptions)javadoc.getOptions();
            if (BuildParams.getRuntimeJavaVersion().compareTo((Enum)JavaVersion.VERSION_1_8) > 0) {
                javadocOptions.addBooleanOption("html5", true);
            }
        });
        TaskProvider javadoc2 = project.getTasks().withType(Javadoc.class).named("javadoc");
        javadoc2.configure(doc -> doc.setClasspath(Util.getJavaMainSourceSet(project).get().getCompileClasspath()));
        project.getTasks().named("check").configure(t -> t.dependsOn(new Object[]{javadoc2}));
    }
}

