/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.os.OperatingSystem;

public class Jdk
implements Buildable,
Iterable<File> {
    private static final List<String> ALLOWED_ARCHITECTURES = Collections.unmodifiableList(Arrays.asList("aarch64", "x64", "s390x"));
    private static final List<String> ALLOWED_VENDORS = Collections.unmodifiableList(Arrays.asList("adoptium", "adoptopenjdk", "openjdk"));
    private static final List<String> ALLOWED_PLATFORMS = Collections.unmodifiableList(Arrays.asList("darwin", "freebsd", "linux", "mac", "windows"));
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(\\.\\d+\\.\\d+)?\\+(\\d+(?:\\.\\d+)?)(@([a-f0-9]{32}))?");
    private static final Pattern LEGACY_VERSION_PATTERN = Pattern.compile("(\\d)(u\\d+)(?:\\+|\\-)(b\\d+?)(@([a-f0-9]{32}))?");
    private final String name;
    private final Configuration configuration;
    private final Property<String> vendor;
    private final Property<String> version;
    private final Property<String> platform;
    private final Property<String> architecture;
    private String baseVersion;
    private String major;
    private String build;
    private String hash;

    Jdk(String name, Configuration configuration, ObjectFactory objectFactory) {
        this.name = name;
        this.configuration = configuration;
        this.vendor = objectFactory.property(String.class);
        this.version = objectFactory.property(String.class);
        this.platform = objectFactory.property(String.class);
        this.architecture = objectFactory.property(String.class);
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return (String)this.vendor.get();
    }

    public void setVendor(String vendor) {
        if (!ALLOWED_VENDORS.contains(vendor)) {
            throw new IllegalArgumentException("unknown vendor [" + vendor + "] for jdk [" + this.name + "], must be one of " + ALLOWED_VENDORS);
        }
        this.vendor.set((Object)vendor);
    }

    public String getVersion() {
        return (String)this.version.get();
    }

    public void setVersion(String version) {
        if (!VERSION_PATTERN.matcher(version).matches() && !LEGACY_VERSION_PATTERN.matcher(version).matches()) {
            throw new IllegalArgumentException("malformed version [" + version + "] for jdk [" + this.name + "]");
        }
        this.parseVersion(version);
        this.version.set((Object)version);
    }

    public String getPlatform() {
        return (String)this.platform.get();
    }

    public void setPlatform(String platform) {
        if (!ALLOWED_PLATFORMS.contains(platform)) {
            throw new IllegalArgumentException("unknown platform [" + platform + "] for jdk [" + this.name + "], must be one of " + ALLOWED_PLATFORMS);
        }
        this.platform.set((Object)platform);
    }

    public String getArchitecture() {
        return (String)this.architecture.get();
    }

    public void setArchitecture(String architecture) {
        String jdkArchitecture = this.translateJdkArchitecture(architecture);
        if (!ALLOWED_ARCHITECTURES.contains(jdkArchitecture)) {
            throw new IllegalArgumentException("unknown architecture [" + jdkArchitecture + "] for jdk [" + this.name + "], must be one of " + ALLOWED_ARCHITECTURES);
        }
        this.architecture.set((Object)jdkArchitecture);
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public String getMajor() {
        return this.major;
    }

    public String getBuild() {
        return this.build;
    }

    public String getHash() {
        return this.hash;
    }

    public String getPath() {
        return this.configuration.getSingleFile().toString();
    }

    public String getConfigurationName() {
        return this.configuration.getName();
    }

    public String toString() {
        return this.getPath();
    }

    public TaskDependency getBuildDependencies() {
        return this.configuration.getBuildDependencies();
    }

    public Object getBinJavaPath() {
        return new Object(){

            public String toString() {
                return OperatingSystem.current().getExecutableName(Jdk.this.getHomeRoot() + "/bin/java");
            }
        };
    }

    public Object getJavaHomePath() {
        return new Object(){

            public String toString() {
                return Jdk.this.getHomeRoot();
            }
        };
    }

    private String getHomeRoot() {
        boolean isOSX = "mac".equals(this.getPlatform()) || "darwin".equals(this.getPlatform());
        return this.getPath() + (isOSX ? "/Contents/Home" : "");
    }

    void finalizeValues() {
        if (!this.version.isPresent()) {
            throw new IllegalArgumentException("version not specified for jdk [" + this.name + "]");
        }
        if (!this.platform.isPresent()) {
            throw new IllegalArgumentException("platform not specified for jdk [" + this.name + "]");
        }
        if (!this.vendor.isPresent()) {
            throw new IllegalArgumentException("vendor not specified for jdk [" + this.name + "]");
        }
        if (!this.architecture.isPresent()) {
            throw new IllegalArgumentException("architecture not specified for jdk [" + this.name + "]");
        }
        this.version.finalizeValue();
        this.platform.finalizeValue();
        this.vendor.finalizeValue();
        this.architecture.finalizeValue();
    }

    @Override
    public Iterator<File> iterator() {
        return this.configuration.iterator();
    }

    private void parseVersion(String version) {
        Matcher jdkVersionMatcher = VERSION_PATTERN.matcher(version);
        if (!jdkVersionMatcher.matches() && !(jdkVersionMatcher = LEGACY_VERSION_PATTERN.matcher(version)).matches()) {
            throw new IllegalArgumentException("Malformed jdk version [" + version + "]");
        }
        this.baseVersion = jdkVersionMatcher.group(1) + (jdkVersionMatcher.group(2) != null ? jdkVersionMatcher.group(2) : "");
        this.major = jdkVersionMatcher.group(1);
        this.build = jdkVersionMatcher.group(3);
        this.hash = jdkVersionMatcher.group(5);
    }

    private String translateJdkArchitecture(String architecture) {
        return "arm64".equals(architecture) ? "aarch64" : architecture;
    }
}

